/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc.discovery;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.JacksonDeserializer;
import org.appenders.log4j2.elasticsearch.hc.BlockingResponseHandler;
import org.appenders.log4j2.elasticsearch.hc.ElasticsearchBulkAPI;
import org.appenders.log4j2.elasticsearch.hc.GenericRequest;
import org.appenders.log4j2.elasticsearch.hc.HttpClient;
import org.appenders.log4j2.elasticsearch.hc.discovery.NodeInfo;
import org.appenders.log4j2.elasticsearch.hc.discovery.NodesResponse;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscoveryCallback;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscoveryRequest;

public class ElasticsearchNodesQuery
implements ServiceDiscoveryRequest<HttpClient> {
    public static final String DEFAULT_NODES_FILTER = "_all";
    private final BlockingResponseHandler<NodesResponse> responseHandler = new BlockingResponseHandler<NodesResponse>((Deserializer<NodesResponse>)new JacksonDeserializer(ElasticsearchBulkAPI.defaultObjectMapper().readerFor(NodesResponse.class)), ex -> new NodesResponse(Collections.emptyMap()).withErrorMessage("Unable to refresh server list: " + ex.getMessage()));
    protected final String resultScheme;
    protected final String nodesFilter;

    public ElasticsearchNodesQuery(String resultScheme) {
        this(resultScheme, DEFAULT_NODES_FILTER);
    }

    public ElasticsearchNodesQuery(String resultScheme, String nodesFilter) {
        this.resultScheme = resultScheme;
        this.nodesFilter = nodesFilter;
    }

    @Override
    public void execute(HttpClient httpClient, ServiceDiscoveryCallback<List<String>> callback) {
        NodesResponse response;
        GenericRequest request = new GenericRequest("GET", String.format("_nodes/%s/http", this.nodesFilter), null);
        try {
            response = httpClient.execute(request, this.responseHandler);
        }
        catch (Exception e) {
            callback.onFailure(e);
            return;
        }
        if (response.isSucceeded()) {
            callback.onSuccess(response.getNodes().values().stream().map(this::formatAddress).collect(Collectors.toList()));
        } else {
            callback.onSuccess(Collections.emptyList());
        }
    }

    protected String formatAddress(NodeInfo info) {
        return String.format("%s://%s", this.resultScheme, info.getHttpPublishAddress().getPublishAddress());
    }
}

