/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ClientProvider;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServerInfo;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServerInfoListener;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscovery;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscoveryRequest;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

public class HCServiceDiscovery<T>
implements ServiceDiscovery,
LifeCycle,
Measured {
    private static final String NAME = HCServiceDiscovery.class.getSimpleName();
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final ClientProvider<T> clientProvider;
    private final ServiceDiscoveryRequest<T> serviceDiscoveryRequest;
    private final long refreshInterval;
    private final List<ServerInfoListener> listeners = new ArrayList<ServerInfoListener>();
    private final Map<String, ServerInfo> cache = new ConcurrentHashMap<String, ServerInfo>();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("ServiceDiscovery");
        thread.setDaemon(true);
        return thread;
    });

    public HCServiceDiscovery(ClientProvider<T> clientProvider, ServiceDiscoveryRequest<T> serviceDiscoveryRequest, long refreshInterval) {
        this.refreshInterval = refreshInterval;
        this.clientProvider = clientProvider;
        this.serviceDiscoveryRequest = serviceDiscoveryRequest;
    }

    @Override
    public void addListener(ServerInfoListener listener) {
        this.cache.clear();
        this.listeners.add(listener);
    }

    @Override
    public void refresh() {
        if (!this.isStarted()) {
            throw new IllegalStateException(NAME + " not started");
        }
        InternalLogging.getLogger().debug("{} : Refreshing address list", new Object[]{NAME});
        this.serviceDiscoveryRequest.execute(this.clientProvider.createClient(), new ServiceDiscoveryCallback());
    }

    private void processResult(List<String> addresses) {
        if (addresses.isEmpty()) {
            return;
        }
        int previousCacheSize = this.cache.size();
        ArrayList<ServerInfo> lastResult = new ArrayList<ServerInfo>();
        for (String address : addresses) {
            lastResult.add(this.cachedResult(address));
        }
        if (addresses.size() != this.cache.size()) {
            this.removeStaleEntries(lastResult);
        } else if (previousCacheSize == this.cache.size()) {
            lastResult.clear();
            return;
        }
        for (ServerInfoListener listener : this.listeners) {
            listener.onServerInfo(new ArrayList<ServerInfo>(lastResult));
        }
        lastResult.clear();
    }

    private ServerInfo cachedResult(String address) {
        if (!this.cache.containsKey(address)) {
            ServerInfo serverInfo = new ServerInfo(address);
            this.cache.put(address, serverInfo);
            InternalLogging.getLogger().info("{}: New address found: {}", new Object[]{NAME, address});
        }
        return this.cache.get(address);
    }

    private void removeStaleEntries(List<ServerInfo> lastResult) {
        Collection<ServerInfo> cachedValues = this.cache.values();
        cachedValues.retainAll(lastResult);
    }

    public void register(MetricsRegistry registry) {
        Measured.of(this.clientProvider).register(registry);
    }

    public void deregister() {
        Measured.of(this.clientProvider).deregister();
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        this.state = LifeCycle.State.STARTED;
        LifeCycle.of(this.clientProvider).start();
        InternalLogging.getLogger().debug("{}: Starting executor", new Object[]{NAME});
        this.scheduleRefreshTask();
        InternalLogging.getLogger().debug("{}: Started", new Object[]{NAME});
    }

    void scheduleRefreshTask() {
        this.executor.scheduleWithFixedDelay(new RefreshServerList(), 0L, this.refreshInterval, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.state = LifeCycle.State.STOPPED;
        InternalLogging.getLogger().debug("{}: Shutting down executor", new Object[]{NAME});
        this.executor.shutdown();
        Measured.of(this.clientProvider).deregister();
        LifeCycle.of(this.clientProvider).stop();
        this.listeners.clear();
        InternalLogging.getLogger().debug("{}: Stopped", new Object[]{NAME});
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    class RefreshServerList
    extends Thread {
        RefreshServerList() {
        }

        @Override
        public void run() {
            try {
                HCServiceDiscovery.this.refresh();
            }
            catch (Exception e) {
                InternalLogging.getLogger().error(NAME + ": Unable to refresh addresses: " + e.getMessage(), new Object[]{e});
            }
        }
    }

    class ServiceDiscoveryCallback
    implements org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscoveryCallback<List<String>> {
        ServiceDiscoveryCallback() {
        }

        @Override
        public void onSuccess(List<String> result) {
            HCServiceDiscovery.this.processResult(result);
        }

        @Override
        public void onFailure(Exception e) {
            InternalLogging.getLogger().error(NAME + ": Unable to refresh addresses: " + e.getMessage(), new Object[]{e});
        }
    }
}

