/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc.discovery;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.appenders.log4j2.elasticsearch.Auth;
import org.appenders.log4j2.elasticsearch.hc.ClientProviderPoliciesRegistry;
import org.appenders.log4j2.elasticsearch.hc.ClientProviderPolicy;
import org.appenders.log4j2.elasticsearch.hc.HttpClient;
import org.appenders.log4j2.elasticsearch.hc.HttpClientFactory;
import org.appenders.log4j2.elasticsearch.hc.HttpClientProvider;
import org.appenders.log4j2.elasticsearch.hc.discovery.ElasticsearchNodesQuery;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscovery;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscoveryFactory;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscoveryRequest;
import org.appenders.log4j2.elasticsearch.metrics.DefaultMetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfig;
import org.appenders.log4j2.elasticsearch.metrics.MetricsFactory;
import org.appenders.log4j2.elasticsearch.util.SplitUtil;

@Plugin(name="ServiceDiscovery", category="Core", elementType="serviceDiscovery", printObject=true)
public class ServiceDiscoveryFactoryPlugin
extends ServiceDiscoveryFactory<HttpClient> {
    public static final String PLUGIN_NAME = "ServiceDiscovery";

    public ServiceDiscoveryFactoryPlugin(ClientProviderPolicy<HttpClient> clientProviderPolicy, ServiceDiscoveryRequest<HttpClient> serviceDiscoveryRequest, long refreshInterval) {
        super(clientProviderPolicy, serviceDiscoveryRequest, refreshInterval);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ServiceDiscoveryFactoryPlugin> {
        public static final String DEFAULT_TARGET_SCHEME = "http";
        public static final String DEFAULT_NODES_FILTER = "_all";
        public static final long DEFAULT_REFRESH_INTERVAL = 30000L;
        public static final int DEFAULT_RESPONSE_BUFFER_SIZE = 32768;
        public static final int DEFAULT_CONN_TIMEOUT = 500;
        public static final int DEFAULT_READ_TIMEOUT = 3000;
        @PluginBuilderAttribute
        protected String nodesFilter = "_all";
        @PluginBuilderAttribute
        protected String targetScheme = "http";
        @PluginBuilderAttribute
        protected String configPolicies = "serverList,security";
        @PluginBuilderAttribute
        protected long refreshInterval = 30000L;
        @PluginBuilderAttribute
        protected String serverUris;
        @PluginBuilderAttribute
        protected int connTimeout = 500;
        @PluginBuilderAttribute
        protected int readTimeout = 3000;
        @PluginBuilderAttribute
        protected int pooledResponseBuffersSizeInBytes = 32768;
        @PluginElement(value="auth")
        protected Auth<HttpClientFactory.Builder> auth;
        @PluginBuilderAttribute
        private String name = ServiceDiscovery.class.getSimpleName();
        @PluginElement(value="metricsFactory")
        private MetricsFactory metricsFactory = new DefaultMetricsFactory(Collections.emptyList());

        public ServiceDiscoveryFactoryPlugin build() {
            this.validate();
            LinkedHashSet<String> policyNames = new LinkedHashSet<String>(SplitUtil.split((String)this.configPolicies, (String)","));
            return new ServiceDiscoveryFactoryPlugin(this.createPoliciesRegistry().get(policyNames, this.createClientProvider()), new ElasticsearchNodesQuery(this.targetScheme, this.nodesFilter), this.refreshInterval);
        }

        protected HttpClientProvider createClientProvider() {
            return new HttpClientProvider(this.createClientProviderBuilder());
        }

        protected HttpClientFactory.Builder createClientProviderBuilder() {
            return new HttpClientFactory.Builder().withServerList(SplitUtil.split((String)this.serverUris)).withConnTimeout(this.connTimeout).withReadTimeout(this.readTimeout).withMaxTotalConnections(1).withIoThreadCount(1).withPooledResponseBuffers(true).withPooledResponseBuffersSizeInBytes(this.pooledResponseBuffersSizeInBytes).withAuth(this.auth).withName(this.name).withMetricConfigs(this.metricsFactory.getMetricConfigs());
        }

        protected ClientProviderPoliciesRegistry createPoliciesRegistry() {
            return new ClientProviderPoliciesRegistry();
        }

        protected Builder validate() {
            if (this.targetScheme == null) {
                throw new ConfigurationException("No targetScheme provided for ServiceDiscovery");
            }
            if (this.refreshInterval <= 0L) {
                throw new ConfigurationException("refreshInterval must be higher than 0 for ServiceDiscovery");
            }
            return this;
        }

        public Builder withNodesFilter(String nodesFilter) {
            this.nodesFilter = nodesFilter;
            return this;
        }

        public Builder withTargetScheme(String targetScheme) {
            this.targetScheme = targetScheme;
            return this;
        }

        public Builder withRefreshInterval(long refreshInterval) {
            this.refreshInterval = refreshInterval;
            return this;
        }

        public Builder withConfigPolicies(String configPolicies) {
            this.configPolicies = configPolicies;
            return this;
        }

        public Builder withServerUris(String serverUris) {
            this.serverUris = serverUris;
            return this;
        }

        public Builder withConnTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withPooledResponseBuffersSizeInBytes(int pooledResponseBuffersSizeInBytes) {
            this.pooledResponseBuffersSizeInBytes = pooledResponseBuffersSizeInBytes;
            return this;
        }

        public Builder withAuth(Auth<HttpClientFactory.Builder> auth) {
            this.auth = auth;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMetricConfigs(List<MetricConfig> metricConfigs) {
            this.metricsFactory.configure(metricConfigs);
            return this;
        }
    }
}

