/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc.tls;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Optional;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class KeyReader {
    public PKCS8EncodedKeySpec readPrivateKey(FileInputStream fis, Optional<String> keyPassword) throws IOException {
        PrivateKeyInfo keyInfo;
        PEMParser keyReader = new PEMParser((Reader)new InputStreamReader(fis));
        PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(keyPassword.get().toCharArray());
        Object keyPair = keyReader.readObject();
        keyReader.close();
        if (keyPair instanceof PEMEncryptedKeyPair) {
            PEMKeyPair decryptedKeyPair = ((PEMEncryptedKeyPair)keyPair).decryptKeyPair(decryptorProvider);
            keyInfo = decryptedKeyPair.getPrivateKeyInfo();
        } else {
            keyInfo = ((PEMKeyPair)keyPair).getPrivateKeyInfo();
        }
        return new PKCS8EncodedKeySpec(keyInfo.getEncoded());
    }
}

