/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Bulk;
import io.searchbox.core.JestBatchIntrospector;
import io.searchbox.indices.template.PutTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.status.StatusLogger;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.IndexTemplate;
import org.appenders.log4j2.elasticsearch.jest.JestBulkOperations;

@Plugin(name="JestHttp", category="Core", elementType="objectFactory", printObject=true)
public class JestHttpObjectFactory
implements ClientObjectFactory<JestClient, Bulk> {
    private static Logger LOG = StatusLogger.getLogger();
    private final Collection<String> serverUris;
    private final int connTimeout;
    private final int readTimeout;
    private final int maxTotalConnections;
    private final int defaultMaxTotalConnectionsPerRoute;
    private final boolean discoveryEnabled;
    private JestClient client;

    protected JestHttpObjectFactory(Collection<String> serverUris, int connTimeout, int readTimeout, int maxTotalConnections, int defaultMaxTotalConnectionPerRoute, boolean discoveryEnabled) {
        this.serverUris = serverUris;
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
        this.maxTotalConnections = maxTotalConnections;
        this.defaultMaxTotalConnectionsPerRoute = defaultMaxTotalConnectionPerRoute;
        this.discoveryEnabled = discoveryEnabled;
    }

    public Collection<String> getServerList() {
        return new ArrayList<String>(this.serverUris);
    }

    public JestClient createClient() {
        if (this.client == null) {
            JestClientFactory factory = new JestClientFactory();
            HttpClientConfig.Builder builder = new HttpClientConfig.Builder(this.serverUris);
            builder.maxTotalConnection(this.maxTotalConnections);
            builder.defaultMaxTotalConnectionPerRoute(this.defaultMaxTotalConnectionsPerRoute);
            builder.connTimeout(this.connTimeout);
            builder.readTimeout(this.readTimeout);
            builder.discoveryEnabled(this.discoveryEnabled);
            builder.multiThreaded(true);
            factory.setHttpClientConfig(builder.build());
            this.client = factory.getObject();
        }
        return this.client;
    }

    public Function<Bulk, Boolean> createBatchListener(final FailoverPolicy failoverPolicy) {
        return new Function<Bulk, Boolean>(){
            private Function<Bulk, Boolean> failureHandler;
            private JestClient client;
            {
                this.failureHandler = JestHttpObjectFactory.this.createFailureHandler(failoverPolicy);
                this.client = JestHttpObjectFactory.this.createClient();
            }

            @Override
            public Boolean apply(Bulk bulk) {
                JestResultHandler<JestResult> jestResultHandler = JestHttpObjectFactory.this.createResultHandler(bulk, this.failureHandler);
                this.client.executeAsync((Action)bulk, jestResultHandler);
                return true;
            }
        };
    }

    public Function<Bulk, Boolean> createFailureHandler(final FailoverPolicy failover) {
        return new Function<Bulk, Boolean>(){
            private final JestBatchIntrospector introspector = new JestBatchIntrospector();

            @Override
            public Boolean apply(Bulk bulk) {
                this.introspector.items(bulk).forEach(failedItem -> failover.deliver(failedItem));
                return true;
            }
        };
    }

    public BatchOperations<Bulk> createBatchOperations() {
        return new JestBulkOperations();
    }

    public void execute(IndexTemplate indexTemplate) {
        PutTemplate templateAction = new PutTemplate.Builder(indexTemplate.getName(), (Object)indexTemplate.getSource()).build();
        try {
            JestResult result = this.createClient().execute((Action)templateAction);
            if (!result.isSucceeded()) {
                LOG.error("Unable to add index template. " + result.getErrorMessage());
            }
        }
        catch (IOException e) {
            LOG.error("Unable to add index template", (Throwable)e);
        }
    }

    protected JestResultHandler<JestResult> createResultHandler(final Bulk bulk, final Function<Bulk, Boolean> failureHandler) {
        return new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                if (!result.isSucceeded()) {
                    failureHandler.apply(bulk);
                }
            }

            public void failed(Exception ex) {
                failureHandler.apply(bulk);
            }
        };
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<JestHttpObjectFactory> {
        @PluginBuilderAttribute
        @Required(message="No serverUris provided for JestClientConfig")
        private String serverUris;
        @PluginBuilderAttribute
        private int connTimeout = -1;
        @PluginBuilderAttribute
        private int readTimeout = -1;
        @PluginBuilderAttribute
        private int maxTotalConnection = 40;
        @PluginBuilderAttribute
        private int defaultMaxTotalConnectionPerRoute = 4;
        @PluginBuilderAttribute
        private boolean discoveryEnabled;

        public JestHttpObjectFactory build() {
            if (this.serverUris == null) {
                throw new ConfigurationException("No serverUris provided for JestClientConfig");
            }
            return new JestHttpObjectFactory(Arrays.asList(this.serverUris.split(";")), this.connTimeout, this.readTimeout, this.maxTotalConnection, this.defaultMaxTotalConnectionPerRoute, this.discoveryEnabled);
        }

        public Builder withServerUris(String serverUris) {
            this.serverUris = serverUris;
            return this;
        }

        public void withMaxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
        }

        public void withDefaultMaxTotalConnectionPerRoute(int defaultMaxTotalConnectionPerRoute) {
            this.defaultMaxTotalConnectionPerRoute = defaultMaxTotalConnectionPerRoute;
        }

        public void withConnTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
        }

        public void withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public void withDiscoveryEnabled(boolean discoveryEnabled) {
            this.discoveryEnabled = discoveryEnabled;
        }
    }
}

