/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import org.appenders.log4j2.elasticsearch.jest.BufferedBulkResult;
import org.appenders.log4j2.elasticsearch.jest.BulkError;
import org.appenders.log4j2.elasticsearch.jest.BulkResultItem;

public class BulkResultDeserializer
extends JsonDeserializer {
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String fieldName;
        int took = 0;
        boolean errors = false;
        BulkError error = null;
        int status = -1;
        ArrayList<Object> items = null;
        while ((fieldName = p.nextFieldName()) != null) {
            switch (fieldName) {
                case "took": {
                    took = p.nextIntValue(-1);
                    break;
                }
                case "errors": {
                    errors = p.nextBooleanValue();
                    break;
                }
                case "status": {
                    status = p.nextIntValue(-1);
                    break;
                }
                case "error": {
                    p.nextValue();
                    JsonDeserializer typeDeserializer = ctxt.findNonContextualValueDeserializer(ctxt.constructType(BulkError.class));
                    error = (BulkError)typeDeserializer.deserialize(p, ctxt);
                    break;
                }
                case "items": {
                    if (!errors) break;
                    items = new ArrayList<Object>();
                    p.nextValue();
                    p.nextValue();
                    ObjectMapper mapper = (ObjectMapper)p.getCodec();
                    MappingIterator bulkResultItemMappingIterator = mapper.readValues(p, BulkResultItem.class);
                    while (bulkResultItemMappingIterator.hasNext()) {
                        items.add(bulkResultItemMappingIterator.next());
                    }
                    break;
                }
            }
        }
        return new BufferedBulkResult(took, errors, error, status, items);
    }
}

