/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.searchbox.action.BulkableAction;
import io.searchbox.core.Bulk;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.QueueFactory;
import org.appenders.log4j2.elasticsearch.jest.BufferedBulkResult;
import org.appenders.log4j2.elasticsearch.jest.BufferedIndex;
import org.appenders.log4j2.elasticsearch.thirdparty.ReusableByteBufOutputStream;

public class BufferedBulk
extends Bulk {
    public static final char LINE_SEPARATOR = '\n';
    public static final String BULK_URI = "/_bulk";
    private final ObjectWriter objectWriter;
    private final ObjectReader objectReader;
    private final ItemSource<ByteBuf> bulkSource;
    private final boolean dataStreamsEnabled;
    protected final Collection<BulkableAction> actions;

    public BufferedBulk(Builder builder) {
        super((Bulk.Builder)builder);
        this.actions = QueueFactory.getQueueFactoryInstance((String)BufferedBulk.class.getSimpleName()).toIterable(builder.actions);
        this.objectWriter = builder.objectWriter;
        this.objectReader = builder.objectReader;
        this.bulkSource = builder.bufferedSource;
        this.dataStreamsEnabled = builder.dataStreamsEnabled;
    }

    public BufferedBulkResult deserializeResponse(InputStream responseBody) throws IOException {
        return (BufferedBulkResult)this.objectReader.readValue(responseBody);
    }

    public ByteBuf serializeRequest() throws IOException {
        ReusableByteBufOutputStream byteBufOutputStream = new ReusableByteBufOutputStream((ByteBuf)this.bulkSource.getSource());
        BulkableAction sameAction = this.getSameItem(this.actions);
        byte[] actionTemplate = sameAction != null ? this.objectWriter.writeValueAsBytes((Object)sameAction) : null;
        for (BulkableAction action : this.actions) {
            if (actionTemplate == null) {
                this.objectWriter.writeValue((OutputStream)byteBufOutputStream, (Object)action);
            } else {
                byteBufOutputStream.write(actionTemplate);
            }
            byteBufOutputStream.writeByte(10);
            ByteBuf source = (ByteBuf)((BufferedIndex)action).getSource().getSource();
            ((ByteBuf)this.bulkSource.getSource()).writeBytes(source);
            byteBufOutputStream.writeByte(10);
        }
        return (ByteBuf)this.bulkSource.getSource();
    }

    public String getURI() {
        if (this.dataStreamsEnabled) {
            BulkableAction sameItem = this.getSameItem(this.actions);
            if (sameItem == null) {
                throw new IllegalArgumentException("Unable to derive index name from empty batch");
            }
            return sameItem.getIndex() + BULK_URI;
        }
        return BULK_URI;
    }

    private BulkableAction getSameItem(Collection<BulkableAction> bulkableActions) {
        BulkableAction current = null;
        for (BulkableAction bulkableAction : bulkableActions) {
            if (current == null) {
                current = bulkableAction;
                continue;
            }
            if (current.getIndex().equals(bulkableAction.getIndex())) continue;
            return null;
        }
        return current;
    }

    public void completed() {
        for (BulkableAction bulkableAction : this.actions) {
            ((BufferedIndex)bulkableAction).release();
        }
        this.actions.clear();
        this.bulkSource.release();
    }

    public Collection<BulkableAction> getActions() {
        return this.actions;
    }

    public static class Builder
    extends Bulk.Builder {
        private static final int INITIAL_SIZE = Integer.parseInt(System.getProperty("appenders." + BufferedBulk.class.getSimpleName() + ".initialSize", "10000"));
        protected final Collection<BulkableAction> actions = QueueFactory.getQueueFactoryInstance((String)BufferedBulk.class.getSimpleName()).tryCreateMpscQueue(INITIAL_SIZE);
        private ItemSource<ByteBuf> bufferedSource;
        private ObjectWriter objectWriter;
        private ObjectReader objectReader;
        private boolean dataStreamsEnabled;

        public Bulk.Builder addAction(BulkableAction action) {
            this.actions.add(action);
            return this;
        }

        public Bulk.Builder addAction(Collection<? extends BulkableAction> actions) {
            this.actions.addAll(actions);
            return this;
        }

        public BufferedBulk build() {
            if (this.bufferedSource == null) {
                throw new IllegalArgumentException("bufferedSource cannot be null");
            }
            if (this.objectReader == null) {
                throw new IllegalArgumentException("objectReader cannot be null");
            }
            if (this.objectWriter == null) {
                throw new IllegalArgumentException("objectWriter cannot be null");
            }
            return new BufferedBulk(this);
        }

        public Builder withBuffer(ItemSource<ByteBuf> buffer) {
            this.bufferedSource = buffer;
            return this;
        }

        public Builder withObjectWriter(ObjectWriter objectWriter) {
            this.objectWriter = objectWriter;
            return this;
        }

        public Builder withObjectReader(ObjectReader objectReader) {
            this.objectReader = objectReader;
            return this;
        }

        public Builder withDataStreamsEnabled(boolean dataStreamsEnabled) {
            this.dataStreamsEnabled = dataStreamsEnabled;
            return this;
        }
    }
}

