/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestClient;
import io.searchbox.client.config.ClientConfig;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.client.config.discovery.NodeChecker;
import io.searchbox.client.config.idle.HttpReapableConnectionManager;
import io.searchbox.client.config.idle.IdleConnectionReaper;
import io.searchbox.client.config.idle.ReapableConnectionManager;
import io.searchbox.client.http.JestHttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.jest.BufferedJestHttpClient;
import org.appenders.log4j2.elasticsearch.jest.ExtendedJestClientFactory;
import org.appenders.log4j2.elasticsearch.jest.WrappedHttpClientConfig;

public class BufferedJestClientFactory
extends ExtendedJestClientFactory {
    public BufferedJestClientFactory(WrappedHttpClientConfig wrappedHttpClientConfig) {
        super(wrappedHttpClientConfig);
    }

    public final JestClient getObject() {
        BufferedJestHttpClient client = this.createDefaultClient();
        HttpClientConfig httpClientConfig = this.wrappedHttpClientConfig.getHttpClientConfig();
        client.setServers(httpClientConfig.getServerList());
        HttpClientConnectionManager connectionManager = this.getConnectionManager();
        client.setHttpClient(this.createHttpClient(connectionManager));
        NHttpClientConnectionManager asyncConnectionManager = this.getAsyncConnectionManager();
        client.setAsyncClient(this.createAsyncHttpClient(asyncConnectionManager));
        if (httpClientConfig.getMaxConnectionIdleTime() > 0L) {
            this.createConnectionReaper(client, connectionManager, asyncConnectionManager);
        } else {
            InternalLogging.getLogger().info("Idle connection reaping disabled", new Object[0]);
        }
        if (httpClientConfig.isDiscoveryEnabled()) {
            this.createNodeChecker(client, httpClientConfig);
        } else {
            InternalLogging.getLogger().info("Node Discovery disabled", new Object[0]);
        }
        client.getAsyncClient().start();
        return client;
    }

    protected BufferedJestHttpClient createDefaultClient() {
        return new BufferedJestHttpClient();
    }

    IdleConnectionReaper createConnectionReaper(JestHttpClient client, HttpClientConnectionManager connectionManager, NHttpClientConnectionManager asyncConnectionManager) {
        InternalLogging.getLogger().info("Idle connection reaping enabled...", new Object[0]);
        IdleConnectionReaper reaper = new IdleConnectionReaper((ClientConfig)this.wrappedHttpClientConfig.getHttpClientConfig(), (ReapableConnectionManager)new HttpReapableConnectionManager(connectionManager, asyncConnectionManager));
        client.setIdleConnectionReaper(reaper);
        reaper.startAsync();
        reaper.awaitRunning();
        return reaper;
    }

    protected NodeChecker createNodeChecker(JestHttpClient client, HttpClientConfig httpClientConfig) {
        InternalLogging.getLogger().info("Node Discovery enabled...", new Object[0]);
        NodeChecker nodeChecker = new NodeChecker((JestClient)client, (ClientConfig)httpClientConfig);
        client.setNodeChecker(nodeChecker);
        nodeChecker.startAsync();
        nodeChecker.awaitRunning();
        return nodeChecker;
    }

    protected CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(this.getRequestConfig()).setProxyAuthenticationStrategy(this.wrappedHttpClientConfig.getHttpClientConfig().getProxyAuthenticationStrategy()).setRoutePlanner(this.getRoutePlanner()).setDefaultCredentialsProvider(this.wrappedHttpClientConfig.getHttpClientConfig().getCredentialsProvider()).build();
    }

    protected CloseableHttpAsyncClient createAsyncHttpClient(NHttpClientConnectionManager connectionManager) {
        return HttpAsyncClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(this.getRequestConfig()).setProxyAuthenticationStrategy(this.wrappedHttpClientConfig.getHttpClientConfig().getProxyAuthenticationStrategy()).setRoutePlanner(this.getRoutePlanner()).setDefaultCredentialsProvider(this.wrappedHttpClientConfig.getHttpClientConfig().getCredentialsProvider()).build();
    }
}

