/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestResult;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.jest.GenericJestRequest;

public class CheckDataStream
extends SetupStep<GenericJestRequest, JestResult> {
    protected final String name;

    public CheckDataStream(String name) {
        this.name = name;
    }

    public Result onResponse(JestResult response) {
        if (response.getResponseCode() == 404) {
            InternalLogging.getLogger().info("{}: Data stream {} does not exist", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SUCCESS;
        }
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: Data stream {} already exists", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SKIP;
        }
        InternalLogging.getLogger().error("{}: Unable to determine if {} data stream already exists", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
        return Result.FAILURE;
    }

    public GenericJestRequest createRequest() {
        return new GenericJestRequest("GET", null){

            @Override
            public String buildURI() {
                return "_data_stream/" + CheckDataStream.this.name;
            }
        };
    }
}

