/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.util.Map;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.appenders.log4j2.elasticsearch.jest.WrappedHttpClientConfig;

public class ExtendedJestClientFactory
extends JestClientFactory {
    protected final WrappedHttpClientConfig wrappedHttpClientConfig;

    public ExtendedJestClientFactory(WrappedHttpClientConfig wrappedHttpClientConfig) {
        this.wrappedHttpClientConfig = wrappedHttpClientConfig;
        super.setHttpClientConfig(wrappedHttpClientConfig.getHttpClientConfig());
    }

    protected NHttpClientConnectionManager getAsyncConnectionManager() {
        Integer defaultMaxPerRoute;
        PoolingNHttpClientConnectionManager connectionManager = this.createUnconfiguredPoolingNHttpClientConnectionManager();
        HttpClientConfig httpClientConfig = this.wrappedHttpClientConfig.getHttpClientConfig();
        Integer maxTotal = httpClientConfig.getMaxTotalConnection();
        if (maxTotal != null) {
            connectionManager.setMaxTotal(maxTotal.intValue());
        }
        if ((defaultMaxPerRoute = httpClientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
            connectionManager.setDefaultMaxPerRoute(defaultMaxPerRoute.intValue());
        }
        Map maxPerRoute = httpClientConfig.getMaxTotalConnectionPerRoute();
        for (Map.Entry entry : maxPerRoute.entrySet()) {
            connectionManager.setMaxPerRoute((HttpRoute)entry.getKey(), ((Integer)entry.getValue()).intValue());
        }
        return connectionManager;
    }

    PoolingNHttpClientConnectionManager createUnconfiguredPoolingNHttpClientConnectionManager() {
        try {
            return new PoolingNHttpClientConnectionManager(this.createIOReactor(), this.createSchemeIOSessionStrategyRegistry());
        }
        catch (IOReactorException e) {
            throw new IllegalStateException(e);
        }
    }

    Registry<SchemeIOSessionStrategy> createSchemeIOSessionStrategyRegistry() {
        HttpClientConfig httpClientConfig = this.wrappedHttpClientConfig.getHttpClientConfig();
        return RegistryBuilder.create().register("http", (Object)httpClientConfig.getHttpIOSessionStrategy()).register("https", (Object)httpClientConfig.getHttpsIOSessionStrategy()).build();
    }

    IOReactorConfig createIoReactorConfig() {
        HttpClientConfig httpClientConfig = this.wrappedHttpClientConfig.getHttpClientConfig();
        return IOReactorConfig.custom().setConnectTimeout(httpClientConfig.getConnTimeout()).setSoTimeout(httpClientConfig.getReadTimeout()).setIoThreadCount(this.wrappedHttpClientConfig.getIoThreadCount()).build();
    }

    ConnectingIOReactor createIOReactor() throws IOReactorException {
        return new DefaultConnectingIOReactor(this.createIoReactorConfig());
    }
}

