/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestResult;
import java.util.ArrayList;
import org.appenders.log4j2.elasticsearch.ILMPolicy;
import org.appenders.log4j2.elasticsearch.OpSource;
import org.appenders.log4j2.elasticsearch.Operation;
import org.appenders.log4j2.elasticsearch.OperationFactory;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.SkippingSetupStepChain;
import org.appenders.log4j2.elasticsearch.StepProcessor;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.jest.CheckBootstrapIndex;
import org.appenders.log4j2.elasticsearch.jest.CreateBootstrapIndex;
import org.appenders.log4j2.elasticsearch.jest.GenericJestRequest;
import org.appenders.log4j2.elasticsearch.jest.PutILMPolicy;

public class ILMPolicySetupOp
implements OperationFactory {
    private final StepProcessor<SetupStep<GenericJestRequest, JestResult>> stepProcessor;
    private final ValueResolver valueResolver;

    public ILMPolicySetupOp(StepProcessor<SetupStep<GenericJestRequest, JestResult>> stepProcessor, ValueResolver valueResolver) {
        this.stepProcessor = stepProcessor;
        this.valueResolver = valueResolver;
    }

    public <T extends OpSource> Operation create(T opSource) {
        ILMPolicy ilmPolicy = (ILMPolicy)opSource;
        ArrayList<SetupStep> setupSteps = new ArrayList<SetupStep>();
        if (ilmPolicy.isCreateBootstrapIndex()) {
            setupSteps.add(new CheckBootstrapIndex(ilmPolicy.getRolloverAlias()));
            setupSteps.add(new CreateBootstrapIndex(ilmPolicy.getRolloverAlias()));
        }
        PutILMPolicy updateIlmPolicy = new PutILMPolicy(ilmPolicy.getName(), this.valueResolver.resolve(ilmPolicy.getSource()));
        setupSteps.add(updateIlmPolicy);
        return new SkippingSetupStepChain(setupSteps, this.stepProcessor);
    }
}

