/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.action.BulkableAction;
import io.searchbox.core.Bulk;
import io.searchbox.core.Index;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.BatchBuilder;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.jest.ExtendedBulk;

public class JestBulkOperations
implements BatchOperations<Bulk> {
    public static final String DEFAULT_MAPPING_TYPE = null;
    private final String mappingType;
    private final String opType;

    public JestBulkOperations() {
        this(false);
    }

    public JestBulkOperations(String mappingType) {
        this.mappingType = mappingType;
        this.opType = "index";
    }

    public JestBulkOperations(boolean dataStreamsEnabled) {
        this.mappingType = null;
        this.opType = dataStreamsEnabled ? "create" : "index";
    }

    public Object createBatchItem(String indexName, Object source) {
        return ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(source).index(indexName)).type(this.mappingType)).setParameter("op_type", (Object)this.opType)).build();
    }

    public Object createBatchItem(String indexName, ItemSource source) {
        if (source.getSource() instanceof String) {
            return ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(source.getSource()).index(indexName)).type(this.mappingType)).setParameter("op_type", (Object)this.opType)).build();
        }
        throw new ConfigurationException("Non String payloads are not supported by this factory. Make sure that proper ClientObjectFactory implementation is configured");
    }

    public BatchBuilder<Bulk> createBatchBuilder() {
        return new BatchBuilder<Bulk>(){
            private final Bulk.Builder builder = new ExtendedBulk.Builder();

            public void add(Object item) {
                this.builder.addAction((BulkableAction)item);
            }

            public Bulk build() {
                return this.builder.build();
            }
        };
    }
}

