/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestResult;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.jest.GenericJestRequest;

public class PutILMPolicy
extends SetupStep<GenericJestRequest, JestResult> {
    protected final String name;
    protected final String source;

    public PutILMPolicy(String name, String source) {
        this.name = name;
        this.source = source;
    }

    public Result onResponse(JestResult response) {
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: ILM policy {} updated", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to update ILM policy: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public GenericJestRequest createRequest() {
        return new GenericJestRequest("PUT", this.source){

            @Override
            public String buildURI() {
                return String.format("_ilm/policy/%s", PutILMPolicy.this.name);
            }
        };
    }
}

