/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestResult;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.jest.GenericJestRequest;

public class PutIndexTemplate
extends SetupStep<GenericJestRequest, JestResult> {
    protected final int apiVersion;
    protected final String name;
    protected final String source;

    public PutIndexTemplate(String name, String source) {
        this(8, name, source);
    }

    public PutIndexTemplate(int apiVersion, String name, String source) {
        this.apiVersion = apiVersion;
        this.name = name;
        this.source = source;
    }

    public Result onResponse(JestResult response) {
        if (response.isSucceeded()) {
            InternalLogging.getLogger().info("{}: Index template {} updated", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to update index template: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public GenericJestRequest createRequest() {
        return new GenericJestRequest("PUT", this.source){

            @Override
            public String buildURI() {
                return this.getVersionBasedUri();
            }

            private String getVersionBasedUri() {
                if (PutIndexTemplate.this.apiVersion < 8) {
                    return "_template/" + PutIndexTemplate.this.name;
                }
                return "_index_template/" + PutIndexTemplate.this.name;
            }
        };
    }
}

