/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.st.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import org.appenders.st.jackson.JsonWriteContextAccessor;

public class ReusableUTF8JsonGenerator
extends UTF8JsonGenerator {
    private final JsonWriteContextAccessor jsonWriteCtxAccess;

    public ReusableUTF8JsonGenerator(IOContext ctxt, int generatorFeatures, ObjectCodec objectCodec, OutputStream outputStream, char _quoteChar, JsonWriteContextAccessor jsonWriteCtxAccess) {
        super(ctxt, generatorFeatures, objectCodec, outputStream, _quoteChar);
        this.jsonWriteCtxAccess = jsonWriteCtxAccess;
    }

    public void close() throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonStreamContext ctxt;
                if ((ctxt = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!ctxt.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        this._outputTail = 0;
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._outputStream.close();
        } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._outputStream.flush();
        }
    }

    public ReusableUTF8JsonGenerator reset() {
        this._writeContext = this.jsonWriteCtxAccess.reset(this._writeContext);
        return this;
    }
}

