/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.appfuse.model.Address;
import org.appfuse.model.BaseObject;
import org.appfuse.model.LabelValue;
import org.appfuse.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="app_user")
public class User
extends BaseObject
implements Serializable,
UserDetails {
    private static final long serialVersionUID = 3832626162173359411L;
    protected Long id;
    protected String username;
    protected String password;
    protected String confirmPassword;
    protected String passwordHint;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected String phoneNumber;
    protected String website;
    protected Address address = new Address();
    protected Integer version;
    protected Set<Role> roles = new HashSet<Role>();
    protected boolean enabled;
    protected boolean accountExpired;
    protected boolean accountLocked;
    protected boolean credentialsExpired;

    public User() {
    }

    public User(String username) {
        this.username = username;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    @Column(nullable=false, length=50, unique=true)
    public String getUsername() {
        return this.username;
    }

    @Column(nullable=false)
    public String getPassword() {
        return this.password;
    }

    @Transient
    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    @Column(name="password_hint")
    public String getPasswordHint() {
        return this.passwordHint;
    }

    @Column(name="first_name", nullable=false, length=50)
    public String getFirstName() {
        return this.firstName;
    }

    @Column(name="last_name", nullable=false, length=50)
    public String getLastName() {
        return this.lastName;
    }

    @Column(nullable=false, unique=true)
    public String getEmail() {
        return this.email;
    }

    @Column(name="phone_number")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getWebsite() {
        return this.website;
    }

    @Transient
    public String getFullName() {
        return this.firstName + ' ' + this.lastName;
    }

    @Embedded
    public Address getAddress() {
        return this.address;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="user_role", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    public Set<Role> getRoles() {
        return this.roles;
    }

    @Transient
    public List<LabelValue> getRoleList() {
        ArrayList<LabelValue> userRoles = new ArrayList<LabelValue>();
        if (this.roles != null) {
            for (Role role : this.roles) {
                userRoles.add(new LabelValue(role.getName(), role.getName()));
            }
        }
        return userRoles;
    }

    public void addRole(Role role) {
        this.getRoles().add(role);
    }

    @Transient
    public GrantedAuthority[] getAuthorities() {
        return this.roles.toArray(new GrantedAuthority[0]);
    }

    @Version
    public Integer getVersion() {
        return this.version;
    }

    @Column(name="account_enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    @Column(name="account_expired", nullable=false)
    public boolean isAccountExpired() {
        return this.accountExpired;
    }

    @Transient
    public boolean isAccountNonExpired() {
        return !this.isAccountExpired();
    }

    @Column(name="account_locked", nullable=false)
    public boolean isAccountLocked() {
        return this.accountLocked;
    }

    @Transient
    public boolean isAccountNonLocked() {
        return !this.isAccountLocked();
    }

    @Column(name="credentials_expired", nullable=false)
    public boolean isCredentialsExpired() {
        return this.credentialsExpired;
    }

    @Transient
    public boolean isCredentialsNonExpired() {
        return !this.credentialsExpired;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public void setPasswordHint(String passwordHint) {
        this.passwordHint = passwordHint;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAccountExpired(boolean accountExpired) {
        this.accountExpired = accountExpired;
    }

    public void setAccountLocked(boolean accountLocked) {
        this.accountLocked = accountLocked;
    }

    public void setCredentialsExpired(boolean credentialsExpired) {
        this.credentialsExpired = credentialsExpired;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return !(this.username == null ? user.getUsername() != null : !this.username.equals(user.getUsername()));
    }

    @Override
    public int hashCode() {
        return this.username != null ? this.username.hashCode() : 0;
    }

    @Override
    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).append("username", (Object)this.username).append("enabled", this.enabled).append("accountExpired", this.accountExpired).append("credentialsExpired", this.credentialsExpired).append("accountLocked", this.accountLocked);
        GrantedAuthority[] auths = this.getAuthorities();
        if (auths != null) {
            sb.append((Object)"Granted Authorities: ");
            for (int i = 0; i < auths.length; ++i) {
                if (i > 0) {
                    sb.append((Object)", ");
                }
                sb.append((Object)auths[i].toString());
            }
        } else {
            sb.append((Object)"No Granted Authorities");
        }
        return sb.toString();
    }
}

