/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.hibernate;

import java.util.List;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.appfuse.dao.UserDao;
import org.appfuse.dao.hibernate.GenericDaoHibernate;
import org.appfuse.model.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDaoHibernate
extends GenericDaoHibernate<User, Long>
implements UserDao,
UserDetailsService {
    public UserDaoHibernate() {
        super(User.class);
    }

    @Override
    public List<User> getUsers() {
        return this.getHibernateTemplate().find("from User u order by upper(u.username)");
    }

    @Override
    public User saveUser(User user) {
        this.log.debug((Object)("user's id: " + user.getId()));
        this.getHibernateTemplate().saveOrUpdate((Object)user);
        this.getHibernateTemplate().flush();
        return user;
    }

    @Override
    public User save(User user) {
        return this.saveUser(user);
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        List users = this.getHibernateTemplate().find("from User where username=?", (Object)username);
        if (users == null || users.isEmpty()) {
            throw new UsernameNotFoundException("user '" + username + "' not found...");
        }
        return (UserDetails)users.get(0);
    }
}

