/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.hibernate;

import java.util.List;
import javax.persistence.Table;
import org.appfuse.dao.UserDao;
import org.appfuse.dao.hibernate.GenericDaoHibernate;
import org.appfuse.model.User;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Repository;

@Repository(value="userDao")
public class UserDaoHibernate
extends GenericDaoHibernate<User, Long>
implements UserDao,
UserDetailsService {
    public UserDaoHibernate() {
        super(User.class);
    }

    @Override
    public List<User> getUsers() {
        Query qry = this.getSession().createQuery("from User u order by upper(u.username)");
        return qry.list();
    }

    @Override
    public User saveUser(User user) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("user's id: " + user.getId()));
        }
        this.getSession().saveOrUpdate((Object)user);
        this.getSession().flush();
        return user;
    }

    @Override
    public User save(User user) {
        return this.saveUser(user);
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        List users = this.getSession().createCriteria(User.class).add((Criterion)Restrictions.eq((String)"username", (Object)username)).list();
        if (users == null || users.isEmpty()) {
            throw new UsernameNotFoundException("user '" + username + "' not found...");
        }
        return (UserDetails)users.get(0);
    }

    @Override
    public String getUserPassword(Long userId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(SessionFactoryUtils.getDataSource((SessionFactory)this.getSessionFactory()));
        Table table = (Table)AnnotationUtils.findAnnotation(User.class, Table.class);
        return (String)jdbcTemplate.queryForObject("select password from " + table.name() + " where id=?", String.class, new Object[]{userId});
    }
}

