/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.appfuse.Constants;
import org.appfuse.webapp.action.BasePage;
import org.primefaces.model.UploadedFile;

public class FileUpload
extends BasePage
implements Serializable {
    private static final long serialVersionUID = 6932775516007291334L;
    private UploadedFile file;
    private String name;

    public UploadedFile getFile() {
        return this.file;
    }

    public void setFile(UploadedFile file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String upload() throws IOException {
        int bytesRead;
        File dirPath;
        HttpServletRequest request = this.getRequest();
        String uploadDir = this.getFacesContext().getExternalContext().getRealPath("/resources");
        if (uploadDir == null) {
            uploadDir = new File("src/main/webapp/resources").getAbsolutePath();
        }
        if (!(dirPath = new File(uploadDir = uploadDir + "/" + request.getRemoteUser() + "/")).exists()) {
            dirPath.mkdirs();
        }
        InputStream stream = this.file.getInputstream();
        String filename = this.file.getFileName();
        if (filename.contains("/")) {
            filename = filename.substring(filename.lastIndexOf("/") + 1);
        }
        if (filename.contains("\\")) {
            int slash3;
            int slash2;
            int slash = filename.lastIndexOf("\\");
            if (slash != -1) {
                filename = filename.substring(slash + 1);
            }
            if ((slash2 = filename.lastIndexOf("/")) != -1) {
                filename = filename.substring(slash2 + 1);
            }
            if ((slash3 = filename.lastIndexOf(":")) != -1) {
                filename = filename.substring(slash3 + 1);
            }
        }
        FileOutputStream bos = new FileOutputStream(uploadDir + filename);
        byte[] buffer = new byte[8192];
        while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
            ((OutputStream)bos).write(buffer, 0, bytesRead);
        }
        ((OutputStream)bos).close();
        stream.close();
        request.setAttribute("friendlyName", (Object)this.name);
        request.setAttribute("fileName", (Object)filename);
        request.setAttribute("contentType", (Object)this.file.getContentType());
        request.setAttribute("size", (Object)(this.file.getSize() + " bytes"));
        request.setAttribute("location", (Object)(dirPath.getAbsolutePath() + Constants.FILE_SEP + filename));
        String link = request.getContextPath() + "/resources" + "/" + request.getRemoteUser() + "/";
        request.setAttribute("link", (Object)(link + filename));
        return "success";
    }
}

