/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import java.io.Serializable;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.appfuse.model.User;
import org.appfuse.service.RoleManager;
import org.appfuse.service.UserExistsException;
import org.appfuse.webapp.action.BasePage;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.mail.MailException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SignupForm
extends BasePage
implements Serializable {
    private static final long serialVersionUID = 3524937486662786265L;
    private User user = new User();
    private RoleManager roleManager;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public String save() throws Exception {
        this.user.setEnabled(true);
        this.user.addRole(this.roleManager.getRole("ROLE_USER"));
        try {
            this.user = this.userManager.saveUser(this.user);
        }
        catch (AccessDeniedException ade) {
            this.log.warn((Object)ade.getMessage());
            this.getResponse().sendError(403);
            return null;
        }
        catch (UserExistsException e) {
            this.addMessage("errors.existing.user", (Object)new Object[]{this.user.getUsername(), this.user.getEmail()});
            this.user.setPassword(this.user.getConfirmPassword());
            return null;
        }
        this.addMessage("user.registered");
        this.getSession().setAttribute("registered", (Object)Boolean.TRUE);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)this.user.getUsername(), (Object)this.user.getConfirmPassword(), (Collection)this.user.getAuthorities());
        auth.setDetails((Object)this.user);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.message.setSubject(this.getText("signup.email.subject"));
        try {
            this.sendUserMessage(this.user, this.getText("signup.email.message"), RequestUtil.getAppURL((HttpServletRequest)this.getRequest()));
        }
        catch (MailException me) {
            this.addError(me.getMostSpecificCause().getMessage());
            return null;
        }
        return "home";
    }

    public String getCountry() {
        return this.getUser().getAddress().getCountry();
    }

    public void setCountry(String country) {
        this.getUser().getAddress().setCountry(country);
    }
}

