/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.appfuse.model.Role;
import org.appfuse.model.User;
import org.appfuse.service.RoleManager;
import org.appfuse.service.UserExistsException;
import org.appfuse.util.ConvertUtil;
import org.appfuse.webapp.action.BasePage;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.mail.MailException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class UserForm
extends BasePage
implements Serializable {
    private static final long serialVersionUID = -1141119853856863204L;
    private RoleManager roleManager;
    private String id;
    private User user = new User();
    private Map<String, String> availableRoles;
    private String[] userRoles;

    public void setId(String id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public String add() {
        this.user = new User();
        this.user.setEnabled(true);
        this.user.addRole(new Role("ROLE_USER"));
        return "editProfile";
    }

    public String cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entering 'cancel' method");
        }
        if (!"list".equals(this.getParameter("from"))) {
            return "home";
        }
        return "cancel";
    }

    public String edit() {
        HttpServletRequest request = this.getRequest();
        if (this.id != null) {
            this.log.debug((Object)("Editing user, id is: " + this.id));
            this.user = this.userManager.getUser(this.id);
        } else {
            this.user = this.userManager.getUserByUsername(request.getRemoteUser());
        }
        if (this.user.getUsername() != null) {
            this.user.setConfirmPassword(this.user.getPassword());
            if (this.isRememberMe()) {
                this.log.debug((Object)"checking for remember me login...");
                this.log.trace((Object)("User '" + this.user.getUsername() + "' logged in with cookie"));
                this.addMessage("userProfile.cookieLogin");
            }
        }
        return "editProfile";
    }

    public boolean isRememberMe() {
        if (this.user != null && this.user.getId() == null) {
            return false;
        }
        AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx != null) {
            Authentication auth = ctx.getAuthentication();
            return resolver.isRememberMe(auth);
        }
        return false;
    }

    public String save() throws IOException {
        this.setUserRoles(this.getRequest().getParameterValues("userForm:userRoles"));
        for (int i = 0; this.userRoles != null && i < this.userRoles.length; ++i) {
            String roleName = this.userRoles[i];
            this.user.addRole(this.roleManager.getRole(roleName));
        }
        if (this.user.getId() != null && this.user.getId() == 0L || this.user.getVersion() != null && this.user.getVersion() == 0) {
            this.user.setId(null);
            this.user.setVersion(null);
        }
        Integer originalVersion = this.user.getVersion();
        try {
            this.user = this.userManager.saveUser(this.user);
        }
        catch (AccessDeniedException ade) {
            this.log.warn((Object)ade.getMessage());
            this.getResponse().sendError(403);
            return null;
        }
        catch (UserExistsException e) {
            this.addError("errors.existing.user", (Object)new Object[]{this.user.getUsername(), this.user.getEmail()});
            this.user.setVersion(originalVersion);
            return "editProfile";
        }
        if (!"list".equals(this.getParameter("from"))) {
            this.addMessage("user.saved");
            return "home";
        }
        if ("".equals(this.getParameter("userForm:version"))) {
            this.addMessage("user.added", (Object)this.user.getFullName());
            try {
                this.sendUserMessage(this.user, this.getText("newuser.email.message", (Object)this.user.getFullName()), RequestUtil.getAppURL((HttpServletRequest)this.getRequest()));
            }
            catch (MailException me) {
                this.addError(me.getCause().getLocalizedMessage());
            }
            return "list";
        }
        this.addMessage("user.updated.byAdmin", (Object)this.user.getFullName());
        return "editProfile";
    }

    public String delete() {
        this.userManager.removeUser(this.getUser().getId().toString());
        this.addMessage("user.deleted", (Object)this.getUser().getFullName());
        return "list";
    }

    public String getFrom() {
        if (this.id != null || this.getParameter("editUser:add") != null || "list".equals(this.getParameter("from"))) {
            return "list";
        }
        return "";
    }

    public Map<String, String> getAvailableRoles() {
        if (this.availableRoles == null) {
            List roles = (List)this.getServletContext().getAttribute("availableRoles");
            this.availableRoles = ConvertUtil.convertListToMap((List)roles);
        }
        return this.availableRoles;
    }

    public String[] getUserRoles() {
        this.userRoles = new String[this.user.getRoles().size()];
        int i = 0;
        if (this.userRoles.length > 0) {
            for (Role role : this.user.getRoles()) {
                this.userRoles[i] = role.getName();
                ++i;
            }
        }
        return this.userRoles;
    }

    public void setUserRoles(String[] userRoles) {
        this.userRoles = userRoles;
    }

    public String getCountry() {
        return this.getUser().getAddress().getCountry();
    }

    public void setCountry(String country) {
        this.getUser().getAddress().setCountry(country);
    }
}

