/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.listener;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.service.GenericManager;
import org.appfuse.service.LookupManager;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StartupListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(StartupListener.class);

    public void contextInitialized(ServletContextEvent event) {
        log.debug((Object)"Initializing context...");
        ServletContext context = event.getServletContext();
        HashMap<String, Boolean> config = (HashMap<String, Boolean>)context.getAttribute("appConfig");
        if (config == null) {
            config = new HashMap<String, Boolean>();
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        PasswordEncoder passwordEncoder = null;
        try {
            ProviderManager provider = (ProviderManager)ctx.getBean("org.springframework.security.authentication.ProviderManager#0");
            for (Object o : provider.getProviders()) {
                AuthenticationProvider p = (AuthenticationProvider)o;
                if (p instanceof RememberMeAuthenticationProvider) {
                    config.put("rememberMeEnabled", Boolean.TRUE);
                    continue;
                }
                if (ctx.getBean("passwordEncoder") == null) continue;
                passwordEncoder = (PasswordEncoder)ctx.getBean("passwordEncoder");
            }
        }
        catch (NoSuchBeanDefinitionException n) {
            log.debug((Object)"authenticationManager bean not found, assuming test and ignoring...");
        }
        context.setAttribute("appConfig", config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remember Me Enabled? " + config.get("rememberMeEnabled")));
            if (passwordEncoder != null) {
                log.debug((Object)("Password Encoder: " + passwordEncoder.getClass().getSimpleName()));
            }
            log.debug((Object)"Populating drop-downs...");
        }
        StartupListener.setupContext((ServletContext)context);
        String appVersion = null;
        try {
            InputStream is = context.getResourceAsStream("/META-INF/MANIFEST.MF");
            if (is == null) {
                log.warn((Object)"META-INF/MANIFEST.MF not found.");
            } else {
                Manifest mf = new Manifest();
                mf.read(is);
                Attributes atts = mf.getMainAttributes();
                appVersion = atts.getValue("Implementation-Version");
            }
        }
        catch (IOException e) {
            log.error((Object)("I/O Exception reading manifest: " + e.getMessage()));
        }
        if (appVersion == null || appVersion.contains("SNAPSHOT")) {
            appVersion = "" + new Random().nextInt(100000);
        }
        log.info((Object)("Application version set to: " + appVersion));
        context.setAttribute("assetsVersion", (Object)appVersion);
    }

    public static void setupContext(ServletContext context) {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        LookupManager mgr = (LookupManager)ctx.getBean("lookupManager");
        context.setAttribute("availableRoles", (Object)mgr.getAllRoles());
        log.debug((Object)"Drop-down initialization complete [OK]");
        GenericManager manager = (GenericManager)ctx.getBean("userManager");
        StartupListener.doReindexing((GenericManager)manager);
        log.debug((Object)"Full text search reindexing complete [OK]");
    }

    private static void doReindexing(GenericManager manager) {
        manager.reindexAll(false);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

