/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.webapp.controller.BaseFormController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userform*"})
public class UserFormController
extends BaseFormController {
    private final Log log = LogFactory.getLog(UserFormController.class);
    @Autowired
    UserManager userManager;
    @Autowired(required=false)
    Validator validator;

    @RequestMapping(method={RequestMethod.POST})
    public String onSubmit(User user, BindingResult result, HttpServletRequest request) throws Exception {
        if (request.getParameter("cancel") != null) {
            return "redirect:users";
        }
        if (this.validator != null && request.getParameter("delete") == null) {
            this.validator.validate((Object)user, (Errors)result);
            if (result.hasErrors()) {
                return "userform";
            }
        }
        this.log.debug((Object)"entering 'onSubmit' method...");
        if (request.getParameter("delete") != null) {
            this.userManager.removeUser(user.getId().toString());
            this.saveMessage(request, this.getText("user.deleted", user.getFullName(), request.getLocale()));
        } else {
            try {
                this.userManager.saveUser(user);
            }
            catch (UserExistsException uex) {
                result.addError(new ObjectError("user", uex.getMessage()));
                return "userform";
            }
            this.saveMessage(request, this.getText("user.saved", user.getFullName(), request.getLocale()));
        }
        return "redirect:users";
    }

    @ModelAttribute
    @RequestMapping(method={RequestMethod.GET})
    protected User getUser(HttpServletRequest request) {
        String userId = request.getParameter("id");
        if (userId != null && !userId.equals("")) {
            return this.userManager.getUser(userId);
        }
        return new User();
    }
}

