/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.User;
import org.appfuse.service.MailEngine;
import org.appfuse.service.UserManager;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class BaseFormController
extends SimpleFormController {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    public static final String MESSAGES_KEY = "successMessages";
    private UserManager userManager = null;
    protected MailEngine mailEngine = null;
    protected SimpleMailMessage message = null;
    protected String templateName = null;
    protected String cancelView;

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void saveMessage(HttpServletRequest request, String msg) {
        ArrayList<String> messages = (ArrayList<String>)request.getSession().getAttribute(MESSAGES_KEY);
        if (messages == null) {
            messages = new ArrayList<String>();
        }
        messages.add(msg);
        request.getSession().setAttribute(MESSAGES_KEY, messages);
    }

    public String getText(String msgKey, Locale locale) {
        return this.getMessageSourceAccessor().getMessage(msgKey, locale);
    }

    public String getText(String msgKey, String arg, Locale locale) {
        return this.getText(msgKey, new Object[]{arg}, locale);
    }

    public String getText(String msgKey, Object[] args, Locale locale) {
        return this.getMessageSourceAccessor().getMessage(msgKey, args, locale);
    }

    public Map getConfiguration() {
        HashMap config = (HashMap)this.getServletContext().getAttribute("appConfig");
        if (config == null) {
            return new HashMap();
        }
        return config;
    }

    public ModelAndView processFormSubmission(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        if (request.getParameter("cancel") != null) {
            return new ModelAndView(this.getCancelView());
        }
        return super.processFormSubmission(request, response, command, errors);
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.registerCustomEditor(Integer.class, null, (PropertyEditor)new CustomNumberEditor(Integer.class, null, true));
        binder.registerCustomEditor(Long.class, null, (PropertyEditor)new CustomNumberEditor(Long.class, null, true));
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getText("date.format", request.getLocale()));
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, null, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
    }

    protected void sendUserMessage(User user, String msg, String url) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sending e-mail to user [" + user.getEmail() + "]..."));
        }
        this.message.setTo(user.getFullName() + "<" + user.getEmail() + ">");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", user);
        model.put("message", msg);
        model.put("applicationURL", url);
        this.mailEngine.sendMessage(this.message, this.templateName, model);
    }

    public void setMailEngine(MailEngine mailEngine) {
        this.mailEngine = mailEngine;
    }

    public void setMessage(SimpleMailMessage message) {
        this.message = message;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public final void setCancelView(String cancelView) {
        this.cancelView = cancelView;
    }

    public final String getCancelView() {
        if (this.cancelView == null || this.cancelView.length() == 0) {
            return this.getSuccessView();
        }
        return this.cancelView;
    }
}

