/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.Uuid;
import org.apptank.horus.client.auth.HorusAuthentication;
import org.apptank.horus.client.base.DataResult;
import org.apptank.horus.client.control.ISyncControlDatabaseHelper;
import org.apptank.horus.client.data.DataChangeListener;
import org.apptank.horus.client.data.Horus;
import org.apptank.horus.client.database.DatabaseOperation;
import org.apptank.horus.client.database.IOperationDatabaseHelper;
import org.apptank.horus.client.database.SQL;
import org.apptank.horus.client.database.SQLKt;
import org.apptank.horus.client.database.builder.QueryBuilder;
import org.apptank.horus.client.database.builder.SimpleQueryBuilder;
import org.apptank.horus.client.di.HorusContainer;
import org.apptank.horus.client.eventbus.Event;
import org.apptank.horus.client.eventbus.EventBus;
import org.apptank.horus.client.eventbus.EventType;
import org.apptank.horus.client.exception.EntityNotExistsException;
import org.apptank.horus.client.exception.EntityNotWritableException;
import org.apptank.horus.client.exception.UserNotAuthenticatedException;
import org.apptank.horus.client.utils.AttributesPreparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0018\u001a\u00020\b2\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\tJ&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fJ5\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u001a\u0010\u001e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0!\"\u0006\u0012\u0002\b\u00030 \u00a2\u0006\u0002\u0010\"J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00010#J.\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fJ=\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u001a\u0010\u001e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0!\"\u0006\u0012\u0002\b\u00030 \u00a2\u0006\u0002\u0010&J0\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00010#J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001cJV\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u001f0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u001f2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010.H\u0086@\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u0004\u0018\u00010)2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001cJ\u000e\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\fJ\u000e\u00104\u001a\u00020\b2\u0006\u00103\u001a\u00020\fJ\u0006\u00105\u001a\u00020\bJ\u0010\u00106\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u00107\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u00108\u001a\u00020\bH\u0002J\u0010\u00109\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010:\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010;\u001a\u00020\bH\u0002J\b\u0010<\u001a\u00020\u001cH\u0002J\b\u0010=\u001a\u00020\u001cH\u0002J\r\u0010>\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b?R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007j\u0004\u0018\u0001`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006@"}, d2={"Lorg/apptank/horus/client/HorusDataFacade;", "", "<init>", "()V", "isReady", "", "onCallbackReady", "Lkotlin/Function0;", "", "Lorg/apptank/horus/client/base/Callback;", "changeListeners", "", "Lorg/apptank/horus/client/data/DataChangeListener;", "operationDatabaseHelper", "Lorg/apptank/horus/client/database/IOperationDatabaseHelper;", "getOperationDatabaseHelper", "()Lorg/apptank/horus/client/database/IOperationDatabaseHelper;", "operationDatabaseHelper$delegate", "Lkotlin/Lazy;", "syncControlDatabaseHelper", "Lorg/apptank/horus/client/control/ISyncControlDatabaseHelper;", "getSyncControlDatabaseHelper", "()Lorg/apptank/horus/client/control/ISyncControlDatabaseHelper;", "syncControlDatabaseHelper$delegate", "onReady", "callback", "insert", "Lorg/apptank/horus/client/base/DataResult;", "", "entity", "attributes", "", "Lorg/apptank/horus/client/data/Horus$Attribute;", "", "(Ljava/lang/String;[Lorg/apptank/horus/client/data/Horus$Attribute;)Lorg/apptank/horus/client/base/DataResult;", "", "update", "id", "(Ljava/lang/String;Ljava/lang/String;[Lorg/apptank/horus/client/data/Horus$Attribute;)Lorg/apptank/horus/client/base/DataResult;", "delete", "querySimple", "Lorg/apptank/horus/client/data/Horus$Entity;", "conditions", "Lorg/apptank/horus/client/database/SQL$WhereCondition;", "orderBy", "limit", "", "offset", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getById", "addDataChangeListener", "dataChangeListener", "removeDataChangeListener", "removeAllDataChangeListeners", "validateConstraints", "validateConstraintsReadable", "validateIsReady", "validateIsEntityExists", "validateIsCanWriteIntoEntity", "registerEntityEventListeners", "getUserId", "generateUUID", "clear", "clear$client_release", "client_release"})
@SourceDebugExtension(value={"SMAP\nHorusDataFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorusDataFacade.kt\norg/apptank/horus/client/HorusDataFacade\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,474:1\n126#2:475\n153#2,3:476\n126#2:485\n153#2,3:486\n126#2:494\n153#2,3:495\n126#2:502\n153#2,3:503\n774#3:479\n865#3:480\n866#3:482\n1863#3,2:483\n1557#3:491\n1628#3,2:492\n1630#3:498\n1557#3:499\n1628#3,2:500\n1630#3:506\n1863#3,2:507\n1863#3,2:509\n1863#3,2:511\n1#4:481\n37#5,2:489\n*S KotlinDebug\n*F\n+ 1 HorusDataFacade.kt\norg/apptank/horus/client/HorusDataFacade\n*L\n130#1:475\n130#1:476,3\n228#1:485\n228#1:486,3\n306#1:494\n306#1:495,3\n336#1:502\n336#1:503,3\n162#1:479\n162#1:480\n162#1:482\n163#1:483,2\n303#1:491\n303#1:492,2\n303#1:498\n333#1:499\n333#1:500,2\n333#1:506\n413#1:507,2\n425#1:509,2\n436#1:511,2\n291#1:489,2\n*E\n"})
public final class HorusDataFacade {
    @NotNull
    public static final HorusDataFacade INSTANCE = new HorusDataFacade();
    private static boolean isReady;
    @Nullable
    private static Function0<Unit> onCallbackReady;
    @NotNull
    private static List<DataChangeListener> changeListeners;
    @NotNull
    private static final Lazy operationDatabaseHelper$delegate;
    @NotNull
    private static final Lazy syncControlDatabaseHelper$delegate;

    private HorusDataFacade() {
    }

    private final IOperationDatabaseHelper getOperationDatabaseHelper() {
        Lazy lazy = operationDatabaseHelper$delegate;
        return (IOperationDatabaseHelper)lazy.getValue();
    }

    private final ISyncControlDatabaseHelper getSyncControlDatabaseHelper() {
        Lazy lazy = syncControlDatabaseHelper$delegate;
        return (ISyncControlDatabaseHelper)lazy.getValue();
    }

    public final void onReady(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        onCallbackReady = callback;
    }

    @NotNull
    public final DataResult<String> insert(@NotNull String entity, @NotNull List<? extends Horus.Attribute<?>> attributes) {
        Object object;
        Object $this$insert_u24lambda_u245;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.validateConstraints(entity);
        if (AttributesPreparator.INSTANCE.isAttributesNameContainsRestricted(attributes)) {
            return new DataResult.Failure(new IllegalStateException("Attribute restricted"));
        }
        String uuid = this.generateUUID();
        Horus.Attribute<String> id = new Horus.Attribute<String>("id", uuid);
        List attributesPrepared = AttributesPreparator.appendHashAndUpdateAttributes$default(AttributesPreparator.INSTANCE, id, AttributesPreparator.appendInsertSyncAttributes$default(AttributesPreparator.INSTANCE, id, attributes, this.getUserId(), 0L, 8, null), 0L, 4, null);
        Object object2 = this;
        try {
            $this$insert_u24lambda_u245 = object2;
            boolean bl = false;
            boolean result = super.getOperationDatabaseHelper().insertWithTransaction(CollectionsKt.listOf((Object)new DatabaseOperation.InsertRecord(entity, SQLKt.mapToDBColumValue(attributesPrepared))), (Function0<Unit>)((Function0)() -> HorusDataFacade.insert$lambda$5$lambda$4((HorusDataFacade)$this$insert_u24lambda_u245, entity, id, attributes)));
            $this$insert_u24lambda_u245 = Result.constructor-impl((Object)(result ? (DataResult)new DataResult.Success<String>(uuid) : (DataResult)new DataResult.Failure(new IllegalStateException("Insert entity failure"))));
        }
        catch (Throwable bl) {
            $this$insert_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$insert_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = new DataResult.Failure(it);
        }
        return (DataResult)object;
    }

    @NotNull
    public final DataResult<String> insert(@NotNull String entity, Horus.Attribute<?> ... attributes) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        return this.insert(entity, ArraysKt.toList((Object[])attributes));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataResult<String> insert(@NotNull String entity, @NotNull Map<String, ? extends Object> attributes) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Map<String, ? extends Object> map = attributes;
        String string = entity;
        HorusDataFacade horusDataFacade = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Horus.Attribute((String)it.getKey(), it.getValue()));
        }
        collection = (List)destination$iv$iv;
        return horusDataFacade.insert(string, (List<? extends Horus.Attribute<?>>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataResult<Unit> update(@NotNull String entity, @NotNull String id, @NotNull List<? extends Horus.Attribute<?>> attributes) {
        Object object;
        Object $this$update_u24lambda_u2415;
        void $this$update_u24lambda_u2413;
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.validateConstraints(entity);
        if (AttributesPreparator.INSTANCE.isAttributesNameContainsRestricted(attributes)) {
            return new DataResult.Failure(new IllegalStateException("Attribute restricted"));
        }
        Horus.Attribute<String> attrId = new Horus.Attribute<String>("id", id);
        Horus.Entity entity2 = this.getById(entity, id);
        if (entity2 == null) {
            return new DataResult.Failure(new IllegalStateException("Entity not found"));
        }
        Horus.Entity currentData = entity2;
        Object object2 = CollectionsKt.toMutableList((Collection)attributes);
        List list = object2;
        Horus.Attribute<String> attribute = attrId;
        AttributesPreparator attributesPreparator = AttributesPreparator.INSTANCE;
        boolean bl = false;
        Iterable $this$filter$iv = currentData.getAttributes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object v1;
            block9: {
                Horus.Attribute currentAttribute = (Horus.Attribute)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = attributes;
                for (Object t : iterable2) {
                    Horus.Attribute it = (Horus.Attribute)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)currentAttribute.getName())) continue;
                    v1 = t;
                    break block9;
                }
                v1 = null;
            }
            if (!(v1 == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Horus.Attribute it = (Horus.Attribute)element$iv;
            boolean bl4 = false;
            $this$update_u24lambda_u2413.add(it);
        }
        $this$update_u24lambda_u2413.removeIf(arg_0 -> HorusDataFacade.update$lambda$13$lambda$12(HorusDataFacade::update$lambda$13$lambda$11, arg_0));
        Unit unit = Unit.INSTANCE;
        List attributesPrepared = AttributesPreparator.appendHashAndUpdateAttributes$default(attributesPreparator, attribute, (List)object2, 0L, 4, null);
        object2 = this;
        try {
            $this$update_u24lambda_u2415 = (HorusDataFacade)object2;
            boolean bl5 = false;
            boolean result = super.getOperationDatabaseHelper().updateWithTransaction(CollectionsKt.listOf((Object)new DatabaseOperation.UpdateRecord(entity, SQLKt.mapToDBColumValue(attributesPrepared), CollectionsKt.listOf((Object)new SQL.WhereCondition(new SQL.ColumnValue("id", id), SQL.Comparator.EQUALS)), null, 8, null)), (Function0<Unit>)((Function0)() -> HorusDataFacade.update$lambda$15$lambda$14((HorusDataFacade)$this$update_u24lambda_u2415, entity, attrId, attributes)));
            $this$update_u24lambda_u2415 = Result.constructor-impl((Object)(result ? (DataResult)new DataResult.Success<Unit>(Unit.INSTANCE) : (DataResult)new DataResult.Failure(new IllegalStateException("Update entity failure"))));
        }
        catch (Throwable bl5) {
            $this$update_u24lambda_u2415 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
        }
        object2 = $this$update_u24lambda_u2415;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl6 = false;
            object = new DataResult.Failure(it);
        }
        return (DataResult)object;
    }

    @NotNull
    public final DataResult<Unit> update(@NotNull String entity, @NotNull String id, Horus.Attribute<?> ... attributes) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        return this.update(entity, id, ArraysKt.toList((Object[])attributes));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataResult<Unit> update(@NotNull String entity, @NotNull String id, @NotNull Map<String, ? extends Object> attributes) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Map<String, ? extends Object> map = attributes;
        String string = id;
        String string2 = entity;
        HorusDataFacade horusDataFacade = this;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Horus.Attribute((String)it.getKey(), it.getValue()));
        }
        collection = (List)destination$iv$iv;
        return horusDataFacade.update(string2, string, (List<? extends Horus.Attribute<?>>)collection);
    }

    @NotNull
    public final DataResult<Unit> delete(@NotNull String entity, @NotNull String id) {
        Object object;
        Object $this$delete_u24lambda_u2419;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.validateConstraints(entity);
        Horus.Attribute<String> attrId = new Horus.Attribute<String>("id", id);
        Object object2 = this;
        try {
            $this$delete_u24lambda_u2419 = object2;
            boolean bl = false;
            boolean result = super.getOperationDatabaseHelper().deleteWithTransaction(CollectionsKt.listOf((Object)new DatabaseOperation.DeleteRecord(entity, CollectionsKt.listOf((Object)new SQL.WhereCondition(new SQL.ColumnValue("id", id), SQL.Comparator.EQUALS)), null, 4, null)), (Function0<Unit>)((Function0)() -> HorusDataFacade.delete$lambda$19$lambda$18((HorusDataFacade)$this$delete_u24lambda_u2419, entity, attrId)));
            $this$delete_u24lambda_u2419 = Result.constructor-impl((Object)(result ? (DataResult)new DataResult.Success<Unit>(Unit.INSTANCE) : (DataResult)new DataResult.Failure(new IllegalStateException("Delete entity failure"))));
        }
        catch (Throwable bl) {
            $this$delete_u24lambda_u2419 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$delete_u24lambda_u2419;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = new DataResult.Failure(it);
        }
        return (DataResult)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object querySimple(@NotNull String entity, @NotNull List<SQL.WhereCondition> conditions, @Nullable String orderBy, @Nullable Integer limit, @Nullable Integer offset, @NotNull Continuation<? super DataResult<? extends List<Horus.Entity>>> $completion) {
        void $this$mapTo$iv$iv;
        SimpleQueryBuilder simpleQueryBuilder;
        this.validateConstraintsReadable(entity);
        SimpleQueryBuilder $this$querySimple_u24lambda_u2424 = simpleQueryBuilder = new SimpleQueryBuilder(entity);
        boolean bl = false;
        Collection $this$toTypedArray$iv = conditions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SQL.WhereCondition[] whereConditionArray = thisCollection$iv.toArray(new SQL.WhereCondition[0]);
        QueryBuilder.where$default($this$querySimple_u24lambda_u2424, Arrays.copyOf(whereConditionArray, whereConditionArray.length), null, 2, null);
        String string = orderBy;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            QueryBuilder.orderBy$default($this$querySimple_u24lambda_u2424, it, null, 2, null);
        }
        Integer n = limit;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            $this$querySimple_u24lambda_u2424.limit(it);
        }
        Integer n2 = offset;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl4 = false;
            $this$querySimple_u24lambda_u2424.offset(it);
        }
        SimpleQueryBuilder queryBuilder = simpleQueryBuilder;
        Iterable $this$map$iv = this.getOperationDatabaseHelper().queryRecords(queryBuilder);
        boolean $i$f$map = false;
        Iterable it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it2;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            void var18_23 = it2;
            String string2 = entity;
            boolean $i$f$map2 = false;
            void var21_26 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                void it3;
                Map.Entry item$iv$iv2;
                Map.Entry entry = item$iv$iv2 = iterator.next();
                Collection collection2 = destination$iv$iv2;
                boolean bl6 = false;
                collection2.add(new Horus.Attribute((String)it3.getKey(), it3.getValue()));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n3 = 4;
            Map map2 = null;
            List list = (List)destination$iv$iv2;
            String string3 = string2;
            collection.add(new Horus.Entity(string3, list, map2, n3, defaultConstructorMarker));
        }
        List result = (List)destination$iv$iv;
        return new DataResult.Success<List>(result);
    }

    public static /* synthetic */ Object querySimple$default(HorusDataFacade horusDataFacade, String string, List list, String string2, Integer n, Integer n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 4) != 0) {
            string2 = null;
        }
        if ((n3 & 8) != 0) {
            n = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        return horusDataFacade.querySimple(string, list, string2, n, n2, (Continuation<? super DataResult<? extends List<Horus.Entity>>>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Horus.Entity getById(@NotNull String entity, @NotNull String id) {
        void $this$mapTo$iv$iv;
        SimpleQueryBuilder simpleQueryBuilder;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.validateConstraintsReadable(entity);
        SimpleQueryBuilder $this$getById_u24lambda_u2427 = simpleQueryBuilder = new SimpleQueryBuilder(entity);
        boolean $i$a$-apply-HorusDataFacade$getById$queryBuilder$22 = false;
        SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("id", id), SQL.Comparator.EQUALS)};
        QueryBuilder.where$default($this$getById_u24lambda_u2427, whereConditionArray, null, 2, null);
        SimpleQueryBuilder queryBuilder = simpleQueryBuilder;
        Iterable $this$map$iv = this.getOperationDatabaseHelper().queryRecords(queryBuilder);
        boolean $i$f$map = false;
        Iterable $i$a$-apply-HorusDataFacade$getById$queryBuilder$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_15 = it;
            String string = entity;
            boolean $i$f$map2 = false;
            void var16_18 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                void it2;
                Map.Entry item$iv$iv2;
                Map.Entry entry = item$iv$iv2 = iterator.next();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(new Horus.Attribute((String)it2.getKey(), it2.getValue()));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            Map map2 = null;
            List list = (List)destination$iv$iv2;
            String string2 = string;
            collection.add(new Horus.Entity(string2, list, map2, n, defaultConstructorMarker));
        }
        return (Horus.Entity)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    public final void addDataChangeListener(@NotNull DataChangeListener dataChangeListener) {
        Intrinsics.checkNotNullParameter((Object)dataChangeListener, (String)"dataChangeListener");
        changeListeners.add(dataChangeListener);
    }

    public final void removeDataChangeListener(@NotNull DataChangeListener dataChangeListener) {
        Intrinsics.checkNotNullParameter((Object)dataChangeListener, (String)"dataChangeListener");
        changeListeners.remove(dataChangeListener);
    }

    public final void removeAllDataChangeListeners() {
        changeListeners.clear();
    }

    private final void validateConstraints(String entity) {
        this.validateIsReady();
        this.validateIsEntityExists(entity);
        this.validateIsCanWriteIntoEntity(entity);
    }

    private final void validateConstraintsReadable(String entity) {
        this.validateIsReady();
        this.validateIsEntityExists(entity);
    }

    private final void validateIsReady() {
        if (!isReady) {
            throw new IllegalStateException("Synchronizer not ready");
        }
    }

    private final void validateIsEntityExists(String entity) {
        Object v0;
        block2: {
            Iterable iterable = this.getSyncControlDatabaseHelper().getEntityNames();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)entity)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((String)v0 == null) {
            throw new EntityNotExistsException(entity);
        }
    }

    private final void validateIsCanWriteIntoEntity(String entity) {
        if (this.getSyncControlDatabaseHelper().isEntityCanBeWritable(entity)) {
            return;
        }
        throw new EntityNotWritableException(entity);
    }

    private final void registerEntityEventListeners() {
        EventBus.INSTANCE.register(EventType.ENTITY_CREATED, (Function1<? super Event, Unit>)((Function1)HorusDataFacade::registerEntityEventListeners$lambda$33));
        EventBus.INSTANCE.register(EventType.ENTITY_UPDATED, (Function1<? super Event, Unit>)((Function1)HorusDataFacade::registerEntityEventListeners$lambda$36));
        EventBus.INSTANCE.register(EventType.ENTITY_DELETED, (Function1<? super Event, Unit>)((Function1)HorusDataFacade::registerEntityEventListeners$lambda$39));
    }

    private final String getUserId() {
        String string = HorusAuthentication.INSTANCE.getUserAuthenticatedId$client_release();
        if (string == null) {
            throw new UserNotAuthenticatedException();
        }
        return string;
    }

    private final String generateUUID() {
        return Uuid.Companion.random().toString();
    }

    public final void clear$client_release() {
        isReady = false;
        onCallbackReady = null;
        changeListeners.clear();
    }

    private static final IOperationDatabaseHelper operationDatabaseHelper_delegate$lambda$0() {
        return HorusContainer.INSTANCE.getOperationDatabaseHelper$client_release();
    }

    private static final ISyncControlDatabaseHelper syncControlDatabaseHelper_delegate$lambda$1() {
        return HorusContainer.INSTANCE.getSyncControlDatabaseHelper$client_release();
    }

    private static final Unit _init_$lambda$2(Event it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            isReady = true;
            Function0<Unit> function0 = onCallbackReady;
            if (function0 == null) break block0;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit insert$lambda$5$lambda$4(HorusDataFacade $this_runCatching, String $entity, Horus.Attribute $id, List $attributes) {
        void $this$insert_u24lambda_u245_u24lambda_u244_u24lambda_u243;
        Object object = new Horus.Attribute[]{$id};
        Object object2 = object = CollectionsKt.mutableListOf((Object[])object);
        String string = $entity;
        ISyncControlDatabaseHelper iSyncControlDatabaseHelper = $this_runCatching.getSyncControlDatabaseHelper();
        boolean bl = false;
        $this$insert_u24lambda_u245_u24lambda_u244_u24lambda_u243.addAll($attributes);
        Unit unit = Unit.INSTANCE;
        iSyncControlDatabaseHelper.addActionInsert(string, (List<? extends Horus.Attribute<?>>)object);
        return Unit.INSTANCE;
    }

    private static final boolean update$lambda$13$lambda$11(Horus.Attribute it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)"sync_hash");
    }

    private static final boolean update$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit update$lambda$15$lambda$14(HorusDataFacade $this_runCatching, String $entity, Horus.Attribute $attrId, List $attributes) {
        $this_runCatching.getSyncControlDatabaseHelper().addActionUpdate($entity, $attrId, $attributes);
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$19$lambda$18(HorusDataFacade $this_runCatching, String $entity, Horus.Attribute $attrId) {
        $this_runCatching.getSyncControlDatabaseHelper().addActionDelete($entity, $attrId);
        return Unit.INSTANCE;
    }

    private static final Unit registerEntityEventListeners$lambda$33(Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = changeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Map attributes;
            DataChangeListener listener = (DataChangeListener)element$iv;
            boolean bl = false;
            Map<String, Object> map = it.getData();
            Object object2 = map != null ? map.get("entity") : null;
            String string = object2 instanceof String ? (String)object2 : null;
            if (string == null) {
                string = "";
            }
            String entity = string;
            Map<String, Object> map2 = it.getData();
            Object object3 = map2 != null ? map2.get("attributes") : null;
            Map map3 = object3 instanceof Map ? (Map)object3 : null;
            if (map3 == null) {
                map3 = attributes = MapsKt.emptyMap();
            }
            if ((object = it.getData()) == null || (object = object.get("id")) == null) continue;
            Object it2 = object;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type kotlin.String");
            listener.onInsert(entity, (String)it2, attributes);
        }
        return Unit.INSTANCE;
    }

    private static final Unit registerEntityEventListeners$lambda$36(Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = changeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Map attributes;
            DataChangeListener listener = (DataChangeListener)element$iv;
            boolean bl = false;
            Map<String, Object> map = it.getData();
            Object object2 = map != null ? map.get("entity") : null;
            String string = object2 instanceof String ? (String)object2 : null;
            if (string == null) {
                string = "";
            }
            String entity = string;
            Map<String, Object> map2 = it.getData();
            Object object3 = map2 != null ? map2.get("attributes") : null;
            Map map3 = object3 instanceof Map ? (Map)object3 : null;
            if (map3 == null) {
                map3 = attributes = MapsKt.emptyMap();
            }
            if ((object = it.getData()) == null || (object = object.get("id")) == null) continue;
            Object it2 = object;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type kotlin.String");
            listener.onUpdate(entity, (String)it2, attributes);
        }
        return Unit.INSTANCE;
    }

    private static final Unit registerEntityEventListeners$lambda$39(Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = changeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String entity;
            DataChangeListener listener = (DataChangeListener)element$iv;
            boolean bl = false;
            Map<String, Object> map = it.getData();
            Object object2 = map != null ? map.get("entity") : null;
            String string = object2 instanceof String ? (String)object2 : null;
            if (string == null) {
                string = entity = "";
            }
            if ((object = it.getData()) == null || (object = object.get("id")) == null) continue;
            Object it2 = object;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type kotlin.String");
            listener.onDelete(entity, (String)it2);
        }
        return Unit.INSTANCE;
    }

    static {
        changeListeners = new ArrayList();
        operationDatabaseHelper$delegate = LazyKt.lazy(HorusDataFacade::operationDatabaseHelper_delegate$lambda$0);
        syncControlDatabaseHelper$delegate = LazyKt.lazy(HorusDataFacade::syncControlDatabaseHelper_delegate$lambda$1);
        INSTANCE.registerEntityEventListeners();
        EventBus.INSTANCE.register(EventType.ON_READY, (Function1<? super Event, Unit>)((Function1)HorusDataFacade::_init_$lambda$2));
    }
}

