/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.control;

import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.apptank.horus.client.control.ISyncControlDatabaseHelper;
import org.apptank.horus.client.control.QueueActionsTable;
import org.apptank.horus.client.control.SyncControl;
import org.apptank.horus.client.control.SyncControlTable;
import org.apptank.horus.client.data.Horus;
import org.apptank.horus.client.data.InternalModel;
import org.apptank.horus.client.database.Cursor;
import org.apptank.horus.client.database.SQL;
import org.apptank.horus.client.database.SQLiteHelper;
import org.apptank.horus.client.database.builder.QueryBuilder;
import org.apptank.horus.client.database.builder.SimpleQueryBuilder;
import org.apptank.horus.client.eventbus.Event;
import org.apptank.horus.client.eventbus.EventBus;
import org.apptank.horus.client.eventbus.EventType;
import org.apptank.horus.client.extensions.DatabaseExtensionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016J0\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016J\u001e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0016H\u0016J\u0016\u0010\u001d\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0016H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u001cH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0016J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0004H\u0016J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0002JA\u0010*\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2'\u0010-\u001a#\u0012\u0004\u0012\u00020\u0004\u0012\u0015\u0012\u0013\u0018\u00010/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\t020.j\u0002`3H\u0002J\u0010\u00104\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u00105\u001a\u00020\u0010H\u0002JA\u00106\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042'\u00107\u001a#\u0012\u0004\u0012\u00020\u0004\u0012\u0015\u0012\u0013\u0018\u00010/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\t020.j\u0002`3H\u0002JA\u00108\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042'\u00107\u001a#\u0012\u0004\u0012\u00020\u0004\u0012\u0015\u0012\u0013\u0018\u00010/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\t020.j\u0002`3H\u0002J\u0018\u00109\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a8\u0006:"}, d2={"Lorg/apptank/horus/client/control/SyncControlDatabaseHelper;", "Lorg/apptank/horus/client/database/SQLiteHelper;", "Lorg/apptank/horus/client/control/ISyncControlDatabaseHelper;", "databaseName", "", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "<init>", "(Ljava/lang/String;Lapp/cash/sqldelight/db/SqlDriver;)V", "isStatusCompleted", "", "type", "Lorg/apptank/horus/client/control/SyncControl$OperationType;", "getLastDatetimeCheckpoint", "", "addSyncTypeStatus", "", "status", "Lorg/apptank/horus/client/control/SyncControl$Status;", "addActionInsert", "entity", "attributes", "", "Lorg/apptank/horus/client/data/Horus$Attribute;", "addActionUpdate", "id", "addActionDelete", "getPendingActions", "Lorg/apptank/horus/client/control/SyncControl$Action;", "completeActions", "actionIds", "", "getLastActionCompleted", "getCompletedActionsAfterDatetime", "datetime", "getEntityNames", "getWritableEntityNames", "isEntityCanBeWritable", "entityName", "createSyncActionFromCursor", "cursor", "Lorg/apptank/horus/client/database/Cursor;", "addAction", "actionType", "Lorg/apptank/horus/client/control/SyncControl$ActionType;", "dataJSON", "", "", "Lkotlinx/serialization/Serializable;", "with", "Lorg/apptank/horus/client/serialization/AnySerializer;", "Lorg/apptank/horus/client/base/DataMap;", "validateIfEntityExists", "emitEventActionCreated", "emitEntityCreated", "data", "emitEntityUpdated", "emitEntityDeleted", "client_release"})
@SourceDebugExtension(value={"SMAP\nSyncControlDatabaseHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncControlDatabaseHelper.kt\norg/apptank/horus/client/control/SyncControlDatabaseHelper\n+ 2 DatabaseExtension.kt\norg/apptank/horus/client/extensions/DatabaseExtensionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n65#2:358\n65#2:362\n65#2:363\n65#2:378\n65#2:379\n65#2:380\n65#2:381\n65#2:405\n1755#3,3:359\n1187#3,2:364\n1261#3,4:366\n230#3,2:370\n1187#3,2:372\n1261#3,4:374\n1557#3:382\n1628#3,3:383\n827#3:386\n855#3,2:387\n774#3:389\n865#3,2:390\n1557#3:392\n1628#3,3:393\n827#3:396\n855#3,2:397\n774#3:399\n865#3,2:400\n1755#3,3:402\n1#4:406\n*S KotlinDebug\n*F\n+ 1 SyncControlDatabaseHelper.kt\norg/apptank/horus/client/control/SyncControlDatabaseHelper\n*L\n44#1:358\n58#1:362\n72#1:363\n152#1:378\n174#1:379\n193#1:380\n215#1:381\n291#1:405\n48#1:359,3\n89#1:364,2\n89#1:366,4\n99#1:370,2\n118#1:372,2\n118#1:374,4\n242#1:382\n242#1:383,3\n243#1:386\n243#1:387,2\n247#1:389\n247#1:390,2\n247#1:392\n247#1:393,3\n248#1:396\n248#1:397,2\n258#1:399\n258#1:400,2\n258#1:402,3\n*E\n"})
public final class SyncControlDatabaseHelper
extends SQLiteHelper
implements ISyncControlDatabaseHelper {
    public SyncControlDatabaseHelper(@NotNull String databaseName, @NotNull SqlDriver driver2) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        super(driver2, databaseName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isStatusCompleted(@NotNull SyncControl.OperationType type) {
        boolean bl;
        block3: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            SqlDriver $this$handle$iv = this.getDriver();
            boolean $i$f$handle = false;
            SqlDriver $this$isStatusCompleted_u24lambda_u242 = $this$handle$iv;
            boolean bl2 = false;
            Iterable iterable = this.rawQuery("SELECT EXISTS(SELECT 1 FROM horus_sync_control WHERE type = " + type.getId() + " AND status = " + SyncControl.Status.COMPLETED.getId() + " LIMIT 1)", SyncControlDatabaseHelper::isStatusCompleted$lambda$2$lambda$0);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl3 = false;
                    if (!it) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public long getLastDatetimeCheckpoint() {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$getLastDatetimeCheckpoint_u24lambda_u244 = $this$handle$iv;
        boolean bl = false;
        Long l = (Long)CollectionsKt.firstOrNull(this.rawQuery("SELECT datetime FROM horus_sync_control WHERE type = " + SyncControl.OperationType.CHECKPOINT.getId() + " ORDER BY id DESC LIMIT 1", SyncControlDatabaseHelper::getLastDatetimeCheckpoint$lambda$4$lambda$3));
        return l != null ? l : 0L;
    }

    @Override
    public void addSyncTypeStatus(@NotNull SyncControl.OperationType type, @NotNull SyncControl.Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$addSyncTypeStatus_u24lambda_u245 = $this$handle$iv;
        boolean bl = false;
        this.insertOrThrow("horus_sync_control", SyncControlTable.INSTANCE.mapToCreate(type, status));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addActionInsert(@NotNull String entity, @NotNull List<? extends Horus.Attribute<?>> attributes) {
        Object element$iv2;
        SyncControlDatabaseHelper syncControlDatabaseHelper;
        String string;
        Map data;
        block2: {
            void $this$first$iv;
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.validateIfEntityExists(entity);
            Iterable $this$associate$iv = attributes;
            boolean $i$f$associate22 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Horus.Attribute it = (Horus.Attribute)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getName(), (Object)String.valueOf(it.getValue()));
                map.put(pair.getFirst(), pair.getSecond());
            }
            data = destination$iv$iv;
            this.addAction(entity, SyncControl.ActionType.INSERT, data);
            Iterable $i$f$associate22 = attributes;
            string = entity;
            syncControlDatabaseHelper = this;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Horus.Attribute it = (Horus.Attribute)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"id")) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object e = element$iv2;
        Object t = ((Horus.Attribute)e).getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.String");
        syncControlDatabaseHelper.emitEntityCreated(string, (String)t, data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addActionUpdate(@NotNull String entity, @NotNull Horus.Attribute<String> id, @NotNull List<? extends Horus.Attribute<?>> attributes) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.validateIfEntityExists(entity);
        Iterable $this$associate$iv = attributes;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Horus.Attribute it = (Horus.Attribute)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)String.valueOf(it.getValue()));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map data = destination$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)id.getValue()), TuplesKt.to((Object)"attributes", (Object)data)};
        this.addAction(entity, SyncControl.ActionType.UPDATE, MapsKt.mapOf((Pair[])pairArray));
        this.emitEntityUpdated(entity, id.getValue(), data);
    }

    @Override
    public void addActionDelete(@NotNull String entity, @NotNull Horus.Attribute<String> id) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        this.validateIfEntityExists(entity);
        this.addAction(entity, SyncControl.ActionType.DELETE, MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)id.getValue())));
        this.emitEntityDeleted(entity, id.getValue());
    }

    @Override
    @NotNull
    public List<SyncControl.Action> getPendingActions() {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$getPendingActions_u24lambda_u2410 = $this$handle$iv;
        boolean bl = false;
        SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("status", SyncControl.ActionStatus.PENDING.getId()), null, 2, null)};
        String sqlSentence = QueryBuilder.orderBy$default(QueryBuilder.where$default(new SimpleQueryBuilder("horus_queue_actions"), whereConditionArray, null, 2, null), "datetime", null, 2, null).build();
        return this.queryResult$client_release(sqlSentence, arg_0 -> SyncControlDatabaseHelper.getPendingActions$lambda$10$lambda$9(this, arg_0));
    }

    @Override
    public boolean completeActions(@NotNull List<Integer> actionIds) {
        Intrinsics.checkNotNullParameter(actionIds, (String)"actionIds");
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$completeActions_u24lambda_u2411 = $this$handle$iv;
        boolean bl = false;
        Map values = MapsKt.mapOf((Pair)TuplesKt.to((Object)"status", (Object)SyncControl.ActionStatus.COMPLETED.getId()));
        String whereClause = "id IN (" + CollectionsKt.joinToString$default((Iterable)actionIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
        return this.update("horus_queue_actions", values, whereClause) == (long)actionIds.size();
    }

    @Override
    @Nullable
    public SyncControl.Action getLastActionCompleted() {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$getLastActionCompleted_u24lambda_u2413 = $this$handle$iv;
        boolean bl = false;
        SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("status", SyncControl.ActionStatus.COMPLETED.getId()), null, 2, null)};
        String sentenceSql = QueryBuilder.orderBy$default(QueryBuilder.where$default(new SimpleQueryBuilder("horus_queue_actions"), whereConditionArray, null, 2, null), "id", null, 2, null).limit(1).build();
        return (SyncControl.Action)CollectionsKt.firstOrNull(this.queryResult$client_release(sentenceSql, arg_0 -> SyncControlDatabaseHelper.getLastActionCompleted$lambda$13$lambda$12(this, arg_0)));
    }

    @Override
    @NotNull
    public List<SyncControl.Action> getCompletedActionsAfterDatetime(long datetime) {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$getCompletedActionsAfterDatetime_u24lambda_u2415 = $this$handle$iv;
        boolean bl = false;
        SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("datetime", datetime), SQL.Comparator.GREATER_THAN)};
        QueryBuilder queryBuilder = QueryBuilder.where$default(new SimpleQueryBuilder("horus_queue_actions"), whereConditionArray, null, 2, null);
        whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("status", SyncControl.ActionStatus.COMPLETED.getId()), null, 2, null)};
        String sqlSentence = QueryBuilder.orderBy$default(QueryBuilder.where$default(queryBuilder, whereConditionArray, null, 2, null), "datetime", null, 2, null).build();
        return this.queryResult$client_release(sqlSentence, arg_0 -> SyncControlDatabaseHelper.getCompletedActionsAfterDatetime$lambda$15$lambda$14(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getEntityNames() {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getTableEntities$client_release();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            InternalModel.TableEntity tableEntity = (InternalModel.TableEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((InternalModel.TableEntity)((Object)it)).getName());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"horus_sync_control") || Intrinsics.areEqual((Object)it, (Object)"horus_queue_actions")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getWritableEntityNames() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getTableEntities$client_release();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (InternalModel.TableEntity)element$iv$iv;
            boolean bl = false;
            if (!((InternalModel.TableEntity)it).isWritable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (InternalModel.TableEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((InternalModel.TableEntity)it).getName());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"horus_sync_control") || Intrinsics.areEqual((Object)it, (Object)"horus_queue_actions")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEntityCanBeWritable(@NotNull String entityName) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
            Iterable $this$filter$iv = this.getTableEntities$client_release();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                InternalModel.TableEntity it = (InternalModel.TableEntity)element$iv$iv;
                boolean bl2 = false;
                if (!it.isWritable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InternalModel.TableEntity it = (InternalModel.TableEntity)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)entityName)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final SyncControl.Action createSyncActionFromCursor(Cursor cursor) {
        return new SyncControl.Action(((Number)cursor.getValue("id")).intValue(), SyncControl.ActionType.Companion.fromId(((Number)cursor.getValue("action_type")).intValue()), (String)cursor.getValue("entity"), SyncControl.ActionStatus.Companion.fromId(((Number)cursor.getValue("status")).intValue()), cursor.getStringAndConvertToMap("data"), TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochSeconds$default((Instant.Companion)Instant.Companion, (long)((Number)cursor.getValue("datetime")).longValue(), (long)0L, (int)2, null), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())));
    }

    private final void addAction(String entity, SyncControl.ActionType actionType, Map<String, ? extends Object> dataJSON) {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$addAction_u24lambda_u2423 = $this$handle$iv;
        boolean bl = false;
        this.insertOrThrow("horus_queue_actions", QueueActionsTable.INSTANCE.mapToCreate(actionType, entity, dataJSON));
        this.emitEventActionCreated();
    }

    private final void validateIfEntityExists(String entity) {
        Object v0;
        block2: {
            Iterable iterable = this.getEntityNames();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)entity)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((String)v0 == null) {
            SyncControlDatabaseHelper $this$validateIfEntityExists_u24lambda_u2425 = this;
            boolean bl = false;
            throw new IllegalArgumentException("Entity " + entity + " does not exist");
        }
    }

    private final void emitEventActionCreated() {
        EventBus.INSTANCE.emit(EventType.ACTION_CREATED, new Event(null, 1, null));
    }

    private final void emitEntityCreated(String entity, String id, Map<String, ? extends Object> data) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"entity", (Object)entity), TuplesKt.to((Object)"id", (Object)id), TuplesKt.to((Object)"attributes", data)};
        EventBus.INSTANCE.emit(EventType.ENTITY_CREATED, new Event(MapsKt.mutableMapOf((Pair[])pairArray)));
    }

    private final void emitEntityUpdated(String entity, String id, Map<String, ? extends Object> data) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"entity", (Object)entity), TuplesKt.to((Object)"id", (Object)id), TuplesKt.to((Object)"attributes", data)};
        EventBus.INSTANCE.emit(EventType.ENTITY_UPDATED, new Event(MapsKt.mutableMapOf((Pair[])pairArray)));
    }

    private final void emitEntityDeleted(String entity, String id) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"entity", (Object)entity), TuplesKt.to((Object)"id", (Object)id)};
        EventBus.INSTANCE.emit(EventType.ENTITY_DELETED, new Event(MapsKt.mutableMapOf((Pair[])pairArray)));
    }

    private static final Boolean isStatusCompleted$lambda$2$lambda$0(SqlCursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DatabaseExtensionKt.getRequireInt(it, 0) == 1;
    }

    private static final Long getLastDatetimeCheckpoint$lambda$4$lambda$3(SqlCursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DatabaseExtensionKt.getRequireLong(it, 0);
    }

    private static final SyncControl.Action getPendingActions$lambda$10$lambda$9(SyncControlDatabaseHelper this$0, Cursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createSyncActionFromCursor(it);
    }

    private static final SyncControl.Action getLastActionCompleted$lambda$13$lambda$12(SyncControlDatabaseHelper this$0, Cursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createSyncActionFromCursor(it);
    }

    private static final SyncControl.Action getCompletedActionsAfterDatetime$lambda$15$lambda$14(SyncControlDatabaseHelper this$0, Cursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createSyncActionFromCursor(it);
    }
}

