/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.database;

import app.cash.sqldelight.TransacterImpl;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apptank.horus.client.data.InternalModel;
import org.apptank.horus.client.database.Column;
import org.apptank.horus.client.database.Cursor;
import org.apptank.horus.client.database.CursorValue;
import org.apptank.horus.client.database.SQL;
import org.apptank.horus.client.database.builder.SimpleQueryBuilder;
import org.apptank.horus.client.extensions.DatabaseExtensionKt;
import org.apptank.horus.client.extensions.FunctionsKt;
import org.apptank.horus.client.extensions.ListExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 :2\u00020\u0001:\u0001:B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u00a2\u0006\u0002\b\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0010J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\t\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\u0015H\u0004J7\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00120\t\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\u0015H\u0000\u00a2\u0006\u0002\b\u0019J9\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052'\u0010\u001d\u001a#\u0012\u0004\u0012\u00020\u0005\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\t0\"0\u001ej\u0002`#H\u0004JA\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u00052'\u0010\u001d\u001a#\u0012\u0004\u0012\u00020\u0005\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\t0\"0\u001ej\u0002`#2\u0006\u0010&\u001a\u00020\u0005H\u0004J\u0018\u0010'\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0004J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J,\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010+\u001a\u00020\u0016H\u0002J*\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002J\u0010\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0010\u00101\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u00102\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001e\u00103\u001a\u00020\u00052\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\t2\u0006\u00106\u001a\u000207H\u0004J3\u00108\u001a#\u0012\u0004\u0012\u00020\u0005\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\t0\"0\u001ej\u0002`#*\b\u0012\u0004\u0012\u0002090\tH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/apptank/horus/client/database/SQLiteHelper;", "Lapp/cash/sqldelight/TransacterImpl;", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "databaseName", "", "<init>", "(Lapp/cash/sqldelight/db/SqlDriver;Ljava/lang/String;)V", "getTableEntities", "", "Lorg/apptank/horus/client/data/InternalModel$TableEntity;", "getTableEntities$client_release", "getTables", "getColumns", "Lorg/apptank/horus/client/database/Column;", "tableName", "getColumns$client_release", "rawQuery", "T", "query", "mapper", "Lkotlin/Function1;", "Lapp/cash/sqldelight/db/SqlCursor;", "queryResult", "Lorg/apptank/horus/client/database/Cursor;", "queryResult$client_release", "insertOrThrow", "", "table", "values", "", "", "Lkotlinx/serialization/Serializable;", "with", "Lorg/apptank/horus/client/serialization/AnySerializer;", "Lorg/apptank/horus/client/base/DataMap;", "update", "", "where", "delete", "executeInsertOrThrow", "buildCursorValues", "attributesSelected", "cursor", "filtrateColumns", "columns", "getTableName", "statement", "extractSelectAttributes", "executeUpdate", "executeDelete", "buildWhereEvaluation", "conditions", "Lorg/apptank/horus/client/database/SQL$WhereCondition;", "operator", "Lorg/apptank/horus/client/database/SQL$LogicOperator;", "prepareMap", "Lorg/apptank/horus/client/database/SQL$ColumnValue;", "Companion", "client_release"})
@SourceDebugExtension(value={"SMAP\nSQLiteHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLiteHelper.kt\norg/apptank/horus/client/database/SQLiteHelper\n+ 2 DatabaseExtension.kt\norg/apptank/horus/client/extensions/DatabaseExtensionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n65#2:330\n65#2:331\n65#2:335\n65#2:336\n774#3:332\n865#3,2:333\n1863#3,2:337\n774#3:339\n865#3,2:340\n1567#3:342\n1598#3,4:343\n1187#3,2:347\n1261#3,4:349\n1863#3,2:353\n*S KotlinDebug\n*F\n+ 1 SQLiteHelper.kt\norg/apptank/horus/client/database/SQLiteHelper\n*L\n48#1:330\n71#1:331\n94#1:335\n195#1:336\n77#1:332\n77#1:333,2\n215#1:337,2\n242#1:339\n242#1:340,2\n244#1:342\n244#1:343,4\n312#1:347,2\n312#1:349,4\n144#1:353,2\n*E\n"})
public abstract class SQLiteHelper
extends TransacterImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String databaseName;
    @NotNull
    private static final List<String> TABLES_SYSTEM;
    @NotNull
    private static Map<String, List<InternalModel.TableEntity>> CACHE_TABLES;
    @NotNull
    private static Map<String, Map<String, List<Column>>> CACHE_COLUMN_NAMES;

    public SQLiteHelper(@NotNull SqlDriver driver2, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        super(driver2);
        this.databaseName = databaseName;
    }

    @NotNull
    public final List<InternalModel.TableEntity> getTableEntities$client_release() {
        List list;
        List<InternalModel.TableEntity> list2 = CACHE_TABLES.get(this.databaseName);
        boolean bl = list2 != null ? !((Collection)list2).isEmpty() : false;
        if (bl) {
            List list3 = CACHE_TABLES.get(this.databaseName);
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            return list3;
        }
        List tables = new ArrayList();
        String simpleQuery = new SimpleQueryBuilder("horus_entities").build();
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$getTableEntities_u24lambda_u241 = $this$handle$iv;
        boolean bl2 = false;
        List result = this.queryResult$client_release(simpleQuery, SQLiteHelper::getTableEntities$lambda$1$lambda$0);
        tables.addAll(result);
        List it = list = tables;
        boolean bl3 = false;
        CACHE_TABLES.put(this.databaseName, it);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getTables() {
        void $this$filterTo$iv$iv;
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$getTables_u24lambda_u245 = $this$handle$iv;
        boolean bl = false;
        List result = this.rawQuery("SELECT name FROM sqlite_master WHERE type='table'", SQLiteHelper::getTables$lambda$5$lambda$3);
        Iterable $this$filter$iv = result;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (!ListExtensionsKt.notContains(TABLES_SYSTEM, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<Column> getColumns$client_release(@NotNull String tableName) {
        List<Column> list;
        block3: {
            List<Column> columns;
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            Map<String, List<Column>> map = CACHE_COLUMN_NAMES.get(this.databaseName);
            boolean bl = map != null ? map.containsKey(tableName) : false;
            if (bl) {
                Object object = CACHE_COLUMN_NAMES.get(this.databaseName);
                if (object == null || (object = object.get(tableName)) == null) {
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
            String query = "PRAGMA table_info(" + tableName + ");";
            SqlDriver $this$handle$iv = this.getDriver();
            boolean $i$f$handle = false;
            SqlDriver $this$getColumns_u24lambda_u247 = $this$handle$iv;
            boolean bl2 = false;
            List<Column> it = list = (columns = this.rawQuery(query, SQLiteHelper::getColumns$lambda$7$lambda$6));
            boolean bl3 = false;
            if (CACHE_COLUMN_NAMES.get(this.databaseName) == null) {
                CACHE_COLUMN_NAMES.put(this.databaseName, new LinkedHashMap());
            }
            Map<String, List<Column>> map2 = CACHE_COLUMN_NAMES.get(this.databaseName);
            if (map2 == null) break block3;
            map2.put(tableName, it);
        }
        return list;
    }

    @NotNull
    protected final <T> List<T> rawQuery(@NotNull String query, @NotNull Function1<? super SqlCursor, ? extends T> mapper) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return (List)SqlDriver.DefaultImpls.executeQuery$default((SqlDriver)this.getDriver(), null, (String)query, arg_0 -> SQLiteHelper.rawQuery$lambda$10(mapper, arg_0), (int)0, null, (int)16, null).getValue();
    }

    @NotNull
    public final <T> List<T> queryResult$client_release(@NotNull String query, @NotNull Function1<? super Cursor, ? extends T> mapper) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        String tableName = this.getTableName(query);
        List<String> attributes = this.extractSelectAttributes(query);
        return (List)SqlDriver.DefaultImpls.executeQuery$default((SqlDriver)this.getDriver(), null, (String)query, arg_0 -> SQLiteHelper.queryResult$lambda$13(this, tableName, attributes, mapper, arg_0), (int)0, null, (int)16, null).getValue();
    }

    protected final void insertOrThrow(@NotNull String table, @NotNull Map<String, ? extends Object> values) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        String query = DatabaseExtensionKt.createSQLInsert(this.getDriver(), table, values);
        FunctionsKt.info("Insert query: " + query);
        this.executeInsertOrThrow(query);
    }

    protected final long update(@NotNull String table, @NotNull Map<String, ? extends Object> values, @NotNull String where) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        String setValues = CollectionsKt.joinToString$default((Iterable)values.entrySet(), (CharSequence)", ", null, null, (int)0, null, SQLiteHelper::update$lambda$14, (int)30, null);
        String query = "UPDATE " + table + " SET " + setValues + " WHERE " + where + ';';
        FunctionsKt.info("Update query: " + query);
        return this.executeUpdate(query);
    }

    protected final long delete(@NotNull String table, @NotNull String where) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        String query = "DELETE FROM " + table + " WHERE " + where + ';';
        FunctionsKt.info("Delete query: " + query);
        return this.executeDelete(query);
    }

    private final void executeInsertOrThrow(String query) {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        SqlDriver $this$executeInsertOrThrow_u24lambda_u2415 = $this$handle$iv;
        boolean bl = false;
        if (((Number)SqlDriver.DefaultImpls.execute$default((SqlDriver)$this$executeInsertOrThrow_u24lambda_u2415, null, (String)query, (int)0, null, (int)8, null).getValue()).longValue() == 0L) {
            throw new IllegalStateException("Insertion failed");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Cursor> buildCursorValues(String tableName, List<String> attributesSelected, SqlCursor cursor) {
        List<Column> columns = this.filtrateColumns(this.getColumns$client_release(tableName), attributesSelected);
        List cursors = new ArrayList();
        int index = 0;
        while (((Boolean)cursor.next().getValue()).booleanValue()) {
            List cursorValues = new ArrayList();
            Iterable $this$forEach$iv = columns;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorValue<Float> cursorValue;
                block18: {
                    Column column;
                    block14: {
                        block17: {
                            block15: {
                                block16: {
                                    column = (Column)element$iv;
                                    boolean bl = false;
                                    String string = column.getType();
                                    switch (string.hashCode()) {
                                        case 66988604: {
                                            if (!string.equals("FLOAT")) {
                                                throw new IllegalArgumentException("Invalid column type " + column.getType());
                                            }
                                            break block14;
                                        }
                                        case 2511262: {
                                            if (!string.equals("REAL")) {
                                                throw new IllegalArgumentException("Invalid column type " + column.getType());
                                            }
                                            break block15;
                                        }
                                        case -1838656495: {
                                            if (string.equals("STRING")) break;
                                            throw new IllegalArgumentException("Invalid column type " + column.getType());
                                        }
                                        case 2571565: {
                                            if (!string.equals("TEXT")) {
                                                throw new IllegalArgumentException("Invalid column type " + column.getType());
                                            }
                                            break block16;
                                        }
                                        case 782694408: {
                                            if (!string.equals("BOOLEAN")) {
                                                throw new IllegalArgumentException("Invalid column type " + column.getType());
                                            }
                                            break block17;
                                        }
                                        case -1618932450: {
                                            if (!string.equals("INTEGER")) throw new IllegalArgumentException("Invalid column type " + column.getType());
                                            cursorValue = new CursorValue<Integer>(DatabaseExtensionKt.getRequireInt(cursor, column.getPosition()), column);
                                            break block18;
                                        }
                                    }
                                    cursorValue = new CursorValue<String>(DatabaseExtensionKt.getRequireString(cursor, column.getPosition()), column);
                                    break block18;
                                }
                                cursorValue = new CursorValue<String>(DatabaseExtensionKt.getRequireString(cursor, column.getPosition()), column);
                                break block18;
                            }
                            cursorValue = new CursorValue<Double>(DatabaseExtensionKt.getRequireDouble(cursor, column.getPosition()), column);
                            break block18;
                        }
                        cursorValue = new CursorValue<Boolean>(DatabaseExtensionKt.getRequireBoolean(cursor, column.getPosition()), column);
                        break block18;
                    }
                    cursorValue = new CursorValue<Float>(Float.valueOf((float)DatabaseExtensionKt.getRequireDouble(cursor, column.getPosition())), column);
                    break block18;
                    throw new IllegalArgumentException("Invalid column type " + column.getType());
                }
                cursorValues.add(cursorValue);
            }
            cursors.add(new Cursor(index, tableName, cursorValues));
            ++index;
        }
        return cursors;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Column> filtrateColumns(List<Column> columns, List<String> attributesSelected) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = columns;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Column column = (Column)element$iv$iv;
            boolean bl = false;
            if (!(!((Collection)attributesSelected).isEmpty() && attributesSelected.contains(column.getName()) || attributesSelected.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$mapIndexed = false;
        $this$filterTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void column;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Column column2 = (Column)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Column((int)index, column.getName(), column.getType(), column.getNullable()));
        }
        return (List)destination$iv$iv;
    }

    private final String getTableName(String statement) {
        Regex regex = new Regex("SELECT .+ FROM (\\w+)");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)statement, (int)0, (int)2, null);
        MatchResult matchResult2 = matchResult;
        if (matchResult2 == null || (matchResult2 = matchResult2.getDestructured()) == null) {
            throw new IllegalArgumentException("Invalid statement");
        }
        String tableName = (String)matchResult2.getMatch().getGroupValues().get(1);
        return tableName;
    }

    private final List<String> extractSelectAttributes(String statement) {
        Regex regex = new Regex("SELECT (.+) FROM \\w+");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)statement, (int)0, (int)2, null);
        MatchResult matchResult2 = matchResult;
        if (matchResult2 == null || (matchResult2 = matchResult2.getDestructured()) == null) {
            throw new IllegalArgumentException("Invalid statement");
        }
        String attributes = (String)matchResult2.getMatch().getGroupValues().get(1);
        if (Intrinsics.areEqual((Object)attributes, (Object)"*")) {
            return CollectionsKt.emptyList();
        }
        if (StringsKt.contains$default((CharSequence)attributes, (CharSequence)", ", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{", "};
            return StringsKt.split$default((CharSequence)attributes, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        String[] stringArray = new String[]{","};
        return StringsKt.split$default((CharSequence)attributes, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    private final long executeUpdate(String query) {
        return ((Number)SqlDriver.DefaultImpls.execute$default((SqlDriver)this.getDriver(), null, (String)query, (int)0, null, (int)8, null).getValue()).longValue();
    }

    private final long executeDelete(String query) {
        return ((Number)SqlDriver.DefaultImpls.execute$default((SqlDriver)this.getDriver(), null, (String)query, (int)0, null, (int)8, null).getValue()).longValue();
    }

    @NotNull
    protected final String buildWhereEvaluation(@NotNull List<SQL.WhereCondition> conditions, @NotNull SQL.LogicOperator operator) {
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)conditions, (CharSequence)operator.name(), null, null, (int)0, null, SQLiteHelper::buildWhereEvaluation$lambda$19, (int)30, null))).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<String, Object> prepareMap(@NotNull List<SQL.ColumnValue> $this$prepareMap) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$prepareMap, (String)"<this>");
        Iterable $this$associate$iv = $this$prepareMap;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            SQL.ColumnValue it = (SQL.ColumnValue)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getColumn(), (Object)it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final InternalModel.TableEntity getTableEntities$lambda$1$lambda$0(Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        return new InternalModel.TableEntity((String)cursor.getValue("name"), (Boolean)cursor.getValue("is_writable"));
    }

    private static final String getTables$lambda$5$lambda$3(SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        return cursor.getString(0);
    }

    private static final Column getColumns$lambda$7$lambda$6(SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        return new Column(DatabaseExtensionKt.getRequireInt(cursor, 0), DatabaseExtensionKt.getRequireString(cursor, 1), DatabaseExtensionKt.getRequireString(cursor, 2), !DatabaseExtensionKt.getRequireBoolean(cursor, 3));
    }

    private static final QueryResult rawQuery$lambda$10(Function1 $mapper, SqlCursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List resultList = new ArrayList();
        while (((Boolean)it.next().getValue()).booleanValue()) {
            Object item;
            if ($mapper.invoke((Object)it) == null) continue;
            boolean bl = false;
            resultList.add(item);
        }
        return (QueryResult)QueryResult.Value.box-impl((Object)QueryResult.Value.constructor-impl((Object)resultList));
    }

    private static final QueryResult queryResult$lambda$13(SQLiteHelper this$0, String $tableName, List $attributes, Function1 $mapper, SqlCursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List resultList = new ArrayList();
        Iterable $this$forEach$iv = this$0.buildCursorValues($tableName, $attributes, it);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object item;
            Cursor cursor = (Cursor)element$iv;
            boolean bl = false;
            if ($mapper.invoke((Object)cursor) == null) continue;
            boolean bl2 = false;
            resultList.add(item);
        }
        return (QueryResult)QueryResult.Value.box-impl((Object)QueryResult.Value.constructor-impl((Object)resultList));
    }

    private static final CharSequence update$lambda$14(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String key = (String)entry.getKey();
        Object value = entry.getValue();
        Object v = value;
        return key + " = " + (v != null ? DatabaseExtensionKt.prepareSQLValueAsString(v) : null);
    }

    private static final CharSequence buildWhereEvaluation$lambda$19(SQL.WhereCondition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ' ' + it.getColumnValue().getColumn() + ' ' + it.getComparator().getValue() + ' ' + DatabaseExtensionKt.prepareSQLValueAsString(it.getColumnValue().getValue()) + ' ';
    }

    static {
        Object[] objectArray = new String[]{"android_metadata", "sqlite_sequence"};
        TABLES_SYSTEM = CollectionsKt.listOf((Object[])objectArray);
        CACHE_TABLES = new LinkedHashMap();
        CACHE_COLUMN_NAMES = new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/apptank/horus/client/database/SQLiteHelper$Companion;", "", "<init>", "()V", "TABLES_SYSTEM", "", "", "CACHE_TABLES", "", "Lorg/apptank/horus/client/data/InternalModel$TableEntity;", "CACHE_COLUMN_NAMES", "Lorg/apptank/horus/client/database/Column;", "flushCache", "", "client_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void flushCache() {
            CACHE_TABLES = new LinkedHashMap();
            CACHE_COLUMN_NAMES = new LinkedHashMap();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

