/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.tasks;

import com.russhwolf.settings.Settings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.apptank.horus.client.base.DataResult;
import org.apptank.horus.client.control.helper.IOperationDatabaseHelper;
import org.apptank.horus.client.control.helper.ISyncControlDatabaseHelper;
import org.apptank.horus.client.data.Horus;
import org.apptank.horus.client.database.struct.DatabaseOperationKt;
import org.apptank.horus.client.di.INetworkValidator;
import org.apptank.horus.client.extensions.FunctionsKt;
import org.apptank.horus.client.extensions.InstantExtensionKt;
import org.apptank.horus.client.sync.network.dto.ExtensionsKt;
import org.apptank.horus.client.sync.network.dto.SyncDTO;
import org.apptank.horus.client.sync.network.service.ISynchronizationService;
import org.apptank.horus.client.tasks.BaseTask;
import org.apptank.horus.client.tasks.RefreshReadableEntitiesTask;
import org.apptank.horus.client.tasks.RetrieveDataSharedTask;
import org.apptank.horus.client.tasks.TaskResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/apptank/horus/client/tasks/RefreshReadableEntitiesTask;", "Lorg/apptank/horus/client/tasks/BaseTask;", "settings", "Lcom/russhwolf/settings/Settings;", "networkValidator", "Lorg/apptank/horus/client/di/INetworkValidator;", "syncService", "Lorg/apptank/horus/client/sync/network/service/ISynchronizationService;", "operationDatabaseHelper", "Lorg/apptank/horus/client/control/helper/IOperationDatabaseHelper;", "syncControlDatabaseHelper", "Lorg/apptank/horus/client/control/helper/ISyncControlDatabaseHelper;", "dependsOnTask", "Lorg/apptank/horus/client/tasks/RetrieveDataSharedTask;", "<init>", "(Lcom/russhwolf/settings/Settings;Lorg/apptank/horus/client/di/INetworkValidator;Lorg/apptank/horus/client/sync/network/service/ISynchronizationService;Lorg/apptank/horus/client/control/helper/IOperationDatabaseHelper;Lorg/apptank/horus/client/control/helper/ISyncControlDatabaseHelper;Lorg/apptank/horus/client/tasks/RetrieveDataSharedTask;)V", "execute", "Lorg/apptank/horus/client/tasks/TaskResult;", "previousDataTask", "", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastRefreshDate", "Lkotlinx/datetime/Instant;", "updateLastRefreshDate", "", "Companion", "client_release"})
@SourceDebugExtension(value={"SMAP\nRefreshReadableEntitiesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshReadableEntitiesTask.kt\norg/apptank/horus/client/tasks/RefreshReadableEntitiesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1863#2:118\n1557#2:119\n1628#2,3:120\n1368#2:123\n1454#2,5:124\n1864#2:129\n1#3:130\n*S KotlinDebug\n*F\n+ 1 RefreshReadableEntitiesTask.kt\norg/apptank/horus/client/tasks/RefreshReadableEntitiesTask\n*L\n69#1:118\n75#1:119\n75#1:120,3\n76#1:123\n76#1:124,5\n69#1:129\n*E\n"})
public final class RefreshReadableEntitiesTask
extends BaseTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final INetworkValidator networkValidator;
    @NotNull
    private final ISynchronizationService syncService;
    @NotNull
    private final IOperationDatabaseHelper operationDatabaseHelper;
    @NotNull
    private final ISyncControlDatabaseHelper syncControlDatabaseHelper;
    @NotNull
    public static final String KEY_LAST_DATE_READABLE_ENTITIES = "last_date_readable_entities";
    public static final int REFRESH_TTL = 24;

    public RefreshReadableEntitiesTask(@NotNull Settings settings, @NotNull INetworkValidator networkValidator, @NotNull ISynchronizationService syncService, @NotNull IOperationDatabaseHelper operationDatabaseHelper, @NotNull ISyncControlDatabaseHelper syncControlDatabaseHelper, @NotNull RetrieveDataSharedTask dependsOnTask) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)networkValidator, (String)"networkValidator");
        Intrinsics.checkNotNullParameter((Object)syncService, (String)"syncService");
        Intrinsics.checkNotNullParameter((Object)operationDatabaseHelper, (String)"operationDatabaseHelper");
        Intrinsics.checkNotNullParameter((Object)syncControlDatabaseHelper, (String)"syncControlDatabaseHelper");
        Intrinsics.checkNotNullParameter((Object)dependsOnTask, (String)"dependsOnTask");
        super(dependsOnTask);
        this.settings = settings;
        this.networkValidator = networkValidator;
        this.syncService = syncService;
        this.operationDatabaseHelper = operationDatabaseHelper;
        this.syncControlDatabaseHelper = syncControlDatabaseHelper;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object execute(@Nullable Object var1_1, @NotNull Continuation<? super TaskResult> var2_2) {
        if (!(var2_2 instanceof execute.1)) ** GOTO lbl-1000
        var23_3 = var2_2;
        if ((var23_3.label & -2147483648) != 0) {
            var23_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ RefreshReadableEntitiesTask this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, (Continuation<? super TaskResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.networkValidator.isNetworkAvailable()) {
                    return TaskResult.Companion.success$default(TaskResult.Companion, null, 1, null);
                }
                v0 = lastDate = this.getLastRefreshDate();
                if ((v0 != null ? InstantExtensionKt.diffInHoursFromNow$default(v0, null, 1, null) : 0x7FFFFFFF) < 24) {
                    return TaskResult.Companion.success$default(TaskResult.Companion, null, 1, null);
                }
                $this$forEach$iv = this.syncControlDatabaseHelper.getReadableEntityNames();
                $i$f$forEach = 0;
                var6_9 = $this$forEach$iv.iterator();
lbl20:
                // 2 sources

                while (var6_9.hasNext()) {
                    element$iv = var6_9.next();
                    entityName = (String)element$iv;
                    $i$a$-forEach-RefreshReadableEntitiesTask$execute$2 = 0;
                    $continuation.L$0 = this;
                    $continuation.L$1 = previousDataTask;
                    $continuation.L$2 = $completion;
                    $continuation.L$3 = lastDate;
                    $continuation.L$4 = $this$forEach$iv;
                    $continuation.L$5 = var6_9;
                    $continuation.L$6 = element$iv;
                    $continuation.L$7 = entityName;
                    $continuation.I$0 = $i$f$forEach;
                    $continuation.I$1 = $i$a$-forEach-RefreshReadableEntitiesTask$execute$2;
                    $continuation.label = 1;
                    v1 = ISynchronizationService.DefaultImpls.getDataEntity$default(this.syncService, entityName, null, null, (Continuation)$continuation, 6, null);
                    if (v1 == var24_5) {
                        return var24_5;
                    }
                    ** GOTO lbl53
                }
                break;
            }
            case 1: {
                $i$a$-forEach-RefreshReadableEntitiesTask$execute$2 = $continuation.I$1;
                $i$f$forEach = $continuation.I$0;
                entityName = (String)$continuation.L$7;
                element$iv = $continuation.L$6;
                var6_9 = (Iterator<T>)$continuation.L$5;
                $this$forEach$iv = (Iterable)$continuation.L$4;
                lastDate = (Instant)$continuation.L$3;
                $completion = (Continuation)$continuation.L$2;
                previousDataTask = $continuation.L$1;
                this = (RefreshReadableEntitiesTask)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl53:
                // 2 sources

                if (!((response = (DataResult)v1) instanceof DataResult.Success)) ** GOTO lbl84
                this.operationDatabaseHelper.truncate(entityName);
                var11_14 = (Iterable)((DataResult.Success)response).getData();
                $i$f$map = false;
                var13_16 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var18_21 = (SyncDTO.Response.Entity)item$iv$iv;
                    var19_22 = destination$iv$iv;
                    $i$a$-map-RefreshReadableEntitiesTask$execute$2$records$1 = false;
                    var19_22.add(ExtensionsKt.toEntityData$default((SyncDTO.Response.Entity)it, false, 1, null));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$flatMap = false;
                $this$mapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (Horus.Entity)element$iv$iv;
                    $i$a$-flatMap-RefreshReadableEntitiesTask$execute$2$records$2 = false;
                    list$iv$iv = DatabaseOperationKt.toRecordsInsert(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                records = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
                IOperationDatabaseHelper.DefaultImpls.insertWithTransaction$default(this.operationDatabaseHelper, records, null, 2, null);
                ** GOTO lbl20
lbl84:
                // 1 sources

                if (response instanceof DataResult.Failure || response instanceof DataResult.NotAuthorized) {
                    FunctionsKt.logException$default("Failed to retrieve data for entity: " + entityName, null, 2, null);
                    return TaskResult.Companion.success$default(TaskResult.Companion, null, 1, null);
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        this.updateLastRefreshDate();
        return TaskResult.Companion.success$default(TaskResult.Companion, null, 1, null);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Instant getLastRefreshDate() {
        Instant instant;
        Long l = this.settings.getLongOrNull(KEY_LAST_DATE_READABLE_ENTITIES);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            instant = Instant.Companion.fromEpochSeconds$default((Instant.Companion)Instant.Companion, (long)it, (long)0L, (int)2, null);
        } else {
            instant = null;
        }
        return instant;
    }

    private final void updateLastRefreshDate() {
        this.settings.putLong(KEY_LAST_DATE_READABLE_ENTITIES, Clock.System.INSTANCE.now().getEpochSeconds());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/apptank/horus/client/tasks/RefreshReadableEntitiesTask$Companion;", "", "<init>", "()V", "KEY_LAST_DATE_READABLE_ENTITIES", "", "REFRESH_TTL", "", "client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

