/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client;

import android.content.Context;
import android.content.SharedPreferences;
import com.russhwolf.settings.Settings;
import com.russhwolf.settings.SharedPreferencesSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apptank.horus.client.AndroidLogger;
import org.apptank.horus.client.DatabaseDriverFactory;
import org.apptank.horus.client.NetworkValidator;
import org.apptank.horus.client.config.HorusConfig;
import org.apptank.horus.client.di.HorusContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/apptank/horus/client/HorusConfigurator;", "", "config", "Lorg/apptank/horus/client/config/HorusConfig;", "<init>", "(Lorg/apptank/horus/client/config/HorusConfig;)V", "configure", "", "context", "Landroid/content/Context;", "client_release"})
public final class HorusConfigurator {
    @NotNull
    private final HorusConfig config;

    public HorusConfigurator(@NotNull HorusConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public final void configure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HorusContainer $this$configure_u24lambda_u240 = HorusContainer.INSTANCE;
        boolean bl = false;
        SharedPreferences sharedPreferences = context.getSharedPreferences("horus_settings", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        $this$configure_u24lambda_u240.setupSettings((Settings)new SharedPreferencesSettings(sharedPreferences, false, 2, null));
        $this$configure_u24lambda_u240.setupConfig(this.config);
        $this$configure_u24lambda_u240.setupDatabaseFactory(new DatabaseDriverFactory(context));
        $this$configure_u24lambda_u240.setupNetworkValidator(new NetworkValidator(context));
        if (this.config.isDebug()) {
            $this$configure_u24lambda_u240.setupLogger(new AndroidLogger());
        }
    }
}

