/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.database;

import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.TransactionWithoutReturn;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apptank.horus.client.control.helper.IOperationDatabaseHelper;
import org.apptank.horus.client.database.SQLiteHelper;
import org.apptank.horus.client.database.builder.QueryBuilder;
import org.apptank.horus.client.database.builder.SimpleQueryBuilder;
import org.apptank.horus.client.database.struct.Cursor;
import org.apptank.horus.client.database.struct.CursorValue;
import org.apptank.horus.client.database.struct.DatabaseOperation;
import org.apptank.horus.client.database.struct.SQL;
import org.apptank.horus.client.exception.DatabaseOperationFailureException;
import org.apptank.horus.client.extensions.DatabaseExtensionKt;
import org.apptank.horus.client.extensions.FunctionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u0011H\u0016J!\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0012\"\u00020\rH\u0017\u00a2\u0006\u0002\u0010\u0013J(\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u0011H\u0016J(\u0010\u0017\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u0011H\u0016J.\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0016J(\u0010!\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\"0\f2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u0011H\u0016J7\u0010#\u001a)\u0012%\u0012#\u0012\u0004\u0012\u00020\u0004\u0012\u0015\u0012\u0013\u0018\u00010%\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\t0(0$j\u0002`)0\f2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u0004H\u0016J\u001c\u00101\u001a\u00020\n2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001003H\u0002J2\u00104\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\f2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\nH\u0002J6\u00105\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\f2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u00068"}, d2={"Lorg/apptank/horus/client/database/OperationDatabaseHelper;", "Lorg/apptank/horus/client/database/SQLiteHelper;", "Lorg/apptank/horus/client/control/helper/IOperationDatabaseHelper;", "databaseName", "", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "<init>", "(Ljava/lang/String;Lapp/cash/sqldelight/db/SqlDriver;)V", "executeOperations", "", "actions", "", "Lorg/apptank/horus/client/database/struct/DatabaseOperation;", "postOperation", "Lkotlin/Function0;", "", "Lorg/apptank/horus/client/base/Callback;", "", "([Lorg/apptank/horus/client/database/struct/DatabaseOperation;)Z", "insertWithTransaction", "records", "Lorg/apptank/horus/client/database/struct/DatabaseOperation$InsertRecord;", "updateWithTransaction", "Lorg/apptank/horus/client/database/struct/DatabaseOperation$UpdateRecord;", "deleteRecords", "Lorg/apptank/horus/client/database/struct/DatabaseOperation$Result;", "table", "conditions", "Lorg/apptank/horus/client/database/struct/SQL$WhereCondition;", "operator", "Lorg/apptank/horus/client/database/struct/SQL$LogicOperator;", "disableForeignKeys", "deleteWithTransaction", "Lorg/apptank/horus/client/database/struct/DatabaseOperation$DeleteRecord;", "queryRecords", "", "", "Lkotlinx/serialization/Serializable;", "with", "Lorg/apptank/horus/client/serialization/AnySerializer;", "Lorg/apptank/horus/client/base/DataMap;", "builder", "Lorg/apptank/horus/client/database/builder/QueryBuilder;", "countRecords", "", "Lorg/apptank/horus/client/database/builder/SimpleQueryBuilder;", "truncate", "entity", "executeTransaction", "executeBody", "Lkotlin/Function1;", "executeDelete", "executeUpdate", "values", "Lorg/apptank/horus/client/database/struct/SQL$ColumnValue;", "client_release"})
@SourceDebugExtension(value={"SMAP\nOperationDatabaseHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperationDatabaseHelper.kt\norg/apptank/horus/client/database/OperationDatabaseHelper\n+ 2 DatabaseExtension.kt\norg/apptank/horus/client/extensions/DatabaseExtensionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n81#2,5:287\n1863#3,2:292\n1863#3,2:294\n1863#3,2:296\n1863#3,2:298\n1863#3,2:300\n*S KotlinDebug\n*F\n+ 1 OperationDatabaseHelper.kt\norg/apptank/horus/client/database/OperationDatabaseHelper\n*L\n209#1:287,5\n36#1:292,2\n94#1:294,2\n114#1:296,2\n158#1:298,2\n178#1:300,2\n*E\n"})
public final class OperationDatabaseHelper
extends SQLiteHelper
implements IOperationDatabaseHelper {
    public OperationDatabaseHelper(@NotNull String databaseName, @NotNull SqlDriver driver2) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        super(driver2, databaseName);
    }

    @Override
    public boolean executeOperations(@NotNull List<? extends DatabaseOperation> actions, @NotNull Function0<Unit> postOperation) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter(postOperation, (String)"postOperation");
        return this.executeTransaction((Function1<? super SqlDriver, Unit>)((Function1)arg_0 -> OperationDatabaseHelper.executeOperations$lambda$1(actions, postOperation, this, arg_0)));
    }

    @Override
    @Deprecated(message="Use executeOperations(actions: List<DatabaseOperation>, postOperation: Callback) instead, because not has postOperation parameter.", replaceWith=@ReplaceWith(expression="executeOperations(actions.toList(), postOperation)", imports={}))
    public boolean executeOperations(DatabaseOperation ... actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        return IOperationDatabaseHelper.DefaultImpls.executeOperations$default(this, ArraysKt.toList((Object[])actions), null, 2, null);
    }

    @Override
    public boolean insertWithTransaction(@NotNull List<DatabaseOperation.InsertRecord> records, @NotNull Function0<Unit> postOperation) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter(postOperation, (String)"postOperation");
        return this.executeTransaction((Function1<? super SqlDriver, Unit>)((Function1)arg_0 -> OperationDatabaseHelper.insertWithTransaction$lambda$3(records, postOperation, this, arg_0)));
    }

    @Override
    public boolean updateWithTransaction(@NotNull List<DatabaseOperation.UpdateRecord> records, @NotNull Function0<Unit> postOperation) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter(postOperation, (String)"postOperation");
        return this.executeTransaction((Function1<? super SqlDriver, Unit>)((Function1)arg_0 -> OperationDatabaseHelper.updateWithTransaction$lambda$5(records, postOperation, this, arg_0)));
    }

    @Override
    @NotNull
    public DatabaseOperation.Result deleteRecords(@NotNull String table, @NotNull List<SQL.WhereCondition> conditions, @NotNull SQL.LogicOperator operator, boolean disableForeignKeys) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        return this.executeDelete(table, conditions, operator, disableForeignKeys);
    }

    @Override
    public boolean deleteWithTransaction(@NotNull List<DatabaseOperation.DeleteRecord> records, @NotNull Function0<Unit> postOperation) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter(postOperation, (String)"postOperation");
        return this.executeTransaction((Function1<? super SqlDriver, Unit>)((Function1)arg_0 -> OperationDatabaseHelper.deleteWithTransaction$lambda$7(records, postOperation, this, arg_0)));
    }

    @Override
    @NotNull
    public List<Map<String, Object>> queryRecords(@NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        List output = new ArrayList();
        this.queryResult$client_release(builder.build(), arg_0 -> OperationDatabaseHelper.queryRecords$lambda$9(output, arg_0));
        return CollectionsKt.reversed((Iterable)output);
    }

    @Override
    public int countRecords(@NotNull SimpleQueryBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        SimpleQueryBuilder queryBuilder = builder.selectCount();
        Ref.IntRef count = new Ref.IntRef();
        this.rawQuery(queryBuilder.build(), arg_0 -> OperationDatabaseHelper.countRecords$lambda$10(count, arg_0));
        return count.element;
    }

    @Override
    public void truncate(@NotNull String entity) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            boolean bl = false;
            SqlDriver $this$truncate_u24lambda_u2411 = $this$handle$iv;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)this.executeDeleteWithNoForeignKeys("DELETE FROM " + entity + ';'));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl = false;
            FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
            throw it$iv;
        }
    }

    private final boolean executeTransaction(Function1<? super SqlDriver, Unit> executeBody) {
        Object object;
        Object $this$executeTransaction_u24lambda_u2413;
        Object object2 = this;
        try {
            $this$executeTransaction_u24lambda_u2413 = object2;
            boolean bl = false;
            Transacter.DefaultImpls.transaction$default((Transacter)((Transacter)$this$executeTransaction_u24lambda_u2413), (boolean)false, arg_0 -> OperationDatabaseHelper.executeTransaction$lambda$13$lambda$12(executeBody, (OperationDatabaseHelper)$this$executeTransaction_u24lambda_u2413, arg_0), (int)1, null);
            $this$executeTransaction_u24lambda_u2413 = Result.constructor-impl((Object)true);
        }
        catch (Throwable bl) {
            $this$executeTransaction_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$executeTransaction_u24lambda_u2413;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            it.printStackTrace();
            object = false;
        }
        return (Boolean)object;
    }

    private final DatabaseOperation.Result executeDelete(String table, List<SQL.WhereCondition> conditions, SQL.LogicOperator operator, boolean disableForeignKeys) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("conditions not can be empty");
        }
        String whereEvaluation = this.buildWhereEvaluation(conditions, operator);
        long result = this.delete(table, whereEvaluation, disableForeignKeys);
        return new DatabaseOperation.Result(result > 0L, (int)result, false, 4, null);
    }

    static /* synthetic */ DatabaseOperation.Result executeDelete$default(OperationDatabaseHelper operationDatabaseHelper, String string, List list, SQL.LogicOperator logicOperator, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            logicOperator = SQL.LogicOperator.AND;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return operationDatabaseHelper.executeDelete(string, list, logicOperator, bl);
    }

    private final DatabaseOperation.Result executeUpdate(String table, List<SQL.ColumnValue> values, List<SQL.WhereCondition> conditions, SQL.LogicOperator operator) {
        String whereEvaluation = this.buildWhereEvaluation(conditions, operator);
        FunctionsKt.log("[Update] table: " + table + " Values: " + values + " Conditions: " + whereEvaluation);
        long result = this.update(table, this.prepareMap(values, (Function1<? super String, String>)((Function1)OperationDatabaseHelper::executeUpdate$lambda$15)), whereEvaluation);
        return new DatabaseOperation.Result(result > 0L, (int)result, false, 4, null);
    }

    static /* synthetic */ DatabaseOperation.Result executeUpdate$default(OperationDatabaseHelper operationDatabaseHelper, String string, List list, List list2, SQL.LogicOperator logicOperator, int n, Object object) {
        if ((n & 8) != 0) {
            logicOperator = SQL.LogicOperator.AND;
        }
        return operationDatabaseHelper.executeUpdate(string, list, list2, logicOperator);
    }

    private static final Unit executeOperations$lambda$1(List $actions, Function0 $postOperation, OperationDatabaseHelper this$0, SqlDriver sqlDriver) {
        Intrinsics.checkNotNullParameter((Object)sqlDriver, (String)"<unused var>");
        Iterable $this$forEach$iv = $actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean operationIsFailure;
            boolean bl;
            DatabaseOperation action = (DatabaseOperation)element$iv;
            boolean bl2 = false;
            DatabaseOperation databaseOperation = action;
            if (databaseOperation instanceof DatabaseOperation.InsertRecord) {
                this$0.insertOrThrow(((DatabaseOperation.InsertRecord)action).getTable(), SQLiteHelper.prepareMap$default(this$0, ((DatabaseOperation.InsertRecord)action).getValues(), null, 1, null));
                bl = false;
            } else if (databaseOperation instanceof DatabaseOperation.UpdateRecord) {
                bl = this$0.executeUpdate(((DatabaseOperation.UpdateRecord)action).getTable(), ((DatabaseOperation.UpdateRecord)action).getValues(), ((DatabaseOperation.UpdateRecord)action).getConditions(), ((DatabaseOperation.UpdateRecord)action).getOperator()).isFailure();
            } else if (databaseOperation instanceof DatabaseOperation.DeleteRecord) {
                bl = OperationDatabaseHelper.executeDelete$default(this$0, ((DatabaseOperation.DeleteRecord)action).getTable(), ((DatabaseOperation.DeleteRecord)action).getConditions(), ((DatabaseOperation.DeleteRecord)action).getOperator(), false, 8, null).isFailure();
            } else {
                throw new IllegalStateException("Action not supported");
            }
            if (!(operationIsFailure = bl)) continue;
            throw new DatabaseOperationFailureException("Operation database is failed");
        }
        $postOperation.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit insertWithTransaction$lambda$3(List $records, Function0 $postOperation, OperationDatabaseHelper this$0, SqlDriver db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Iterable $this$forEach$iv = $records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseOperation.InsertRecord item = (DatabaseOperation.InsertRecord)element$iv;
            boolean bl = false;
            Map values = SQLiteHelper.prepareMap$default(this$0, item.getValues(), null, 1, null);
            FunctionsKt.log("[Insert] Table: " + item.getTable() + " Values: " + values);
            this$0.insertOrThrow(item.getTable(), values);
        }
        $postOperation.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit updateWithTransaction$lambda$5(List $records, Function0 $postOperation, OperationDatabaseHelper this$0, SqlDriver sqlDriver) {
        Intrinsics.checkNotNullParameter((Object)sqlDriver, (String)"<unused var>");
        Iterable $this$forEach$iv = $records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseOperation.UpdateRecord item = (DatabaseOperation.UpdateRecord)element$iv;
            boolean bl = false;
            if (!this$0.executeUpdate(item.getTable(), item.getValues(), item.getConditions(), item.getOperator()).isFailure()) continue;
            throw new IllegalStateException("Update records failed");
        }
        $postOperation.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit deleteWithTransaction$lambda$7(List $records, Function0 $postOperation, OperationDatabaseHelper this$0, SqlDriver sqlDriver) {
        Intrinsics.checkNotNullParameter((Object)sqlDriver, (String)"<unused var>");
        Iterable $this$forEach$iv = $records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseOperation.DeleteRecord it = (DatabaseOperation.DeleteRecord)element$iv;
            boolean bl = false;
            if (!OperationDatabaseHelper.executeDelete$default(this$0, it.getTable(), it.getConditions(), it.getOperator(), false, 8, null).isFailure()) continue;
            throw new IllegalStateException("Delete records failed");
        }
        $postOperation.invoke();
        return Unit.INSTANCE;
    }

    private static final Boolean queryRecords$lambda$9(List $output, Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = cursor.getValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CursorValue it = (CursorValue)element$iv;
            boolean bl = false;
            map.put(it.getColumn().getName(), cursor.getValue(it.getColumn().getName()));
        }
        return $output.add(map);
    }

    private static final Unit countRecords$lambda$10(Ref.IntRef $count, SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        $count.element = DatabaseExtensionKt.getRequireInt(cursor, 0);
        return Unit.INSTANCE;
    }

    private static final Unit executeTransaction$lambda$13$lambda$12(Function1 $executeBody, OperationDatabaseHelper $this_runCatching, TransactionWithoutReturn $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        $executeBody.invoke((Object)$this_runCatching.getDriver());
        return Unit.INSTANCE;
    }

    private static final String executeUpdate$lambda$15(String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return column;
    }
}

