/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.hashing;

import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.apptank.horus.client.data.Horus;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.hash.sha2.SHA256;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007J\u0014\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\f\u0010\r\u001a\u00020\u0005*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/apptank/horus/client/hashing/AttributeHasher;", "", "<init>", "()V", "generateHash", "", "attributes", "", "Lorg/apptank/horus/client/data/Horus$Attribute;", "generateHashFromList", "data", "sha256", "input", "toHex", "", "client_release"})
@SourceDebugExtension(value={"SMAP\nAttributeHasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeHasher.kt\norg/apptank/horus/client/hashing/AttributeHasher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nio/ktor/utils/io/core/StringsKt\n*L\n1#1,64:1\n1053#2:65\n774#2:66\n865#2,2:67\n1557#2:69\n1628#2,3:70\n7#3,4:73\n*S KotlinDebug\n*F\n+ 1 AttributeHasher.kt\norg/apptank/horus/client/hashing/AttributeHasher\n*L\n25#1:65\n25#1:66\n25#1:67,2\n40#1:69\n40#1:70,3\n53#1:73,4\n*E\n"})
public final class AttributeHasher {
    @NotNull
    public static final AttributeHasher INSTANCE = new AttributeHasher();

    private AttributeHasher() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateHash(@NotNull List<? extends Horus.Attribute<?>> attributes) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Iterable $this$sortedBy$iv = attributes;
        boolean $i$f$sortedBy = false;
        Iterable $this$filter$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Horus.Attribute it = (Horus.Attribute)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Horus.Attribute)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Horus.Attribute it = (Horus.Attribute)element$iv$iv;
            boolean bl = false;
            if (!(it.getValue() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String inputString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, AttributeHasher::generateHash$lambda$2, (int)30, null);
        return this.sha256(inputString);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateHashFromList(@NotNull List<String> data) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Iterable iterable = data;
        AttributeHasher attributeHasher = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Horus.Attribute<void>((String)it, it));
        }
        return attributeHasher.generateHash((List)destination$iv$iv);
    }

    private final String sha256(String input) {
        byte[] byArray;
        SHA256 sha256 = new SHA256();
        String $this$toByteArray_u24default$iv = input;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
            byArray = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
        } else {
            CharsetEncoder charsetEncoder = charset$iv.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv, (int)0, (int)$this$toByteArray_u24default$iv.length());
        }
        byte[] hashBytes = sha256.digest(byArray);
        return ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, AttributeHasher::sha256$lambda$4, (int)30, null);
    }

    private final String toHex(byte $this$toHex) {
        return StringsKt.padStart((String)UStringsKt.toString-LxnNnR4((byte)UByte.constructor-impl((byte)$this$toHex), (int)16), (int)2, (char)'0');
    }

    private static final CharSequence generateHash$lambda$2(Horus.Attribute it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.getValue());
    }

    private static final CharSequence sha256$lambda$4(byte it) {
        return INSTANCE.toHex(it);
    }
}

