/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.di;

import com.russhwolf.settings.Settings;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientJvmKt;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpTimeoutConfig;
import io.ktor.client.plugins.HttpTimeoutKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.apptank.horus.client.config.HorusConfig;
import org.apptank.horus.client.control.helper.IDataSharedDatabaseHelper;
import org.apptank.horus.client.control.helper.IOperationDatabaseHelper;
import org.apptank.horus.client.control.helper.ISyncControlDatabaseHelper;
import org.apptank.horus.client.control.helper.ISyncFileDatabaseHelper;
import org.apptank.horus.client.database.DataSharedDatabaseHelper;
import org.apptank.horus.client.database.OperationDatabaseHelper;
import org.apptank.horus.client.database.SyncControlDatabaseHelper;
import org.apptank.horus.client.database.SyncFileDatabaseHelper;
import org.apptank.horus.client.di.IDatabaseDriverFactory;
import org.apptank.horus.client.di.ILogger;
import org.apptank.horus.client.di.INetworkValidator;
import org.apptank.horus.client.migration.network.service.IMigrationService;
import org.apptank.horus.client.migration.network.service.MigrationService;
import org.apptank.horus.client.restrictions.EntityRestrictionValidator;
import org.apptank.horus.client.sync.manager.DispenserManager;
import org.apptank.horus.client.sync.manager.ISyncFileUploadedManager;
import org.apptank.horus.client.sync.manager.RemoteSynchronizatorManager;
import org.apptank.horus.client.sync.manager.SyncFileUploadedManager;
import org.apptank.horus.client.sync.network.service.FileSynchronizationService;
import org.apptank.horus.client.sync.network.service.IFileSynchronizationService;
import org.apptank.horus.client.sync.network.service.ISynchronizationService;
import org.apptank.horus.client.sync.network.service.SynchronizationService;
import org.apptank.horus.client.sync.upload.repository.IUploadFileRepository;
import org.apptank.horus.client.sync.upload.repository.UploadFileRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b4\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020%H\u0000\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020+2\u0006\u00103\u001a\u00020'H\u0000\u00a2\u0006\u0002\b6J\u0015\u00107\u001a\u00020+2\u0006\u00103\u001a\u00020)H\u0000\u00a2\u0006\u0002\b8J\u0015\u00109\u001a\u00020+2\u0006\u0010:\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b;J\u0015\u0010<\u001a\u00020+2\u0006\u0010:\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b=J\u0015\u0010>\u001a\u00020+2\u0006\u0010:\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b?J\u0015\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\bBJ\u000e\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020\tJ\u000e\u0010E\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010F\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010G\u001a\u00020+2\u0006\u0010 \u001a\u00020!J\u000e\u0010H\u001a\u00020+2\u0006\u0010\"\u001a\u00020#J\r\u0010I\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\bJJ\r\u0010K\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bLJ\r\u0010M\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bNJ\r\u0010O\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bPJ\r\u0010Q\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bRJ\r\u0010S\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bTJ\r\u0010U\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\bVJ\r\u0010W\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bXJ\r\u0010Y\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bZJ\r\u0010[\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\\J\r\u0010]\u001a\u00020!H\u0000\u00a2\u0006\u0002\b^J\r\u0010_\u001a\u00020`H\u0000\u00a2\u0006\u0002\baJ\u000f\u0010b\u001a\u0004\u0018\u00010#H\u0000\u00a2\u0006\u0002\bcJ\r\u0010d\u001a\u00020eH\u0000\u00a2\u0006\u0002\bfJ\r\u0010g\u001a\u00020%H\u0000\u00a2\u0006\u0002\bhJ\r\u0010i\u001a\u00020'H\u0000\u00a2\u0006\u0002\bjJ\r\u0010k\u001a\u00020)H\u0000\u00a2\u0006\u0002\blJ\r\u0010m\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\bnJ\r\u0010o\u001a\u00020+H\u0000\u00a2\u0006\u0002\bpR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lorg/apptank/horus/client/di/HorusContainer;", "", "<init>", "()V", "config", "Lorg/apptank/horus/client/config/HorusConfig;", "settings", "Lcom/russhwolf/settings/Settings;", "databaseFactory", "Lorg/apptank/horus/client/di/IDatabaseDriverFactory;", "httpClient", "Lio/ktor/client/HttpClient;", "getHttpClient", "()Lio/ktor/client/HttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "migrationService", "Lorg/apptank/horus/client/migration/network/service/IMigrationService;", "synchronizationService", "Lorg/apptank/horus/client/sync/network/service/ISynchronizationService;", "fileSynchronizationService", "Lorg/apptank/horus/client/sync/network/service/IFileSynchronizationService;", "syncControlDatabaseHelper", "Lorg/apptank/horus/client/control/helper/ISyncControlDatabaseHelper;", "operationDatabaseHelper", "Lorg/apptank/horus/client/control/helper/IOperationDatabaseHelper;", "dataSharedDatabaseHelper", "Lorg/apptank/horus/client/control/helper/IDataSharedDatabaseHelper;", "syncFilesDatabaseHelper", "Lorg/apptank/horus/client/control/helper/ISyncFileDatabaseHelper;", "uploadFileRepository", "Lorg/apptank/horus/client/sync/upload/repository/IUploadFileRepository;", "networkValidator", "Lorg/apptank/horus/client/di/INetworkValidator;", "logger", "Lorg/apptank/horus/client/di/ILogger;", "remoteSynchronizatorManager", "Lorg/apptank/horus/client/sync/manager/RemoteSynchronizatorManager;", "syncFileUploadedManager", "Lorg/apptank/horus/client/sync/manager/ISyncFileUploadedManager;", "dispenserManager", "Lorg/apptank/horus/client/sync/manager/DispenserManager;", "setupMigrationService", "", "service", "setupMigrationService$client_release", "setupSynchronizationService", "setupSynchronizationService$client_release", "setupFileSynchronizationService", "setupFileSynchronizationService$client_release", "setupRemoteSynchronizatorManager", "manager", "setupRemoteSynchronizatorManager$client_release", "setupSyncFileUploadedManager", "setupSyncFileUploadedManager$client_release", "setupDispenserManager", "setupDispenserManager$client_release", "setupSyncControlDatabaseHelper", "helper", "setupSyncControlDatabaseHelper$client_release", "setupOperationDatabaseHelper", "setupOperationDatabaseHelper$client_release", "setupSyncFilesDatabaseHelper", "setupSyncFilesDatabaseHelper$client_release", "setupUploadFileRepository", "repository", "setupUploadFileRepository$client_release", "setupDatabaseFactory", "factory", "setupConfig", "setupSettings", "setupNetworkValidator", "setupLogger", "getMigrationService", "getMigrationService$client_release", "getSynchronizationService", "getSynchronizationService$client_release", "getFileSynchronizationService", "getFileSynchronizationService$client_release", "getDatabaseFactory", "getDatabaseFactory$client_release", "getSettings", "getSettings$client_release", "getConfig", "getConfig$client_release", "getSyncControlDatabaseHelper", "getSyncControlDatabaseHelper$client_release", "getOperationDatabaseHelper", "getOperationDatabaseHelper$client_release", "getSyncFilesDatabaseHelper", "getSyncFilesDatabaseHelper$client_release", "getDataSharedDatabaseHelper", "getDataSharedDatabaseHelper$client_release", "getNetworkValidator", "getNetworkValidator$client_release", "getEntityRestrictionValidator", "Lorg/apptank/horus/client/restrictions/EntityRestrictionValidator;", "getEntityRestrictionValidator$client_release", "getLogger", "getLogger$client_release", "existsConfig", "", "existsConfig$client_release", "getRemoteSynchronizatorManager", "getRemoteSynchronizatorManager$client_release", "getSyncFileUploadedManager", "getSyncFileUploadedManager$client_release", "getDispenserManager", "getDispenserManager$client_release", "getUploadFileRepository", "getUploadFileRepository$client_release", "clear", "clear$client_release", "client_release"})
public final class HorusContainer {
    @NotNull
    public static final HorusContainer INSTANCE = new HorusContainer();
    @Nullable
    private static HorusConfig config;
    @Nullable
    private static Settings settings;
    @Nullable
    private static IDatabaseDriverFactory databaseFactory;
    @NotNull
    private static final Lazy httpClient$delegate;
    @Nullable
    private static IMigrationService migrationService;
    @Nullable
    private static ISynchronizationService synchronizationService;
    @Nullable
    private static IFileSynchronizationService fileSynchronizationService;
    @Nullable
    private static ISyncControlDatabaseHelper syncControlDatabaseHelper;
    @Nullable
    private static IOperationDatabaseHelper operationDatabaseHelper;
    @Nullable
    private static IDataSharedDatabaseHelper dataSharedDatabaseHelper;
    @Nullable
    private static ISyncFileDatabaseHelper syncFilesDatabaseHelper;
    @Nullable
    private static IUploadFileRepository uploadFileRepository;
    @Nullable
    private static INetworkValidator networkValidator;
    @Nullable
    private static ILogger logger;
    @Nullable
    private static RemoteSynchronizatorManager remoteSynchronizatorManager;
    @Nullable
    private static ISyncFileUploadedManager syncFileUploadedManager;
    @Nullable
    private static DispenserManager dispenserManager;

    private HorusContainer() {
    }

    private final HttpClient getHttpClient() {
        Lazy lazy = httpClient$delegate;
        return (HttpClient)lazy.getValue();
    }

    public final void setupMigrationService$client_release(@NotNull IMigrationService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        migrationService = service;
    }

    public final void setupSynchronizationService$client_release(@NotNull ISynchronizationService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        synchronizationService = service;
    }

    public final void setupFileSynchronizationService$client_release(@NotNull IFileSynchronizationService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        fileSynchronizationService = service;
    }

    public final void setupRemoteSynchronizatorManager$client_release(@NotNull RemoteSynchronizatorManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        remoteSynchronizatorManager = manager;
    }

    public final void setupSyncFileUploadedManager$client_release(@NotNull ISyncFileUploadedManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        syncFileUploadedManager = manager;
    }

    public final void setupDispenserManager$client_release(@NotNull DispenserManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        dispenserManager = manager;
    }

    public final void setupSyncControlDatabaseHelper$client_release(@NotNull ISyncControlDatabaseHelper helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        syncControlDatabaseHelper = helper;
    }

    public final void setupOperationDatabaseHelper$client_release(@NotNull IOperationDatabaseHelper helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        operationDatabaseHelper = helper;
    }

    public final void setupSyncFilesDatabaseHelper$client_release(@NotNull ISyncFileDatabaseHelper helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        syncFilesDatabaseHelper = helper;
    }

    public final void setupUploadFileRepository$client_release(@NotNull IUploadFileRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        uploadFileRepository = repository;
    }

    public final void setupDatabaseFactory(@NotNull IDatabaseDriverFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        databaseFactory = factory;
        operationDatabaseHelper = new OperationDatabaseHelper(factory.getDatabaseName(), factory.getDriver());
        syncControlDatabaseHelper = new SyncControlDatabaseHelper(factory.getDatabaseName(), factory.getDriver());
        syncFilesDatabaseHelper = new SyncFileDatabaseHelper(factory.getDatabaseName(), factory.getDriver());
        dataSharedDatabaseHelper = new DataSharedDatabaseHelper(factory.getDatabaseName(), factory.getDriver());
    }

    public final void setupConfig(@NotNull HorusConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        HorusContainer.config = config;
    }

    public final void setupSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        HorusContainer.settings = settings;
    }

    public final void setupNetworkValidator(@NotNull INetworkValidator networkValidator) {
        Intrinsics.checkNotNullParameter((Object)networkValidator, (String)"networkValidator");
        HorusContainer.networkValidator = networkValidator;
    }

    public final void setupLogger(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        HorusContainer.logger = logger;
    }

    @NotNull
    public final IMigrationService getMigrationService$client_release() {
        IMigrationService iMigrationService = migrationService;
        if (iMigrationService == null) {
            iMigrationService = new MigrationService(this.getHttpClient().getEngine(), this.getConfig$client_release().getBaseUrl(), this.getConfig$client_release().getCustomHeaders());
        }
        return iMigrationService;
    }

    @NotNull
    public final ISynchronizationService getSynchronizationService$client_release() {
        if (synchronizationService == null) {
            synchronizationService = new SynchronizationService(this.getConfig$client_release(), this.getHttpClient().getEngine(), this.getConfig$client_release().getBaseUrl(), this.getConfig$client_release().getCustomHeaders());
        }
        ISynchronizationService iSynchronizationService = synchronizationService;
        Intrinsics.checkNotNull((Object)iSynchronizationService);
        return iSynchronizationService;
    }

    @NotNull
    public final IFileSynchronizationService getFileSynchronizationService$client_release() {
        if (fileSynchronizationService == null) {
            fileSynchronizationService = new FileSynchronizationService(this.getHttpClient().getEngine(), this.getConfig$client_release().getBaseUrl(), this.getConfig$client_release().getCustomHeaders());
        }
        IFileSynchronizationService iFileSynchronizationService = fileSynchronizationService;
        Intrinsics.checkNotNull((Object)iFileSynchronizationService);
        return iFileSynchronizationService;
    }

    @NotNull
    public final IDatabaseDriverFactory getDatabaseFactory$client_release() {
        IDatabaseDriverFactory iDatabaseDriverFactory = databaseFactory;
        if (iDatabaseDriverFactory == null) {
            throw new IllegalStateException("Database factory not set");
        }
        return iDatabaseDriverFactory;
    }

    @NotNull
    public final Settings getSettings$client_release() {
        Settings settings = HorusContainer.settings;
        if (settings == null) {
            throw new IllegalStateException("Settings not set");
        }
        return settings;
    }

    @NotNull
    public final HorusConfig getConfig$client_release() {
        HorusConfig horusConfig = config;
        if (horusConfig == null) {
            throw new IllegalStateException("Config not set");
        }
        return horusConfig;
    }

    @NotNull
    public final ISyncControlDatabaseHelper getSyncControlDatabaseHelper$client_release() {
        ISyncControlDatabaseHelper iSyncControlDatabaseHelper = syncControlDatabaseHelper;
        if (iSyncControlDatabaseHelper == null) {
            throw new IllegalStateException("SyncControlDatabaseHelper not set");
        }
        return iSyncControlDatabaseHelper;
    }

    @NotNull
    public final IOperationDatabaseHelper getOperationDatabaseHelper$client_release() {
        IOperationDatabaseHelper iOperationDatabaseHelper = operationDatabaseHelper;
        if (iOperationDatabaseHelper == null) {
            throw new IllegalStateException("OperationDatabaseHelper not set");
        }
        return iOperationDatabaseHelper;
    }

    @NotNull
    public final ISyncFileDatabaseHelper getSyncFilesDatabaseHelper$client_release() {
        ISyncFileDatabaseHelper iSyncFileDatabaseHelper = syncFilesDatabaseHelper;
        if (iSyncFileDatabaseHelper == null) {
            throw new IllegalStateException("SyncFilesDatabaseHelper not set");
        }
        return iSyncFileDatabaseHelper;
    }

    @NotNull
    public final IDataSharedDatabaseHelper getDataSharedDatabaseHelper$client_release() {
        IDataSharedDatabaseHelper iDataSharedDatabaseHelper = dataSharedDatabaseHelper;
        if (iDataSharedDatabaseHelper == null) {
            throw new IllegalStateException("DataSharedDatabaseHelper not set");
        }
        return iDataSharedDatabaseHelper;
    }

    @NotNull
    public final INetworkValidator getNetworkValidator$client_release() {
        INetworkValidator iNetworkValidator = networkValidator;
        if (iNetworkValidator == null) {
            throw new IllegalStateException("NetworkValidator not set");
        }
        return iNetworkValidator;
    }

    @NotNull
    public final EntityRestrictionValidator getEntityRestrictionValidator$client_release() {
        return new EntityRestrictionValidator(this.getOperationDatabaseHelper$client_release());
    }

    @Nullable
    public final ILogger getLogger$client_release() {
        return logger;
    }

    public final boolean existsConfig$client_release() {
        return config != null;
    }

    @NotNull
    public final RemoteSynchronizatorManager getRemoteSynchronizatorManager$client_release() {
        if (remoteSynchronizatorManager == null) {
            remoteSynchronizatorManager = new RemoteSynchronizatorManager(this.getNetworkValidator$client_release(), this.getSyncControlDatabaseHelper$client_release(), this.getSynchronizationService$client_release(), this.getUploadFileRepository$client_release(), null, null, 0, 112, null);
        }
        RemoteSynchronizatorManager remoteSynchronizatorManager = HorusContainer.remoteSynchronizatorManager;
        Intrinsics.checkNotNull((Object)remoteSynchronizatorManager);
        return remoteSynchronizatorManager;
    }

    @NotNull
    public final ISyncFileUploadedManager getSyncFileUploadedManager$client_release() {
        if (syncFileUploadedManager == null) {
            syncFileUploadedManager = new SyncFileUploadedManager(this.getNetworkValidator$client_release(), this.getUploadFileRepository$client_release(), null, 4, null);
        }
        ISyncFileUploadedManager iSyncFileUploadedManager = syncFileUploadedManager;
        Intrinsics.checkNotNull((Object)iSyncFileUploadedManager);
        return iSyncFileUploadedManager;
    }

    @NotNull
    public final DispenserManager getDispenserManager$client_release() {
        if (dispenserManager == null) {
            dispenserManager = new DispenserManager(this.getConfig$client_release().getPushPendingActionsConfig().getBatchSize(), this.getConfig$client_release().getPushPendingActionsConfig().getExpirationTime(), this.getSyncControlDatabaseHelper$client_release(), this.getRemoteSynchronizatorManager$client_release());
        }
        DispenserManager dispenserManager = HorusContainer.dispenserManager;
        Intrinsics.checkNotNull((Object)dispenserManager);
        return dispenserManager;
    }

    @NotNull
    public final IUploadFileRepository getUploadFileRepository$client_release() {
        if (uploadFileRepository == null) {
            uploadFileRepository = new UploadFileRepository(this.getConfig$client_release(), this.getSyncFilesDatabaseHelper$client_release(), this.getSyncControlDatabaseHelper$client_release(), this.getOperationDatabaseHelper$client_release(), this.getFileSynchronizationService$client_release());
        }
        IUploadFileRepository iUploadFileRepository = uploadFileRepository;
        Intrinsics.checkNotNull((Object)iUploadFileRepository);
        return iUploadFileRepository;
    }

    public final void clear$client_release() {
        settings = null;
        databaseFactory = null;
        config = null;
        migrationService = null;
        synchronizationService = null;
        syncControlDatabaseHelper = null;
        operationDatabaseHelper = null;
        dataSharedDatabaseHelper = null;
        networkValidator = null;
        uploadFileRepository = null;
    }

    private static final Unit httpClient_delegate$lambda$2$lambda$1$lambda$0(HttpTimeoutConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setRequestTimeoutMillis(Long.valueOf(60000L));
        return Unit.INSTANCE;
    }

    private static final Unit httpClient_delegate$lambda$2$lambda$1(HttpClientConfig $this$HttpClient) {
        Intrinsics.checkNotNullParameter((Object)$this$HttpClient, (String)"$this$HttpClient");
        $this$HttpClient.install((HttpClientPlugin)HttpTimeoutKt.getHttpTimeout(), HorusContainer::httpClient_delegate$lambda$2$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    private static final HttpClient httpClient_delegate$lambda$2() {
        return HttpClientJvmKt.HttpClient(HorusContainer::httpClient_delegate$lambda$2$lambda$1);
    }

    static {
        httpClient$delegate = LazyKt.lazy(HorusContainer::httpClient_delegate$lambda$2);
    }
}

