/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.di;

import com.russhwolf.settings.Settings;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientJvmKt;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpTimeout;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.apptank.horus.client.config.HorusConfig;
import org.apptank.horus.client.control.ISyncControlDatabaseHelper;
import org.apptank.horus.client.control.SyncControlDatabaseHelper;
import org.apptank.horus.client.database.IOperationDatabaseHelper;
import org.apptank.horus.client.database.OperationDatabaseHelper;
import org.apptank.horus.client.di.IDatabaseDriverFactory;
import org.apptank.horus.client.di.ILogger;
import org.apptank.horus.client.di.INetworkValidator;
import org.apptank.horus.client.migration.network.service.IMigrationService;
import org.apptank.horus.client.migration.network.service.MigrationService;
import org.apptank.horus.client.sync.manager.DispenserManager;
import org.apptank.horus.client.sync.manager.RemoteSynchronizatorManager;
import org.apptank.horus.client.sync.network.service.ISynchronizationService;
import org.apptank.horus.client.sync.network.service.SynchronizationService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b-\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020!2\u0006\u0010'\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b*J\u0015\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020!2\u0006\u0010,\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b/J\u000e\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020\tJ\u000e\u00102\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u00103\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u00104\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u00105\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001bJ\r\u00106\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b7J\r\u00108\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b9J\r\u0010:\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b;J\r\u0010<\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b=J\r\u0010>\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b?J\r\u0010@\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bAJ\r\u0010B\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\bCJ\r\u0010D\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bEJ\u000f\u0010F\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\bGJ\r\u0010H\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bIJ\r\u0010J\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\bKJ\r\u0010L\u001a\u00020!H\u0000\u00a2\u0006\u0002\bMR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/apptank/horus/client/di/HorusContainer;", "", "<init>", "()V", "config", "Lorg/apptank/horus/client/config/HorusConfig;", "settings", "Lcom/russhwolf/settings/Settings;", "databaseFactory", "Lorg/apptank/horus/client/di/IDatabaseDriverFactory;", "httpClient", "Lio/ktor/client/HttpClient;", "getHttpClient", "()Lio/ktor/client/HttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "migrationService", "Lorg/apptank/horus/client/migration/network/service/IMigrationService;", "synchronizationService", "Lorg/apptank/horus/client/sync/network/service/ISynchronizationService;", "syncControlDatabaseHelper", "Lorg/apptank/horus/client/control/ISyncControlDatabaseHelper;", "operationDatabaseHelper", "Lorg/apptank/horus/client/database/IOperationDatabaseHelper;", "networkValidator", "Lorg/apptank/horus/client/di/INetworkValidator;", "logger", "Lorg/apptank/horus/client/di/ILogger;", "remoteSynchronizatorManager", "Lorg/apptank/horus/client/sync/manager/RemoteSynchronizatorManager;", "dispenserManager", "Lorg/apptank/horus/client/sync/manager/DispenserManager;", "setupMigrationService", "", "service", "setupMigrationService$client_release", "setupSynchronizationService", "setupSynchronizationService$client_release", "setupRemoteSynchronizatorManager", "manager", "setupRemoteSynchronizatorManager$client_release", "setupDispenserManager", "setupDispenserManager$client_release", "setupSyncControlDatabaseHelper", "helper", "setupSyncControlDatabaseHelper$client_release", "setupOperationDatabaseHelper", "setupOperationDatabaseHelper$client_release", "setupDatabaseFactory", "factory", "setupConfig", "setupSettings", "setupNetworkValidator", "setupLogger", "getMigrationService", "getMigrationService$client_release", "getSynchronizationService", "getSynchronizationService$client_release", "getDatabaseFactory", "getDatabaseFactory$client_release", "getSettings", "getSettings$client_release", "getConfig", "getConfig$client_release", "getSyncControlDatabaseHelper", "getSyncControlDatabaseHelper$client_release", "getOperationDatabaseHelper", "getOperationDatabaseHelper$client_release", "getNetworkValidator", "getNetworkValidator$client_release", "getLogger", "getLogger$client_release", "getRemoteSynchronizatorManager", "getRemoteSynchronizatorManager$client_release", "getDispenserManager", "getDispenserManager$client_release", "clear", "clear$client_release", "client_release"})
public final class HorusContainer {
    @NotNull
    public static final HorusContainer INSTANCE = new HorusContainer();
    @Nullable
    private static HorusConfig config;
    @Nullable
    private static Settings settings;
    @Nullable
    private static IDatabaseDriverFactory databaseFactory;
    @NotNull
    private static final Lazy httpClient$delegate;
    @Nullable
    private static IMigrationService migrationService;
    @Nullable
    private static ISynchronizationService synchronizationService;
    @Nullable
    private static ISyncControlDatabaseHelper syncControlDatabaseHelper;
    @Nullable
    private static IOperationDatabaseHelper operationDatabaseHelper;
    @Nullable
    private static INetworkValidator networkValidator;
    @Nullable
    private static ILogger logger;
    @Nullable
    private static RemoteSynchronizatorManager remoteSynchronizatorManager;
    @Nullable
    private static DispenserManager dispenserManager;

    private HorusContainer() {
    }

    private final HttpClient getHttpClient() {
        Lazy lazy = httpClient$delegate;
        return (HttpClient)lazy.getValue();
    }

    public final void setupMigrationService$client_release(@NotNull IMigrationService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        migrationService = service;
    }

    public final void setupSynchronizationService$client_release(@NotNull ISynchronizationService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        synchronizationService = service;
    }

    public final void setupRemoteSynchronizatorManager$client_release(@NotNull RemoteSynchronizatorManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        remoteSynchronizatorManager = manager;
    }

    public final void setupDispenserManager$client_release(@NotNull DispenserManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        dispenserManager = manager;
    }

    public final void setupSyncControlDatabaseHelper$client_release(@NotNull ISyncControlDatabaseHelper helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        syncControlDatabaseHelper = helper;
    }

    public final void setupOperationDatabaseHelper$client_release(@NotNull IOperationDatabaseHelper helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        operationDatabaseHelper = helper;
    }

    public final void setupDatabaseFactory(@NotNull IDatabaseDriverFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        databaseFactory = factory;
        operationDatabaseHelper = new OperationDatabaseHelper(factory.getDatabaseName(), factory.getDriver());
        syncControlDatabaseHelper = new SyncControlDatabaseHelper(factory.getDatabaseName(), factory.getDriver());
    }

    public final void setupConfig(@NotNull HorusConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        HorusContainer.config = config;
    }

    public final void setupSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        HorusContainer.settings = settings;
    }

    public final void setupNetworkValidator(@NotNull INetworkValidator networkValidator) {
        Intrinsics.checkNotNullParameter((Object)networkValidator, (String)"networkValidator");
        HorusContainer.networkValidator = networkValidator;
    }

    public final void setupLogger(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        HorusContainer.logger = logger;
    }

    @NotNull
    public final IMigrationService getMigrationService$client_release() {
        IMigrationService iMigrationService = migrationService;
        if (iMigrationService == null) {
            iMigrationService = new MigrationService(this.getHttpClient().getEngine(), this.getConfig$client_release().getBaseUrl());
        }
        return iMigrationService;
    }

    @NotNull
    public final ISynchronizationService getSynchronizationService$client_release() {
        if (synchronizationService == null) {
            synchronizationService = new SynchronizationService(this.getHttpClient().getEngine(), this.getConfig$client_release().getBaseUrl());
        }
        ISynchronizationService iSynchronizationService = synchronizationService;
        Intrinsics.checkNotNull((Object)iSynchronizationService);
        return iSynchronizationService;
    }

    @NotNull
    public final IDatabaseDriverFactory getDatabaseFactory$client_release() {
        IDatabaseDriverFactory iDatabaseDriverFactory = databaseFactory;
        if (iDatabaseDriverFactory == null) {
            throw new IllegalStateException("Database factory not set");
        }
        return iDatabaseDriverFactory;
    }

    @NotNull
    public final Settings getSettings$client_release() {
        Settings settings = HorusContainer.settings;
        if (settings == null) {
            throw new IllegalStateException("Settings not set");
        }
        return settings;
    }

    @NotNull
    public final HorusConfig getConfig$client_release() {
        HorusConfig horusConfig = config;
        if (horusConfig == null) {
            throw new IllegalStateException("Config not set");
        }
        return horusConfig;
    }

    @NotNull
    public final ISyncControlDatabaseHelper getSyncControlDatabaseHelper$client_release() {
        ISyncControlDatabaseHelper iSyncControlDatabaseHelper = syncControlDatabaseHelper;
        if (iSyncControlDatabaseHelper == null) {
            throw new IllegalStateException("SyncControlDatabaseHelper not set");
        }
        return iSyncControlDatabaseHelper;
    }

    @NotNull
    public final IOperationDatabaseHelper getOperationDatabaseHelper$client_release() {
        IOperationDatabaseHelper iOperationDatabaseHelper = operationDatabaseHelper;
        if (iOperationDatabaseHelper == null) {
            throw new IllegalStateException("OperationDatabaseHelper not set");
        }
        return iOperationDatabaseHelper;
    }

    @NotNull
    public final INetworkValidator getNetworkValidator$client_release() {
        INetworkValidator iNetworkValidator = networkValidator;
        if (iNetworkValidator == null) {
            throw new IllegalStateException("NetworkValidator not set");
        }
        return iNetworkValidator;
    }

    @Nullable
    public final ILogger getLogger$client_release() {
        return logger;
    }

    @NotNull
    public final RemoteSynchronizatorManager getRemoteSynchronizatorManager$client_release() {
        if (remoteSynchronizatorManager == null) {
            remoteSynchronizatorManager = new RemoteSynchronizatorManager(this.getNetworkValidator$client_release(), this.getSyncControlDatabaseHelper$client_release(), this.getSynchronizationService$client_release(), null, null, 0, 56, null);
        }
        RemoteSynchronizatorManager remoteSynchronizatorManager = HorusContainer.remoteSynchronizatorManager;
        Intrinsics.checkNotNull((Object)remoteSynchronizatorManager);
        return remoteSynchronizatorManager;
    }

    @NotNull
    public final DispenserManager getDispenserManager$client_release() {
        if (dispenserManager == null) {
            dispenserManager = new DispenserManager(this.getConfig$client_release().getPushPendingActionsConfig().getBatchSize(), this.getConfig$client_release().getPushPendingActionsConfig().getExpirationTime(), this.getSyncControlDatabaseHelper$client_release(), this.getRemoteSynchronizatorManager$client_release());
        }
        DispenserManager dispenserManager = HorusContainer.dispenserManager;
        Intrinsics.checkNotNull((Object)dispenserManager);
        return dispenserManager;
    }

    public final void clear$client_release() {
        settings = null;
        databaseFactory = null;
        config = null;
        migrationService = null;
        synchronizationService = null;
        syncControlDatabaseHelper = null;
        operationDatabaseHelper = null;
        networkValidator = null;
    }

    private static final Unit httpClient_delegate$lambda$2$lambda$1$lambda$0(HttpTimeout.HttpTimeoutCapabilityConfiguration $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setRequestTimeoutMillis(Long.valueOf(60000L));
        return Unit.INSTANCE;
    }

    private static final Unit httpClient_delegate$lambda$2$lambda$1(HttpClientConfig $this$HttpClient) {
        Intrinsics.checkNotNullParameter((Object)$this$HttpClient, (String)"$this$HttpClient");
        $this$HttpClient.install((HttpClientPlugin)HttpTimeout.Plugin, HorusContainer::httpClient_delegate$lambda$2$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    private static final HttpClient httpClient_delegate$lambda$2() {
        return HttpClientJvmKt.HttpClient(HorusContainer::httpClient_delegate$lambda$2$lambda$1);
    }

    static {
        httpClient$delegate = LazyKt.lazy(HorusContainer::httpClient_delegate$lambda$2);
    }
}

