/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.sync.manager;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.apptank.horus.client.control.ISyncControlDatabaseHelper;
import org.apptank.horus.client.control.SyncControl;
import org.apptank.horus.client.extensions.FunctionsKt;
import org.apptank.horus.client.sync.manager.RemoteSynchronizatorManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/apptank/horus/client/sync/manager/DispenserManager;", "", "batchSize", "", "expirationTime", "", "syncControlDatabaseHelper", "Lorg/apptank/horus/client/control/ISyncControlDatabaseHelper;", "remoteSynchronizatorManager", "Lorg/apptank/horus/client/sync/manager/RemoteSynchronizatorManager;", "<init>", "(IJLorg/apptank/horus/client/control/ISyncControlDatabaseHelper;Lorg/apptank/horus/client/sync/manager/RemoteSynchronizatorManager;)V", "batchCounter", "processBatch", "", "client_release"})
public final class DispenserManager {
    private final int batchSize;
    private final long expirationTime;
    @NotNull
    private final ISyncControlDatabaseHelper syncControlDatabaseHelper;
    @NotNull
    private final RemoteSynchronizatorManager remoteSynchronizatorManager;
    private int batchCounter;

    public DispenserManager(int batchSize, long expirationTime, @NotNull ISyncControlDatabaseHelper syncControlDatabaseHelper, @NotNull RemoteSynchronizatorManager remoteSynchronizatorManager) {
        Intrinsics.checkNotNullParameter((Object)syncControlDatabaseHelper, (String)"syncControlDatabaseHelper");
        Intrinsics.checkNotNullParameter((Object)remoteSynchronizatorManager, (String)"remoteSynchronizatorManager");
        this.batchSize = batchSize;
        this.expirationTime = expirationTime;
        this.syncControlDatabaseHelper = syncControlDatabaseHelper;
        this.remoteSynchronizatorManager = remoteSynchronizatorManager;
    }

    public final void processBatch() {
        boolean mustSynchronizeByTime;
        int n = this.batchCounter;
        this.batchCounter = n + 1;
        long currentTimestamp = Clock.System.INSTANCE.now().getEpochSeconds();
        SyncControl.Action action = this.syncControlDatabaseHelper.getLastActionCompleted();
        long lastActionCompletedTimestamp = action != null && (action = action.getActionedAt()) != null && (action = TimeZoneKt.toInstant((LocalDateTime)action, (TimeZone)((TimeZone)TimeZone.Companion.getUTC()))) != null ? action.getEpochSeconds() : 0L;
        boolean mustSynchronizeByBatch = this.batchCounter >= this.batchSize && this.syncControlDatabaseHelper.getPendingActions().size() >= this.batchSize;
        boolean bl = mustSynchronizeByTime = currentTimestamp - lastActionCompletedTimestamp >= this.expirationTime && lastActionCompletedTimestamp > 0L;
        if (mustSynchronizeByBatch) {
            FunctionsKt.info("[DispenserManager] Batch size reached");
        }
        if (mustSynchronizeByTime) {
            FunctionsKt.info("[DispenserManager] Expiration time reached");
        }
        if (mustSynchronizeByBatch || mustSynchronizeByTime) {
            FunctionsKt.info("Pushing pending actions to server...");
            this.remoteSynchronizatorManager.trySynchronizeData();
            this.batchCounter = 0;
        }
    }
}

