/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.sync.upload.repository;

import io.matthewnelson.kmp.file.KmpFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apptank.horus.client.base.DataResult;
import org.apptank.horus.client.base.DataResultKt;
import org.apptank.horus.client.config.HorusConfig;
import org.apptank.horus.client.control.SyncControl;
import org.apptank.horus.client.control.helper.IOperationDatabaseHelper;
import org.apptank.horus.client.control.helper.ISyncControlDatabaseHelper;
import org.apptank.horus.client.control.helper.ISyncFileDatabaseHelper;
import org.apptank.horus.client.data.Horus;
import org.apptank.horus.client.database.builder.SimpleQueryBuilder;
import org.apptank.horus.client.eventbus.EventBus;
import org.apptank.horus.client.eventbus.EventType;
import org.apptank.horus.client.exception.FileMimeTypeNotAllowedException;
import org.apptank.horus.client.exception.FileSizeExceededException;
import org.apptank.horus.client.extensions.FunctionsKt;
import org.apptank.horus.client.extensions.StringExtensionsKt;
import org.apptank.horus.client.migration.domain.AttributeType;
import org.apptank.horus.client.sync.network.dto.SyncDTO;
import org.apptank.horus.client.sync.network.service.IFileSynchronizationService;
import org.apptank.horus.client.sync.upload.data.FileData;
import org.apptank.horus.client.sync.upload.data.FileMimeType;
import org.apptank.horus.client.sync.upload.data.FileUploaded;
import org.apptank.horus.client.sync.upload.data.SyncFileResult;
import org.apptank.horus.client.sync.upload.data.SyncFileStatus;
import org.apptank.horus.client.sync.upload.repository.IUploadFileRepository;
import org.apptank.horus.client.sync.upload.repository.UploadFileRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001f\u001a\u00020 *\u00020!H\u0002J$\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\n\u0010&\u001a\u00060'j\u0002`(H\u0002J\f\u0010)\u001a\u00060'j\u0002`(H\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010\u0011*\u00020,H\u0002J\f\u0010-\u001a\u00020.*\u00020\u001dH\u0002J\u0014\u0010/\u001a\u000200*\u00020\u001d2\u0006\u00101\u001a\u000202H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/apptank/horus/client/sync/upload/repository/UploadFileRepository;", "Lorg/apptank/horus/client/sync/upload/repository/IUploadFileRepository;", "config", "Lorg/apptank/horus/client/config/HorusConfig;", "fileDatabaseHelper", "Lorg/apptank/horus/client/control/helper/ISyncFileDatabaseHelper;", "controlDatabaseHelper", "Lorg/apptank/horus/client/control/helper/ISyncControlDatabaseHelper;", "operationDatabaseHelper", "Lorg/apptank/horus/client/control/helper/IOperationDatabaseHelper;", "service", "Lorg/apptank/horus/client/sync/network/service/IFileSynchronizationService;", "<init>", "(Lorg/apptank/horus/client/config/HorusConfig;Lorg/apptank/horus/client/control/helper/ISyncFileDatabaseHelper;Lorg/apptank/horus/client/control/helper/ISyncControlDatabaseHelper;Lorg/apptank/horus/client/control/helper/IOperationDatabaseHelper;Lorg/apptank/horus/client/sync/network/service/IFileSynchronizationService;)V", "createFileLocal", "Lorg/apptank/horus/client/data/Horus$FileReference;", "fileData", "Lorg/apptank/horus/client/sync/upload/data/FileData;", "hasFilesToUpload", "", "uploadFiles", "", "Lorg/apptank/horus/client/sync/upload/data/SyncFileResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "syncFileReferencesInfo", "downloadRemoteFiles", "getFileUrl", "", "reference", "", "getFileUrlLocal", "toDomain", "Lorg/apptank/horus/client/sync/upload/data/FileUploaded;", "Lorg/apptank/horus/client/sync/network/dto/SyncDTO$Response$FileInfoUploaded;", "createFileInLocalStorage", "data", "", "filename", "path", "Ljava/io/File;", "Lio/matthewnelson/kmp/file/File;", "getBasePathFile", "normalizePath", "createFileData", "Lorg/apptank/horus/client/control/SyncControl$File;", "toSuccess", "Lorg/apptank/horus/client/sync/upload/data/SyncFileResult$Success;", "toFailure", "Lorg/apptank/horus/client/sync/upload/data/SyncFileResult$Failure;", "e", "", "Companion", "client_release"})
@SourceDebugExtension(value={"SMAP\nUploadFileRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadFileRepository.kt\norg/apptank/horus/client/sync/upload/repository/UploadFileRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,386:1\n1863#2,2:387\n1863#2:389\n1863#2:392\n1863#2:393\n1864#2:395\n1864#2:396\n1864#2:397\n774#2:398\n865#2:399\n2632#2,3:400\n866#2:403\n1863#2,2:404\n37#3,2:390\n1#4:394\n*S KotlinDebug\n*F\n+ 1 UploadFileRepository.kt\norg/apptank/horus/client/sync/upload/repository/UploadFileRepository\n*L\n115#1:387,2\n164#1:389\n171#1:392\n172#1:393\n172#1:395\n171#1:396\n164#1:397\n180#1:398\n180#1:399\n180#1:400,3\n180#1:403\n226#1:404,2\n169#1:390,2\n*E\n"})
public final class UploadFileRepository
implements IUploadFileRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HorusConfig config;
    @NotNull
    private final ISyncFileDatabaseHelper fileDatabaseHelper;
    @NotNull
    private final ISyncControlDatabaseHelper controlDatabaseHelper;
    @NotNull
    private final IOperationDatabaseHelper operationDatabaseHelper;
    @NotNull
    private final IFileSynchronizationService service;
    @NotNull
    private static final String HORUS_PATH_FILES = "horus/sync/files/";

    public UploadFileRepository(@NotNull HorusConfig config, @NotNull ISyncFileDatabaseHelper fileDatabaseHelper, @NotNull ISyncControlDatabaseHelper controlDatabaseHelper, @NotNull IOperationDatabaseHelper operationDatabaseHelper, @NotNull IFileSynchronizationService service) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)fileDatabaseHelper, (String)"fileDatabaseHelper");
        Intrinsics.checkNotNullParameter((Object)controlDatabaseHelper, (String)"controlDatabaseHelper");
        Intrinsics.checkNotNullParameter((Object)operationDatabaseHelper, (String)"operationDatabaseHelper");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.config = config;
        this.fileDatabaseHelper = fileDatabaseHelper;
        this.controlDatabaseHelper = controlDatabaseHelper;
        this.operationDatabaseHelper = operationDatabaseHelper;
        this.service = service;
    }

    @Override
    @NotNull
    public Horus.FileReference createFileLocal(@NotNull FileData fileData) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        FileMimeType it = fileData.getMimeType();
        boolean bl = false;
        if (!this.config.getUploadFilesConfig().getMimeTypesAllowed().contains((Object)it)) {
            throw new FileMimeTypeNotAllowedException(it);
        }
        if (fileData.getData().length > this.config.getUploadFilesConfig().getMaxFileSize()) {
            throw new FileSizeExceededException(this.config.getUploadFilesConfig().getMaxFileSize());
        }
        Horus.FileReference fileReference = new Horus.FileReference(null, 0, 3, null);
        SyncControl.FileType type = fileData.isImage() ? SyncControl.FileType.IMAGE : SyncControl.FileType.FILE;
        File basePathFile = this.getBasePathFile();
        String filename = fileReference + '.' + fileData.getExtension();
        String urlLocal = this.createFileInLocalStorage(fileData.getData(), filename, basePathFile);
        SyncControl.File[] fileArray = new SyncControl.File[]{new SyncControl.File(fileReference.toString(), type, SyncControl.FileStatus.LOCAL, fileData.getMimeType(), urlLocal, null, 32, null)};
        this.fileDatabaseHelper.insert(fileArray);
        EventBus.emit$default(EventBus.INSTANCE, EventType.FILE_QUEUED_FOR_UPLOAD, null, 2, null);
        return fileReference;
    }

    @Override
    public boolean hasFilesToUpload() {
        return !((Collection)this.fileDatabaseHelper.queryByStatus(SyncControl.FileStatus.LOCAL)).isEmpty();
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object uploadFiles(@NotNull Continuation<? super List<? extends SyncFileResult>> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 6[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object syncFileReferencesInfo(@NotNull Continuation<? super Boolean> var1_1) {
        if (!(var1_1 instanceof syncFileReferencesInfo.1)) ** GOTO lbl-1000
        var27_2 = var1_1;
        if ((var27_2.label & -2147483648) != 0) {
            var27_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ UploadFileRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.syncFileReferencesInfo((Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var28_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                entitiesWithRefFile = this.controlDatabaseHelper.getEntitiesWithAttributeType(AttributeType.RefFile);
                fileReferencesFound = new ArrayList<E>();
                $this$forEach$iv = entitiesWithRefFile;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    entity = (String)element$iv;
                    $i$a$-forEach-UploadFileRepository$syncFileReferencesInfo$2 = false;
                    attributesWithRefFile = this.controlDatabaseHelper.getEntityAttributesWithType((String)entity, AttributeType.RefFile);
                    $this$toTypedArray$iv = attributesWithRefFile;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    var14_28 = thisCollection$iv.toArray(new String[0]);
                    queryBuilder = new SimpleQueryBuilder((String)entity).select(Arrays.copyOf(var14_28, var14_28.length));
                    $this$forEach$iv = this.operationDatabaseHelper.queryRecords(queryBuilder);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        item = (Map)element$iv;
                        $i$a$-forEach-UploadFileRepository$syncFileReferencesInfo$2$1 = false;
                        $this$forEach$iv = attributesWithRefFile;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            attribute = (String)element$iv;
                            $i$a$-forEach-UploadFileRepository$syncFileReferencesInfo$2$1$1 = false;
                            if (item.get(attribute) == null) continue;
                            $i$a$-let-UploadFileRepository$syncFileReferencesInfo$2$1$1$1 = false;
                            Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.String");
                            fileReferencesFound.add((String)it);
                        }
                    }
                }
                fileReferencesInDatabase = this.fileDatabaseHelper.searchBatch(fileReferencesFound);
                $this$filter$iv = fileReferencesFound;
                $i$f$filter = false;
                entity = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var11_24 = $this$filterTo$iv$iv.iterator();
                while (var11_24.hasNext()) {
                    element$iv$iv = var11_24.next();
                    it = (String)element$iv$iv;
                    $i$a$-filter-UploadFileRepository$syncFileReferencesInfo$fileReferencesInRemote$1 = false;
                    $this$none$iv = fileReferencesInDatabase;
                    $i$f$none = false;
                    if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl59
                    v0 = true;
                    ** GOTO lbl67
lbl59:
                    // 2 sources

                    for (T element$iv : $this$none$iv) {
                        file = (SyncControl.File)element$iv;
                        $i$a$-none-UploadFileRepository$syncFileReferencesInfo$fileReferencesInRemote$1$1 = false;
                        if (!Intrinsics.areEqual((Object)file.getReference(), (Object)it)) continue;
                        v0 = false;
                        ** GOTO lbl67
                    }
                    v0 = true;
lbl67:
                    // 3 sources

                    if (!v0) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                fileReferencesInRemote = (List)destination$iv$iv;
                isSuccessful = new Ref.BooleanRef();
                if (fileReferencesInRemote.isEmpty()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = $completion;
                $continuation.L$2 = entitiesWithRefFile;
                $continuation.L$3 = fileReferencesFound;
                $continuation.L$4 = fileReferencesInDatabase;
                $continuation.L$5 = fileReferencesInRemote;
                $continuation.L$6 = isSuccessful;
                $continuation.L$7 = var8_17;
                $continuation.L$8 = var9_19;
                $continuation.L$9 = var11_24;
                $continuation.I$0 = var7_16;
                $continuation.I$1 = var10_21;
                $continuation.label = 1;
                v1 = this.service.getFilesInfo(new SyncDTO.Request.FilesInfoRequest(fileReferencesInRemote), (Continuation<? super DataResult<? extends List<SyncDTO.Response.FileInfoUploaded>>>)$continuation);
                if (v1 == var28_4) {
                    return var28_4;
                }
                ** GOTO lbl107
            }
            case 1: {
                var10_21 = $continuation.I$1;
                var7_16 = $continuation.I$0;
                var11_24 = (Iterator<T>)$continuation.L$9;
                var9_19 = (Collection)$continuation.L$8;
                var8_17 = (Iterable)$continuation.L$7;
                isSuccessful = (Ref.BooleanRef)$continuation.L$6;
                fileReferencesInRemote = (List)$continuation.L$5;
                fileReferencesInDatabase = (List)$continuation.L$4;
                fileReferencesFound = (List)$continuation.L$3;
                entitiesWithRefFile = (List)$continuation.L$2;
                $completion = (Continuation)$continuation.L$1;
                this = (UploadFileRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl107:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = $completion;
                $continuation.L$2 = entitiesWithRefFile;
                $continuation.L$3 = fileReferencesFound;
                $continuation.L$4 = fileReferencesInDatabase;
                $continuation.L$5 = fileReferencesInRemote;
                $continuation.L$6 = isSuccessful;
                $continuation.L$7 = var8_17;
                $continuation.L$8 = var9_19;
                $continuation.L$9 = var11_24;
                $continuation.I$0 = var7_16;
                $continuation.I$1 = var10_21;
                $continuation.label = 2;
                v2 = DataResultKt.coFold$default((DataResult)v1, (Function2)new Function2<List<? extends SyncDTO.Response.FileInfoUploaded>, Continuation<? super Unit>, Object>(this, isSuccessful, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ UploadFileRepository this$0;
                    final /* synthetic */ Ref.BooleanRef $isSuccessful;
                    {
                        this.this$0 = $receiver;
                        this.$isSuccessful = $isSuccessful;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object $this$invokeSuspend_u24lambda_u241;
                                ResultKt.throwOnFailure((Object)object);
                                List response = (List)this.L$0;
                                Object object2 = this.this$0;
                                Ref.BooleanRef booleanRef = this.$isSuccessful;
                                try {
                                    $this$invokeSuspend_u24lambda_u241 = object2;
                                    boolean bl = false;
                                    Iterable $this$forEach$iv = response;
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        SyncDTO.Response.FileInfoUploaded item = (SyncDTO.Response.FileInfoUploaded)element$iv;
                                        boolean bl2 = false;
                                        FileUploaded file = UploadFileRepository.access$toDomain((UploadFileRepository)$this$invokeSuspend_u24lambda_u241, item);
                                        SyncControl.File[] fileArray = new SyncControl.File[]{new SyncControl.File(file.getId(), file.isImage() ? SyncControl.FileType.IMAGE : SyncControl.FileType.FILE, SyncControl.FileStatus.REMOTE, file.getMimeType(), null, file.getUrl(), 16, null)};
                                        UploadFileRepository.access$getFileDatabaseHelper$p((UploadFileRepository)$this$invokeSuspend_u24lambda_u241).insert(fileArray);
                                    }
                                    booleanRef.element = true;
                                    $this$invokeSuspend_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (Throwable throwable) {
                                    $this$invokeSuspend_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                }
                                object2 = $this$invokeSuspend_u24lambda_u241;
                                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                                if (throwable != null) {
                                    Throwable e = throwable;
                                    boolean bl = false;
                                    FunctionsKt.logException("[syncFileReferences] Error inserting file references", e);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<List<? extends SyncDTO.Response.FileInfoUploaded>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(List<SyncDTO.Response.FileInfoUploaded> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Function2)new Function2<Throwable, Continuation<? super Unit>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Throwable e = (Throwable)this.L$0;
                                FunctionsKt.logException("[syncFileReferences] Error getting file references status", e);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<Throwable, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(Throwable p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, null, (Continuation)$continuation, 4, null);
                if (v2 == var28_4) {
                    return var28_4;
                }
                ** GOTO lbl144
            }
            case 2: {
                $continuation.I$1;
                $continuation.I$0;
                (Iterator)$continuation.L$9;
                (Collection)$continuation.L$8;
                (Iterable)$continuation.L$7;
                isSuccessful = (Ref.BooleanRef)$continuation.L$6;
                fileReferencesInRemote = (List)$continuation.L$5;
                fileReferencesInDatabase = (List)$continuation.L$4;
                fileReferencesFound = (List)$continuation.L$3;
                entitiesWithRefFile = (List)$continuation.L$2;
                $completion = (Continuation)$continuation.L$1;
                this = (UploadFileRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl144:
                // 2 sources

                return Boxing.boxBoolean((boolean)isSuccessful.element);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object downloadRemoteFiles(@NotNull Continuation<? super List<? extends SyncFileResult>> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 6[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Nullable
    public String getFileUrl(@NotNull CharSequence reference) {
        String string;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        SyncControl.File file = this.fileDatabaseHelper.search(reference);
        if (file == null) {
            return null;
        }
        SyncControl.File file2 = file;
        switch (WhenMappings.$EnumSwitchMapping$0[file2.getStatus().ordinal()]) {
            case 1: {
                string = file2.getUrlLocal();
                break;
            }
            case 2: {
                string = file2.getUrlRemote();
                break;
            }
            case 3: {
                string = file2.getUrlLocal();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @Nullable
    public String getFileUrlLocal(@NotNull CharSequence reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        SyncControl.File file = this.fileDatabaseHelper.search(reference);
        return file != null ? file.getUrlLocal() : null;
    }

    private final FileUploaded toDomain(SyncDTO.Response.FileInfoUploaded $this$toDomain) {
        String string = $this$toDomain.getId();
        if (string == null) {
            throw new IllegalStateException("Id is null");
        }
        String string2 = $this$toDomain.getUrl();
        if (string2 == null) {
            throw new IllegalStateException("Url is null");
        }
        Integer n = $this$toDomain.getStatus();
        if (n == null) {
            throw new IllegalStateException("Status is null");
        }
        String string3 = $this$toDomain.getMimeType();
        if (string3 == null) {
            throw new IllegalStateException("MimeType is null");
        }
        return new FileUploaded(string, string2, SyncFileStatus.Companion.fromId(n), string3);
    }

    private final String createFileInLocalStorage(byte[] data, String filename, File path) {
        File file = KmpFile.resolve((File)path, (String)filename);
        KmpFile.writeBytesTo((File)file, (byte[])data);
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return StringExtensionsKt.toFileUri(string);
    }

    private final File getBasePathFile() {
        File basePath = new File(this.normalizePath(this.config.getUploadFilesConfig().getBaseStoragePath() + HORUS_PATH_FILES));
        if (!basePath.exists()) {
            basePath.mkdirs();
        }
        return basePath;
    }

    private final String normalizePath(String path) {
        return StringsKt.replace$default((String)path, (String)"/", (String)String.valueOf(KmpFile.SysDirSep), (boolean)false, (int)4, null);
    }

    private final FileData createFileData(SyncControl.File $this$createFileData) {
        String string = $this$createFileData.getUrlLocal();
        if (string == null || (string = StringExtensionsKt.toPath(string)) == null) {
            return null;
        }
        String absolutePathFile = string;
        File file = new File(absolutePathFile);
        String filename = StringsKt.substringAfterLast$default((String)absolutePathFile, (String)"/", null, (int)2, null);
        return new FileData(KmpFile.readBytesFrom((File)file), filename, $this$createFileData.getMimeType());
    }

    private final SyncFileResult.Success toSuccess(CharSequence $this$toSuccess) {
        return new SyncFileResult.Success(new Horus.FileReference($this$toSuccess, 0, 2, null));
    }

    private final SyncFileResult.Failure toFailure(CharSequence $this$toFailure, Throwable e) {
        return new SyncFileResult.Failure(new Horus.FileReference($this$toFailure, 0, 2, null), e);
    }

    public static final /* synthetic */ FileUploaded access$toDomain(UploadFileRepository $this, SyncDTO.Response.FileInfoUploaded $receiver) {
        return $this.toDomain($receiver);
    }

    public static final /* synthetic */ ISyncFileDatabaseHelper access$getFileDatabaseHelper$p(UploadFileRepository $this) {
        return $this.fileDatabaseHelper;
    }

    public static final /* synthetic */ SyncFileResult.Success access$toSuccess(UploadFileRepository $this, CharSequence $receiver) {
        return $this.toSuccess($receiver);
    }

    public static final /* synthetic */ SyncFileResult.Failure access$toFailure(UploadFileRepository $this, CharSequence $receiver, Throwable e) {
        return $this.toFailure($receiver, e);
    }

    public static final /* synthetic */ String access$createFileInLocalStorage(UploadFileRepository $this, byte[] data, String filename, File path) {
        return $this.createFileInLocalStorage(data, filename, path);
    }

    public static final /* synthetic */ File access$getBasePathFile(UploadFileRepository $this) {
        return $this.getBasePathFile();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apptank/horus/client/sync/upload/repository/UploadFileRepository$Companion;", "", "<init>", "()V", "HORUS_PATH_FILES", "", "client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyncControl.FileStatus.values().length];
            try {
                nArray[SyncControl.FileStatus.LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncControl.FileStatus.REMOTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncControl.FileStatus.SYNCED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

