package org.apptank.horus.client.sync.upload.data

/**
 * Represents a file data object containing the file data, filename, and MIME type.
 *
 * @property data The byte array representing the file data.
 * @property filename The name of the file.
 * @property mimeType The MIME type of the file.
 */
enum class FileMimeType(val type: String, val extension: String) {
    APP_ANDREW_INSET("application/applixware", "aw"),
    APP_ATOM_XML("application/atom+xml", "atom"),
    APP_ATOMCAT_XML("application/atomcat+xml", "atomcat"),
    APP_ATOMSVC_XML("application/atomsvc+xml", "atomsvc"),
    APP_CCXML_XML("application/ccxml+xml", "ccxml"),
    APP_CDMI_CAPABILITY("application/cdmi-capability", "cdmia"),
    APP_CDMI_CONTAINER("application/cdmi-container", "cdmic"),
    APP_CDMI_DOMAIN("application/cdmi-domain", "cdmid"),
    APP_CDMI_OBJECT("application/cdmi-object", "cdmio"),
    APP_CDMI_QUEUE("application/cdmi-queue", "cdmiq"),
    APP_CU_SEEME("application/cu-seeme", "cu"),
    APP_DAVMOUNT_XML("application/davmount+xml", "davmount"),
    APP_DOCBOOK_XML("application/docbook+xml", "dbk"),
    APP_DSSC_DER("application/dssc+der", "dssc"),
    APP_DSSC_XML("application/dssc+xml", "xdssc"),
    APP_ECMASCRIPT("application/ecmascript", "ecma"),
    APP_EMMA_XML("application/emma+xml", "emma"),
    APP_EPUB_ZIP("application/epub+zip", "epub"),
    APP_EXI("application/exi", "exi"),
    APP_FONT_TDPFR("application/font-tdpfr", "pfr"),
    APP_FONT_WOFF("application/font-woff", "woff"),
    APP_GML_XML("application/gml+xml", "gml"),
    APP_GPX_XML("application/gpx+xml", "gpx"),
    APP_GZIP("application/gzip", "gz"),
    APP_HVB("application/hyperstudio", "stk"),
    APP_IPFIX("application/ipfix", "ipfix"),
    APP_JAVA_ARCHIVE("application/java-archive", "jar"),
    APP_JAVA_SERIALIZED_OBJECT("application/java-serialized-object", "ser"),
    APP_JAVA_VM("application/java-vm", "class"),
    APP_JAVASCRIPT("application/javascript", "js"),
    APP_JSON("application/json", "json"),
    APP_JSONML_JSON("application/jsonml+json", "jsonml"),
    APP_LOST_XML("application/lost+xml", "lostxml"),
    APP_MAC_BINHEX40("application/mac-binhex40", "hqx"),
    APP_MAC_COMPACTPRO("application/mac-compactpro", "cpt"),
    APP_MADS_XML("application/mads+xml", "mads"),
    APP_MARC("application/marc", "mrc"),
    APP_MARCXML_XML("application/marcxml+xml", "mrcx"),
    APP_MATH_NOTEBOOK_XML("application/mathematica", "ma"),
    APP_MATHML_XML("application/mathml+xml", "mathml"),
    APP_MBOX("application/mbox", "mbox"),
    APP_MEDIASERVER_CONTROL_XML("application/mediaservercontrol+xml", "mscml"),
    APP_METALINK4_XML("application/metalink4+xml", "meta4"),
    APP_METS_XML("application/mets+xml", "mets"),
    APP_MODS_XML("application/mods+xml", "mods"),
    APP_MP21("application/mp21", "m21"),
    APP_MP4("application/mp4", "mp4"),
    APP_MSWORD("application/msword", "doc"),
    APP_MXF("application/mxf", "mxf"),
    APP_BINARY_DATA("application/octet-stream", "bin"),
    APP_ODA("application/oda", "oda"),
    APP_OEBPS_PACKAGE_XML("application/oebps-package+xml", "opf"),
    APP_OGG("application/ogg", "ogx"),
    APP_ONENOTE("application/onenote", "onetoc"),
    APP_XML_PATCH_XML("application/patch-ops-error+xml", "xer"),
    APP_PDF("application/pdf", "pdf"),
    APP_PGP_ENCRYPTED("application/pgp-encrypted", "pgp"),
    APP_PGP_SIGNATURE("application/pgp-signature", "pgp"),
    APP_PICS_RULES("application/pics-rules", "prf"),
    APP_PKCS10("application/pkcs10", "p10"),
    APP_PKCS7_MIME("application/pkcs7-mime", "p7m"),
    APP_PKCS7_SIGNATURE("application/pkcs7-signature", "p7s"),
    APP_PKCS8("application/pkcs8", "p8"),
    APP_PKIX_ATTR_CERT("application/pkix-attr-cert", "ac"),
    APP_PKIX_CERT("application/pkix-cert", "cer"),
    APP_PKIX_CRL("application/pkix-crl", "crl"),
    APP_PKIX_PKIPATH("application/pkix-pkipath", "pkipath"),
    APP_PKIXCMP("application/pkixcmp", "pki"),
    APP_PLS_XML("application/pls+xml", "pls"),
    APP_POSTSCRIPT("application/postscript", "ai"),
    APP_PRS_CWW("application/prs.cww", "cww"),
    APP_PSKC_XML("application/pskc+xml", "pskcxml"),
    APP_RDF_XML("application/rdf+xml", "rdf"),
    APP_REGINFO_XML("application/reginfo+xml", "rif"),
    APP_RELAX_NG_COMPACT_SYNTAX("application/relax-ng-compact-syntax", "rnc"),
    APP_RESOURCE_LISTS_DIFF_XML("application/resource-lists-diff+xml", "rld"),
    APP_RESOURCE_LISTS_XML("application/resource-lists+xml", "rl"),
    APP_RLS_SERVICES_XML("application/rls-services+xml", "rs"),
    APP_RSD_XML("application/rsd+xml", "rsd"),
    APP_RSS_XML("application/rss+xml", "rss"),
    APP_RTF("application/rtf", "rtf"),
    APP_SBML_XML("application/sbml+xml", "sbml"),
    APP_SCVP_CV_REQUEST("application/scvp-cv-request", "scq"),
    APP_SCVP_CV_RESPONSE("application/scvp-cv-response", "scs"),
    APP_SCVP_VP_REQUEST("application/scvp-vp-request", "spq"),
    APP_SCVP_VP_RESPONSE("application/scvp-vp-response", "spp"),
    APP_SDP("application/sdp", "sdp"),
    APP_SET_PAYMENT_INITIATION("application/set-payment-initiation", "setpay"),
    APP_SET_REGISTRATION_INITIATION("application/set-registration-initiation", "setreg"),
    APP_SHF_XML("application/shf+xml", "shf"),
    APP_SMIL_XML("application/smil+xml", "smi"),
    APP_SPARQL_QUERY("application/sparql-query", "rq"),
    APP_SPARQL_RESULTS_XML("application/sparql-results+xml", "srx"),
    APP_SRGS("application/srgs", "gram"),
    APP_SRGS_XML("application/srgs+xml", "grxml"),
    APP_SRU_XML("application/sru+xml", "sru"),
    APP_SSML_XML("application/ssml+xml", "ssml"),
    APP_TEI_XML("application/tei+xml", "tei"),
    APP_THRAUD_XML("application/thraud+xml", "tfi"),
    APP_TIMESTAMPED_DATA("application/timestamped-data", "tsd"),
    APP_VND_3GPP_PIC_BW_LARGE("application/vnd.3gpp.pic-bw-large", "plb"),
    APP_VND_3GPP_PIC_BW_SMALL("application/vnd.3gpp.pic-bw-small", "psb"),
    APP_VND_3GPP_PIC_BW_VAR("application/vnd.3gpp.pic-bw-var", "pvb"),
    APP_VND_3GPP2_TCAP("application/vnd.3gpp2.tcap", "tcap"),
    APP_VND_3M_POST_IT_NOTES("application/vnd.3m.post-it-notes", "pwn"),
    APP_VND_ACCPAC_SIMPLY_ASO("application/vnd.accpac.simply.aso", "aso"),
    APP_VND_ACCPAC_SIMPLY_IMP("application/vnd.accpac.simply.imp", "imp"),
    APP_VND_ACUCOBOL("application/vnd.acucobol", "acu"),
    APP_VND_ACUCORP("application/vnd.acucorp", "atc"),
    APP_VND_ADOBE_AIR_APPLICATION_INSTALLER_PACKAGE_ZIP(
        "application/vnd.adobe.air-application-installer-package+zip",
        "air"
    ),
    APP_VND_ADOBE_FORMSCENTRAL_FCDT("application/vnd.adobe.formscentral.fcdt", "fcdt"),
    APP_VND_ADOBE_FXP("application/vnd.adobe.fxp", "fxp"),
    APP_VND_ADOBE_XDP_XML("application/vnd.adobe.xdp+xml", "xdp"),
    APP_VND_ADOBE_XFDF("application/vnd.adobe.xfdf", "xfdf"),
    APP_VND_AHEAD_SPACE("application/vnd.ahead.space", "ahead"),
    APP_VND_AIRZIP_FILESECURE_AZF("application/vnd.airzip.filesecure.azf", "azf"),
    APP_VND_AIRZIP_FILESECURE_AZS("application/vnd.airzip.filesecure.azs", "azs"),
    APP_VND_AMAZON_EBOOK("application/vnd.amazon.ebook", "azw"),
    APP_VND_AMERICANDYNAMICS_ACC("application/vnd.americandynamics.acc", "acc"),
    APP_VND_AMIGA_AMI("application/vnd.amiga.ami", "ami"),
    APP_VND_ANDROID_PACKAGE_ARCHIVE("application/vnd.android.package-archive", "apk"),
    APP_VND_ANSER_WEB_CERTIFICATE_ISSUE_INITIATION(
        "application/vnd.anser-web-certificate-issue-initiation",
        "cii"
    ),
    APP_VND_ANSER_WEB_FUNDS_TRANSFER_INITIATION(
        "application/vnd.anser-web-funds-transfer-initiation",
        "fti"
    ),
    APP_VND_ANTIX_GAME_COMPONENT("application/vnd.antix.game-component", "atx"),
    APP_VND_APPLE_INSTALLER_XML("application/vnd.apple.installer+xml", "mpkg"),
    APP_MULTIMEDIA_PLAYLIST_XML("application/vnd.apple.mpegurl", "m3u8"),
    APP_VND_ARISTANETWORKS_SWI("application/vnd.arastra.swi", "swi"),
    APP_VND_AUDIO_GRAPHML("application/vnd.audiograph", "aep"),
    APP_VND_BLUEICE_MULTIPASS("application/vnd.blueice.multipass", "mpm"),
    APP_VND_BMI("application/vnd.bmi", "bmi"),
    APP_VND_BUSINESSOBJECTS("application/vnd.businessobjects", "rep"),
    APP_VND_CHEMDRAW_XML("application/vnd.chemdraw+xml", "cdxml"),
    APP_VND_CHIPNUTS_KARAOKE_MMD("application/vnd.chipnuts.karaoke-mmd", "mmd"),
    APP_VND_CINDERELLA("application/vnd.cinderella", "cdy"),
    APP_VND_CLAYMORE("application/vnd.claymore", "cla"),
    APP_VND_CLOANTO_RP9("application/vnd.cloanto.rp9", "rp9"),
    APP_VND_CLONK_C4GROUP("application/vnd.clonk.c4group", "c4g"),
    APP_VND_CLUETRUST_CARTOMOBILE_CONFIG("application/vnd.cluetrust.cartomobile-config", "c11amc"),
    APP_VND_CLUETRUST_CARTOMOBILE_CONFIG_PKG(
        "application/vnd.cluetrust.cartomobile-config-pkg",
        "c11amz"
    ),
    APP_VND_COMMONSPACE("application/vnd.commonspace", "csp"),
    APP_VND_CONTACT_CMSG("application/vnd.contact.cmsg", "cdbcmsg"),
    APP_VND_COSMOCALLER("application/vnd.cosmocaller", "cmc"),
    APP_VND_CRICK_CLICKER("application/vnd.crick.clicker", "clkx"),
    APP_VND_CRICK_CLICKER_KEYBOARD("application/vnd.crick.clicker.keyboard", "clkk"),
    APP_VND_CRICK_CLICKER_PALETTE("application/vnd.crick.clicker.palette", "clkp"),
    APP_VND_CRICK_CLICKER_TEMPLATE("application/vnd.crick.clicker.template", "clkt"),
    APP_VND_CRICK_CLICKER_WORDBANK("application/vnd.crick.clicker.wordbank", "clkw"),
    APP_VND_CRITICALTOOLS_WBS_XML("application/vnd.criticaltools.wbs+xml", "wbs"),
    APP_VND_CTC_POSML("application/vnd.ctc-posml", "pml"),
    APP_VND_CUPS_PPD("application/vnd.cups-ppd", "ppd"),
    APP_VND_CURL_CAR("application/vnd.curl.car", "car"),
    APP_VND_CURL_PCURL("application/vnd.curl.pcurl", "pcurl"),
    APP_VND_REMOTEDOCS_RDF_XML("application/vnd.data-vision.rdz", "rdz"),
    APP_VND_FCS("application/vnd.denovo.fcselayout-link", "fe_launch"),
    APP_VND_DNA("application/vnd.dna", "dna"),
    APP_VND_DOLBY_MLP("application/vnd.dolby.mlp", "mlp"),
    APP_VND_DPGRAPH("application/vnd.dpgraph", "dpg"),
    APP_VND_DREAMFACTORY("application/vnd.dreamfactory", "dfac"),
    APP_VND_AIT("application/vnd.dvb.ait", "ait"),
    APP_VND_DVB_SERVICE("application/vnd.dvb.service", "svc"),
    APP_VND_DYNAGEO("application/vnd.dynageo", "geo"),
    APP_VND_ECOWIN_CHART("application/vnd.ecowin.chart", "mag"),
    APP_VND_ENLIVEN("application/vnd.enliven", "nml"),
    APP_VND_EPOCWARE_MOBILEX_ESF("application/vnd.epson.esf", "esf"),
    APP_VND_EPOCWARE_MOBILEX_MSF("application/vnd.epson.msf", "msf"),
    APP_VND_EPSON_QUICKANIME("application/vnd.epson.quickanime", "qam"),
    APP_VND_EPSON_SALT("application/vnd.epson.salt", "slt"),
    APP_VND_EPSON_SSF("application/vnd.epson.ssf", "ssf"),
    APP_VND_ESZIGNO3_XML("application/vnd.eszigno3+xml", "es3"),
    APP_VND_EZPIX_ALBUM("application/vnd.ezpix-album", "ez2"),
    APP_VND_EZPIX_PACKAGE("application/vnd.ezpix-package", "ez3"),
    APP_FORMS_DATA_FORMAT("application/vnd.fdf", "fdf"),
    APP_DIGITAL_SIESMOGRAPH_NETWORKS_SEED_DATAFILES("application/vnd.fdsn.seed", "seed"),
    APP_NPGRAPHIT("application/vnd.flographit", "gph"),
    APP_FLUXTIME_CLIP("application/vnd.fluxtime.clip", "ftc"),
    APP_FRAMEMAKER_NORMAL_FORMAT("application/vnd.framemaker", "fm"),
    APP_FROGANS_PLAYER_FNC("application/vnd.frogans.fnc", "fnc"),
    APP_FROGANS_PLAYER_LTF("application/vnd.frogans.ltf", "ltf"),
    APP_FRIENDLY_SOFTWARE_CORPORATION("application/vnd.fsc.weblaunch", "fsc"),
    APP_FUJITSU_OASYS_OAS("application/vnd.fujitsu.oasys", "oas"),
    APP_FUJITSU_OASYS_OA2("application/vnd.fujitsu.oasys2", "oa2"),
    APP_FUJITSU_OASYS_OA3("application/vnd.fujitsu.oasys3", "oa3"),
    APP_FUJITSU_OASYS_FG5("application/vnd.fujitsu.oasysgp", "fg5"),
    APP_FUJITSU_OASYS_BH2("application/vnd.fujitsu.oasysprs", "bh2"),
    APP_FUJITSU_XEROX_2D_CAD_DATA("application/vnd.fujixerox.ddd", "ddd"),
    APP_FUJITSU_XEROX_DOCUWORKS("application/vnd.fujixerox.docuworks", "xdw"),
    APP_FUJITSU_XEROX_DOCUWORKS_BINDER("application/vnd.fujixerox.docuworks.binder", "xbd"),
    APP_FUZZYSHEET("application/vnd.fuzzysheet", "fzs"),
    APP_GENOMATIX_TUXEDO_FRAMEWORK("application/vnd.genomatix.tuxedo", "txd"),
    APP_GEOGEBRA_GGB("application/vnd.geogebra.file", "ggb"),
    APP_GEOGEBRA_GGT("application/vnd.geogebra.tool", "ggt"),
    APP_GEOMETRY_EXPLORER("application/vnd.geometry-explorer", "gex"),
    APP_GEONEXT_AND_JSXGRAPH("application/vnd.geonext", "gxt"),
    APP_GEOPLANW("application/vnd.geoplan", "g2w"),
    APP_GEOSPACW("application/vnd.geospace", "g3w"),
    APP_GAMEMAKER_ACTIVEX("application/vnd.gmx", "gmx"),
    APP_GOOGLE_EARTH_KML("application/vnd.google-earth.kml+xml", "kml"),
    APP_GOOGLE_EARTH_ZIPPED_KML("application/vnd.google-earth.kmz", "kmz"),
    APP_GRAFEQ("application/vnd.grafeq", "gqf"),
    APP_GROOVE_ACCOUNT("application/vnd.groove-account", "gac"),
    APP_GROOVE_HELP("application/vnd.groove-help", "ghf"),
    APP_GROOVE_IDENTITY_MESSAGE("application/vnd.groove-identity-message", "gim"),
    APP_GROOVE_INJECTOR("application/vnd.groove-injector", "grv"),
    APP_GROOVE_TOOL_MESSAGE("application/vnd.groove-tool-message", "gtm"),
    APP_GROOVE_TOOL_TEMPLATE("application/vnd.groove-tool-template", "tpl"),
    APP_GROOVE_VCARD("application/vnd.groove-vcard", "vcg"),
    APP_HYPERTEXT_APPLICATION_LANGUAGE("application/vnd.hal+xml", "hal"),
    APP_ZVUE_MEDIA_MANAGER("application/vnd.handheld-entertainment+xml", "zmm"),
    APP_HOMEBANKING_COMPUTER_INTERFACE_HBCI("application/vnd.hbci", "hbci"),
    APP_ARCHIPELAGO_LESSON_PLAYER("application/vnd.hhe.lesson-player", "les"),
    APP_HP_GL2_AND_HP_RTL("application/vnd.hp-hpgl", "hpgl"),
    APP_HEWLETT_PACKARD_INSTANT_DELIVERY("application/vnd.hp-hpid", "hpid"),
    APP_HEWLETT_PACKARDS_WEBPRINTSMART("application/vnd.hp-hps", "hps"),
    APP_HP_INDIGO_DIGITAL_PRESS_JOB_LAYOUT_LANGUATE("application/vnd.hp-jlyt", "jlt"),
    APP_HP_PRINTER_COMMAND_LANGUAGE("application/vnd.hp-pcl", "pcl"),
    APP_PCL_6_ENHANCED_FORMELY_PCL_XL("application/vnd.hp-pclxl", "pclxl"),
    APP_HYDROSTATIX_MASTER_SUITE("application/vnd.hydrostatix.sof-data", "sfd-hdstx"),
    APP_3D_CROSSWORD_PLUGIN("application/vnd.hzn-3d-crossword", "x3d"),
    APP_MINIPAY("application/vnd.ibm.minipay", "mpy"),
    APP_MO_DCA_P("application/vnd.ibm.modcap", "afp"),
    APP_IBM_DB2_RIGHTS_MANAGER("application/vnd.ibm.rights-management", "irm"),
    APP_IBM_ELECTRONIC_MEDIA_MANAGEMENT_SYSTEM_SECURE_CONTAINER(
        "application/vnd.ibm.secure-container",
        "sc"
    ),
    APP_ICC_PROFILE("application/vnd.iccprofile", "icc"),
    APP_IGLOADER("application/vnd.igloader", "igl"),
    APP_IMMERVISION_PURE_PLAYERS_IVP("application/vnd.immervision-ivp", "ivp"),
    APP_IMMERVISION_PURE_PLAYERS_IVU("application/vnd.immervision-ivu", "ivu"),
    APP_IOCOM_VISIMEET("application/vnd.insors.igm", "igm"),
    APP_INTERCON_FORMNET("application/vnd.intercon.formnet", "xpw"),
    APP_INTERACTIVE_GEOMETRY_SOFTWARE("application/vnd.intergeo", "i2g"),
    APP_OPEN_FINANCIAL_EXCHANGE("application/vnd.intu.qbo", "qbo"),
    APP_QUICKEN("application/vnd.intu.qfx", "qfx"),
    APP_IP_UNPLUGGED_ROAMING_CLIENT("application/vnd.ipunplugged.rcprofile", "rcprofile"),
    APP_IREPOSITORY_LUCIDOC_EDITOR("application/vnd.irepository.package+xml", "irp"),
    APP_EXPRESS_BY_INFOSEEK("application/vnd.is-xpr", "xpr"),
    APP_INTERNATIONAL_SOCIETY_FOR_ADVANCEMENT_OF_CYTOMETRY("application/vnd.isac.fcs", "fcs"),
    APP_LIGHTSPEED_AUDIO_LAB("application/vnd.jam", "jam"),
    APP_MOBILE_INFORMATION_DEVICE_PROFILE("application/vnd.jcp.javame.midlet-rms", "rms"),
    APP_RHYMBOX("application/vnd.jisp", "jisp"),
    APP_JODA_ARCHIVE("application/vnd.joost.joda-archive", "joda"),
    APP_KAHOOTZ("application/vnd.kahootz", "ktz"),
    APP_KDE_KOFFICE_OFFICE_SUITE_KARBON("application/vnd.kde.karbon", "karbon"),
    APP_KDE_KOFFICE_OFFICE_SUITE_KCHART("application/vnd.kde.kchart", "chrt"),
    APP_KDE_KOFFICE_OFFICE_SUITE_KFORMULA("application/vnd.kde.kformula", "kfo"),
    APP_KDE_KOFFICE_OFFICE_SUITE_KIVIO("application/vnd.kde.kivio", "flw"),
    APP_KDE_KOFFICE_OFFICE_SUITE_KONTOUR("application/vnd.kde.kontour", "kon"),
    APP_KDE_KOFFICE_OFFICE_SUITE_KPRESENTER("application/vnd.kde.kpresenter", "kpr"),
    APP_KDE_KOFFICE_OFFICE_SUITE_KSPREAD("application/vnd.kde.kspread", "ksp"),
    APP_KDE_KOFFICE_OFFICE_SUITE_KWORD("application/vnd.kde.kword", "kwd"),
    APP_KENAMEA_APP("application/vnd.kenameaapp", "htke"),
    APP_KIDSPIRATION("application/vnd.kidspiration", "kia"),
    APP_KINAR_APPLICATIONS("application/vnd.kinar", "kne"),
    APP_SSEYO_KOAN_PLAY_FILE("application/vnd.koan", "skp"),
    APP_KODAK_STORYSHARE("application/vnd.kodak-descriptor", "sse"),
    APP_LASER_APP_ENTERPRISE("application/vnd.las.las+xml", "lasxml"),
    APP_LIFE_BALANCE_DESKTOP_EDITION("application/vnd.llamagraphics.life-balance.desktop", "lbd"),
    APP_LIFE_BALANCE_EXCHANGE_FORMAT(
        "application/vnd.llamagraphics.life-balance.exchange+xml",
        "lbe"
    ),
    APP_LOTUS_APPROACH("application/vnd.lotus-approach", "apr"),
    APP_LOTUS_FREELANCE("application/vnd.lotus-freelance", "pre"),
    APP_LOTUS_NOTES("application/vnd.lotus-notes", "nsf"),
    APP_LOTUS_ORGANIZER("application/vnd.lotus-organizer", "org"),
    APP_LOTUS_SCREENCAM("application/vnd.lotus-screencam", "scm"),
    APP_LOTUS_WORDPRO("application/vnd.lotus-wordpro", "lwp"),
    APP_MACPORTS_PORT_SYSTEM("application/vnd.macports.portpkg", "portpkg"),
    APP_MICRO_CADAM_HELIX_DD("application/vnd.mcd", "mcd"),
    APP_MEDCALC("application/vnd.medcalcdata", "mc1"),
    APP_MEDIAREMOTE("application/vnd.mediastation.cdkey", "cdkey"),
    APP_MEDICAL_WAVEFORM_ENCODING_FORMAT("application/vnd.mfer", "mwf"),
    APP_MELODY_FORMAT_FOR_MOBILE_PLATFORM("application/vnd.mfmp", "mfm"),
    APP_MICROGRAFX("application/vnd.micrografx.flo", "flo"),
    APP_MICROGRAFX_IGRAFX_PROFESSIONAL("application/vnd.micrografx.igx", "igx"),
    APP_FRAMEMAKER_INTERCHANGE_FORMAT("application/vnd.mif", "mif"),
    APP_MOBIUS_MANAGEMENT_SYSTEMS_UNIVERSALARCHIVE("application/vnd.mobius.daf", "daf"),
    APP_MOBIUS_MANAGEMENT_SYSTEMS_DISTRIBUTION_DATABASE("application/vnd.mobius.dis", "dis"),
    APP_MOBIUS_MANAGEMENT_SYSTEMS_BASKET_FILE("application/vnd.mobius.mbk", "mbk"),
    APP_MOBIUS_MANAGEMENT_SYSTEMS_QUERY_FILE("application/vnd.mobius.mqy", "mqy"),
    APP_MOBIUS_MANAGEMENT_SYSTEMS_SCRIPT_LANGUAGE("application/vnd.mobius.msl", "msl"),
    APP_MOBIUS_MANAGEMENT_SYSTEMS_POLICY_DEFINITION_LANGUAGE_FILE(
        "application/vnd.mobius.plc",
        "plc"
    ),
    APP_MOBIUS_MANAGEMENT_SYSTEMS_TOPIC_INDEX_FILE("application/vnd.mobius.txf", "txf"),
    APP_MOPHUN_VM("application/vnd.mophun.application", "mpn"),
    APP_MOPHUN_CERTIFICATE("application/vnd.mophun.certificate", "mpc"),
    APP_XUL_XML_USER_INTERFACE_LANGUAGE("application/vnd.mozilla.xul+xml", "xul"),
    APP_MICROSOFT_ARTGALRY("application/vnd.ms-artgalry", "cil"),
    APP_MICROSOFT_CABINET_FILE("application/vnd.ms-cab-compressed", "cab"),
    APP_MICROSOFT_EXCEL("application/vnd.ms-excel", "xls"),
    APP_MICROSOFT_EXCEL_ADD_IN_FILE("application/vnd.ms-excel.addin.macroenabled.12", "xlam"),
    APP_MICROSOFT_EXCEL_BINARY_WORKBOOK(
        "application/vnd.ms-excel.sheet.binary.macroenabled.12",
        "xlsb"
    ),
    APP_MICROSOFT_EXCEL_MACRO_ENABLED_WORKBOOK(
        "application/vnd.ms-excel.sheet.macroenabled.12",
        "xlsm"
    ),
    APP_MICROSOFT_EXCEL_MACRO_ENABLED_TEMPLATE_FILE(
        "application/vnd.ms-excel.template.macroenabled.12",
        "xltm"
    ),
    APP_MICROSOFT_EMBEDDED_OPENTYPE("application/vnd.ms-fontobject", "eot"),
    APP_MICROSOFT_HTML_HELP_FILE("application/vnd.ms-htmlhelp", "chm"),
    APP_MICROSOFT_CLASS_SERVER("application/vnd.ms-ims", "ims"),
    APP_MICROSOFT_LEARNING_RESOURCE_MODULE("application/vnd.ms-lrm", "lrm"),
    APP_MICROSOFT_OFFICE_SYSTEM_RELEASE_THEME("application/vnd.ms-officetheme", "thmx"),
    APP_MICROSOFT_TRUST_UI_PROVIDER_SECURITY_CATALOG("application/vnd.ms-pki.seccat", "cat"),
    APP_MICROSOFT_TRUST_UI_PROVIDER_CERTIFICATE_TRUST_LINK("application/vnd.ms-pki.stl", "stl"),
    APP_MICROSOFT_POWERPOINT("application/vnd.ms-powerpoint", "ppt"),
    APP_MICROSOFT_POWERPOINT_ADD_IN_FILE(
        "application/vnd.ms-powerpoint.addin.macroenabled.12",
        "ppam"
    ),
    APP_MICROSOFT_POWERPOINT_MACRO_ENABLED_PRESENTATION_FILE(
        "application/vnd.ms-powerpoint.presentation.macroenabled.12",
        "pptm"
    ),
    APP_MICROSOFT_POWERPOINT_MACRO_ENABLED_OPEN_XML_SLIDE(
        "application/vnd.ms-powerpoint.slide.macroenabled.12",
        "sldm"
    ),
    APP_MICROSOFT_POWERPOINT_MACRO_ENABLED_SLIDE_SHOW_FILE(
        "application/vnd.ms-powerpoint.slideshow.macroenabled.12",
        "ppsm"
    ),
    APP_MICROSOFT_POWERPOINT_MACRO_ENABLED_TEMPLATE_FILE(
        "application/vnd.ms-powerpoint.template.macroenabled.12",
        "potm"
    ),
    APP_MICROSOFT_PROJECT("application/vnd.ms-project", "mpp"),
    APP_MICROSOFT_WORD_MACRO_ENABLED_DOCUMENT(
        "application/vnd.ms-word.document.macroenabled.12",
        "docm"
    ),
    APP_MICROSOFT_WORD_MACRO_ENABLED_TEMPLATE(
        "application/vnd.ms-word.template.macroenabled.12",
        "dotm"
    ),
    APP_MICROSOFT_WORKS("application/vnd.ms-works", "wps"),
    APP_MICROSOFT_WINDOWS_MEDIA_PLAYER_PLAYLIST("application/vnd.ms-wpl", "wpl"),
    APP_MICROSOFT_XML_PAPER_SPECIFICATION("application/vnd.ms-xpsdocument", "xps"),
    APP_3GPP_MSEQ_FILE("application/vnd.mseq", "mseq"),
    APP_MUSICAL_SCORE_INTERPRETED_CODE_INVENTED_FOR_THE_ASCII_DESIGNATION_OF_NOTATION(
        "application/vnd.musician",
        "mus"
    ),
    APP_MUVEE_AUTOMATIC_VIDEO_EDITING("application/vnd.muvee.style", "msty"),
    APP_NEUROLANGUAGE("application/vnd.neurolanguage.nlu", "nlu"),
    APP_NOBLENET_DIRECTORY("application/vnd.noblenet-directory", "nnd"),
    APP_NOBLENET_SEALER("application/vnd.noblenet-sealer", "nns"),
    APP_NOBLENET_WEB("application/vnd.noblenet-web", "nnw"),
    APP_N_GAGE_GAME_DATA("application/vnd.nokia.n-gage.data", "ngdat"),
    APP_N_GAGE_GAME_INSTALLER("application/vnd.nokia.n-gage.symbian.install", "n-gage"),
    APP_NOKIA_RADIO_APPLICATION_PRESET_RPST("application/vnd.nokia.radio-preset", "rpst"),
    APP_NOKIA_RADIO_APPLICATION_PRESET_RPSS("application/vnd.nokia.radio-presets", "rpss"),
    APP_NOVADIGMS_RADIA_AND_EDM_PRODUCTS_EDM("application/vnd.novadigm.edm", "edm"),
    APP_NOVADIGMS_RADIA_AND_EDM_PRODUCTS_EDX("application/vnd.novadigm.edx", "edx"),
    APP_NOVADIGMS_RADIA_AND_EDM_PRODUCTS_EXT("application/vnd.novadigm.ext", "ext"),
    APP_OPENDOCUMENT_CHART("application/vnd.oasis.opendocument.chart", "odc"),
    APP_OPENDOCUMENT_CHART_TEMPLATE("application/vnd.oasis.opendocument.chart-template", "otc"),
    APP_OPENDOCUMENT_DATABASE("application/vnd.oasis.opendocument.database", "odb"),
    APP_OPENDOCUMENT_FORMULA("application/vnd.oasis.opendocument.formula", "odf"),
    APP_OPENDOCUMENT_FORMULA_TEMPLATE(
        "application/vnd.oasis.opendocument.formula-template",
        "odft"
    ),
    APP_OPENDOCUMENT_GRAPHICS("application/vnd.oasis.opendocument.graphics", "odg"),
    APP_OPENDOCUMENT_GRAPHICS_TEMPLATE(
        "application/vnd.oasis.opendocument.graphics-template",
        "otg"
    ),
    APP_OPENDOCUMENT_IMAGE("application/vnd.oasis.opendocument.image", "odi"),
    APP_OPENDOCUMENT_IMAGE_TEMPLATE("application/vnd.oasis.opendocument.image-template", "oti"),
    APP_OPENDOCUMENT_PRESENTATION("application/vnd.oasis.opendocument.presentation", "odp"),
    APP_OPENDOCUMENT_PRESENTATION_TEMPLATE(
        "application/vnd.oasis.opendocument.presentation-template",
        "otp"
    ),
    APP_OPENDOCUMENT_SPREADSHEET("application/vnd.oasis.opendocument.spreadsheet", "ods"),
    APP_OPENDOCUMENT_SPREADSHEET_TEMPLATE(
        "application/vnd.oasis.opendocument.spreadsheet-template",
        "ots"
    ),
    APP_OPENDOCUMENT_TEXT("application/vnd.oasis.opendocument.text", "odt"),
    APP_OPENDOCUMENT_TEXT_MASTER("application/vnd.oasis.opendocument.text-master", "odm"),
    APP_OPENDOCUMENT_TEXT_TEMPLATE("application/vnd.oasis.opendocument.text-template", "ott"),
    APP_OPEN_DOCUMENT_TEXT_WEB("application/vnd.oasis.opendocument.text-web", "oth"),
    APP_SUGAR_LINUX_APPLICATION_BUNDLE("application/vnd.olpc-sugar", "xo"),
    APP_OMA_DOWNLOAD_AGENTS("application/vnd.oma.dd2+xml", "dd2"),
    APP_OPEN_OFFICE_EXTENSION("application/vnd.openofficeorg.extension", "oxt"),
    APP_MICROSOFT_OFFICE_OOXML_PRESENTATION(
        "application/vnd.openxmlformats-officedocument.presentationml.presentation",
        "pptx"
    ),
    APP_MICROSOFT_OFFICE_OOXML_PRESENTATION_SLIDE(
        "application/vnd.openxmlformats-officedocument.presentationml.slide",
        "sldx"
    ),
    APP_MICROSOFT_OFFICE_OOXML_PRESENTATION_SLIDESHOW(
        "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
        "ppsx"
    ),
    APP_MICROSOFT_OFFICE_OOXML_PRESENTATION_TEMPLATE(
        "application/vnd.openxmlformats-officedocument.presentationml.template",
        "potx"
    ),
    APP_MICROSOFT_OFFICE_OOXML_SPREADSHEET(
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
        "xlsx"
    ),
    APP_MICROSOFT_OFFICE_OOXML_SPREADSHEET_TEMPLATE(
        "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
        "xltx"
    ),
    APP_MICROSOFT_OFFICE_OOXML_WORD_DOCUMENT(
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        "docx"
    ),
    APP_MICROSOFT_OFFICE_OOXML_WORD_DOCUMENT_TEMPLATE(
        "application/vnd.openxmlformats-officedocument.wordprocessingml.template",
        "dotx"
    ),
    APP_MAPGUIDE_DBXML("application/vnd.osgeo.mapguide.package", "mgp"),
    APP_OSGI_DEPLOYMENT_PACKAGE("application/vnd.osgi.dp", "dp"),
    APP_PALMOS_DATA("application/vnd.palm", "pdb"),
    APP_PAWAAFILE("application/vnd.pawaafile", "paw"),
    APP_PROPRIETARY_PG_STANDARD_REPORTING_SYSTEM_STR("application/vnd.pg.format", "str"),
    APP_PROPRIETARY_PG_STANDARD_REPORTING_SYSTEM_EI6("application/vnd.pg.osasli", "ei6"),
    APP_PCSEL_EFIF_FILE("application/vnd.picsel", "efif"),
    APP_QUALCOMMS_PLAZA_MOBILE_INTERNET("application/vnd.pmi.widget", "wg"),
    APP_POCKETLEARN_VIEWERS("application/vnd.pocketlearn", "plf"),
    APP_POWERBUILDER("application/vnd.powerbuilder6", "pbd"),
    APP_PREVIEW_SYSTEMS_ZIPLOCK_VBOX("application/vnd.previewsystems.box", "box"),
    APP_EFI_PROTEUS("application/vnd.proteus.magazine", "mgz"),
    APP_PUBLISHARE_OBJECTS("application/vnd.publishare-delta-tree", "qps"),
    APP_PRINCETON_VIDEO_IMAGE("application/vnd.pvi.ptid1", "ptid"),
    APP_QUARKXPRESS("application/vnd.quark.quarkxpress", "qxd"),
    APP_REALVNC("application/vnd.realvnc.bed", "bed"),
    APP_RECORDARE_APPLICATIONS_MXL("application/vnd.recordare.musicxml", "mxl"),
    APP_RECORDARE_APPLICATIONS_MUSIC_XML("application/vnd.recordare.musicxml+xml", "musicxml"),
    APP_CRYPTONOTE("application/vnd.rig.cryptonote", "cryptonote"),
    APP_BLACKBERRY_COD_FILE("application/vnd.rim.cod", "cod"),
    APP_REALMEDIA("application/vnd.rn-realmedia", "rm"),
    APP_ROUTE_66_LOCATION_BASED_SERVICES("application/vnd.route66.link66+xml", "link66"),
    APP_SAILINGTRACKER("application/vnd.sailingtracker.track", "st"),
    APP_SEEMAIL("application/vnd.seemail", "see"),
    APP_SECURED_EMAIL_SEMA("application/vnd.sema", "sema"),
    APP_SECURED_EMAIL_SEMD("application/vnd.semd", "semd"),
    APP_SECURED_EMAIL_SEMF("application/vnd.semf", "semf"),
    APP_SHANA_INFORMED_FILLER_IFM("application/vnd.shana.informed.formdata", "ifm"),
    APP_SHANA_INFORMED_FILLER_ITP("application/vnd.shana.informed.formtemplate", "itp"),
    APP_SHANA_INFORMED_FILLER_IIF("application/vnd.shana.informed.interchange", "iif"),
    APP_SHANA_INFORMED_FILLER_IPK("application/vnd.shana.informed.package", "ipk"),
    APP_SIMTECH_MINDMAPPER("application/vnd.simtech-mindmapper", "twd"),
    APP_SMAF_FILE("application/vnd.smaf", "mmf"),
    APP_SMART_TECHNOLOGIES_APPS("application/vnd.smart.teacher", "teacher"),
    APP_SUDOKUMAGIC("application/vnd.solent.sdkm+xml", "sdkm"),
    APP_TIBCO_SPOTFIRE_DXP("application/vnd.spotfire.dxp", "dxp"),
    APP_TIBCO_SPOTFIRE_SFS("application/vnd.spotfire.sfs", "sfs"),
    APP_STAROFFICE_CALC("application/vnd.stardivision.calc", "sdc"),
    APP_STAROFFICE_DRAW("application/vnd.stardivision.draw", "sda"),
    APP_STAROFFICE_IMPRESS("application/vnd.stardivision.impress", "sdd"),
    APP_STAROFFICE_MATH("application/vnd.stardivision.math", "smf"),
    APP_STAROFFICE_WRITER("application/vnd.stardivision.writer", "sdw"),
    APP_STAROFFICE_WRITER_GLOBAL("application/vnd.stardivision.writer-global", "sgl"),
    APP_STEPMANIA("application/vnd.stepmania.stepchart", "sm"),
    APP_OPENOFFICE_CALC_SPREADSHEET("application/vnd.sun.xml.calc", "sxc"),
    APP_OPENOFFICE_CALC_TEMPLATE_SPREADSHEET("application/vnd.sun.xml.calc.template", "stc"),
    APP_OPENOFFICE_DRAW_GRAPHICS("application/vnd.sun.xml.draw", "sxd"),
    APP_OPENOFFICE_DRAW_TEMPLATE_GRAPHICS("application/vnd.sun.xml.draw.template", "std"),
    APP_OPENOFFICE_IMPRESS_PRESENTATION("application/vnd.sun.xml.impress", "sxi"),
    APP_OPENOFFICE_IMPRESS_TEMPLATE_PRESENTATION("application/vnd.sun.xml.impress.template", "sti"),
    APP_OPENOFFICE_MATH_FORMULA("application/vnd.sun.xml.math", "sxm"),
    APP_OPENOFFICE_WRITER_TEXT_HTML("application/vnd.sun.xml.writer", "sxw"),
    APP_OPENOFFICE_WRITER_TEXT_HTML_GLOBAL("application/vnd.sun.xml.writer.global", "sxg"),
    APP_OPENOFFICE_WRITER_TEMPLATE_TEXT_HTML("application/vnd.sun.xml.writer.template", "stw"),
    APP_SCHEDULEUS("application/vnd.sus-calendar", "sus"),
    APP_SOURCEVIEW_DOCUMENT("application/vnd.svd", "svd"),
    APP_SYMBIAN_INSTALL_PACKAGE("application/vnd.symbian.install", "sis"),
    APP_SYNCML_DEVICE_MANAGEMENT_BDM("application/vnd.syncml.dm+wbxml", "bdm"),
    APP_SYNCML_DEVICE_MANAGEMENT_XDM("application/vnd.syncml.dm+xml", "xdm"),
    APP_SYNCML("application/vnd.syncml+xml", "xsm"),
    APP_TAO_INTENT("application/vnd.tao.intent-module-archive", "tao"),
    APP_MOBILETV("application/vnd.tmobile-livetv", "tmo"),
    APP_TRI_SYSTEMS_CONFIG("application/vnd.trid.tpt", "tpt"),
    APP_TRISCAPE_MAP_EXPLORER("application/vnd.triscape.mxs", "mxs"),
    APP_TRUE_BASIC("application/vnd.trueapp", "tra"),
    APP_UNIVERSAL_FORMS_DESCRIPTION_LANGUAGE("application/vnd.ufdl", "ufd"),
    APP_USER_INTERFACE_QUARTZ_THEME_SYMBIAN("application/vnd.uiq.theme", "utz"),
    APP_UMAJIN("application/vnd.umajin", "umj"),
    APP_UNITY_3D("application/vnd.unity", "unityweb"),
    APP_UNIQUE_OBJECT_MARKUP_LANGUAGE("application/vnd.uoml+xml", "uoml"),
    APP_VIRTUALCATALOG("application/vnd.vcx", "vcx"),
    APP_MICROSOFT_VISIO("application/vnd.visio", "vsd"),
    APP_MICROSOFT_VISIO_2013("application/vnd.visio2013", "vsdx"),
    APP_VISIONARY("application/vnd.visionary", "vis"),
    APP_VIEWPORT("application/vnd.vsf", "vsf"),
    APP_WAP_BINARY_XML_WBXML("application/vnd.wap.wbxml", "wbxml"),
    APP_COMPILED_WIRELESS_MARKUP_LANGUAGE_WMLC("application/vnd.wap.wmlc", "wmlc"),
    APP_WMLSCRIPT("application/vnd.wap.wmlscriptc", "wmlsc"),
    APP_WEBTURBO("application/vnd.webturbo", "wtb"),
    APP_MATHEMATICA_NOTEBOOK_PLAYER("application/vnd.wolfram.player", "nbp"),
    APP_WORDPERFECT("application/vnd.wordperfect", "wpd"),
    APP_SUNDAHUS_WQ("application/vnd.wqd", "wqd"),
    APP_WORLDTALK("application/vnd.wt.stf", "stf"),
    APP_CORELXARA("application/vnd.xara", "xar"),
    APP_EXTENSIBLE_FORMS_DESCRIPTION_LANGUAGE("application/vnd.xfdl", "xfdl"),
    APP_HV_VOICE_DICTIONARY("application/vnd.yamaha.hv-dic", "hvd"),
    APP_HV_SCRIPT("application/vnd.yamaha.hv-script", "hvs"),
    APP_HV_VOICE_PARAMETER("application/vnd.yamaha.hv-voice", "hvp"),
    APP_OPEN_SCORE_FORMAT("application/vnd.yamaha.openscoreformat", "osf"),
    APP_OSFPVG("application/vnd.yamaha.openscoreformat.osfpvg+xml", "osfpvg"),
    APP_SMAF_AUDIO("application/vnd.yamaha.smaf-audio", "saf"),
    APP_SMAF_PHRASE("application/vnd.yamaha.smaf-phrase", "spf"),
    APP_CUSTOMMENU("application/vnd.yellowriver-custom-menu", "cmp"),
    APP_ZUL_GEOMETRY("application/vnd.zul", "zir"),
    APP_ZZAZZ_DECK("application/vnd.zzazz.deck+xml", "zaz"),
    APP_VOICEXML("application/voicexml+xml", "vxml"),
    APP_WIDGET_PACKAGING_AND_XML_CONFIGURATION("application/widget", "wgt"),
    APP_WINHELP("application/winhlp", "hlp"),
    APP_WSDL_WEB_SERVICES_DESCRIPTION_LANGUAGE("application/wsdl+xml", "wsdl"),
    APP_WEB_SERVICES_POLICY("application/wspolicy+xml", "wspolicy"),
    APP_7_ZIP("application/x-7z-compressed", "7z"),
    APP_ABIWORD("application/x-abiword", "abw"),
    APP_ACE_ARCHIVE("application/x-ace-compressed", "ace"),
    APP_APPLE_DISK_IMAGE("application/x-apple-diskimage", "dmg"),
    APP_ADOBE_AUTHORWARE_BINARY_FILE("application/x-authorware-bin", "aab"),
    APP_ADOBE_AUTHORWARE_MAP("application/x-authorware-map", "aam"),
    APP_ADOBE_AUTHORWARE_SEGMENT_FILE("application/x-authorware-seg", "aas"),
    APP_BINARY_CPIO_ARCHIVE("application/x-bcpio", "bcpio"),
    APP_BITTORRENT("application/x-bittorrent", "torrent"),
    APP_BZIP_ARCHIVE("application/x-bzip", "bz"),
    APP_BZIP2_ARCHIVE("application/x-bzip2", "bz2"),
    APP_CD_AUDIO("application/x-cdf", "cda"),
    APP_VIDEO_CD("application/x-cdlink", "vcd"),
    APP_PIRCH("application/x-chat", "chat"),
    APP_PORTABLE_GAME_NOTATION("application/x-chess-pgn", "pgn"),
    APP_CPIO_ARCHIVE("application/x-cpio", "cpio"),
    APP_C_SHELL_SCRIPT("application/x-csh", "csh"),
    APP_DEBIAN_PACKAGE("application/x-debian-package", "deb"),
    APP_ADOBE_SHOCKWAVE_PLAYER("application/x-director", "dir"),
    APP_DOOM_VIDEO_GAME("application/x-doom", "wad"),
    APP_NAVIGATION_CONTROL_FILE_FOR_XML("application/x-dtbncx+xml", "ncx"),
    APP_DIGITAL_TALKING_BOOK("application/x-dtbook+xml", "dtb"),
    APP_DIGITAL_TALKING_BOOK_RESOURCE_FILE("application/x-dtbresource+xml", "res"),
    APP_DEVICE_INDEPENDENT_FILE_FORMAT("application/x-dvi", "dvi"),
    APP_GLYPH_BITMAP_DISTRIBUTION_FORMAT("application/x-font-bdf", "bdf"),
    APP_GHOSTSCRIPT_FONT("application/x-font-ghostscript", "gsf"),
    APP_PSF_FONTS("application/x-font-linux-psf", "psf"),
    APP_OPENTYPE_FONT_FILE("application/x-font-otf", "otf"),
    APP_PORTABLE_COMPILED_FORMAT("application/x-font-pcf", "pcf"),
    APP_SERVER_NORMAL_FORMAT("application/x-font-snf", "snf"),
    APP_TRUETYPE_FONT("application/x-font-ttf", "ttf"),
    APP_POSTSCRIPT_FONTS("application/x-font-type1", "pfa"),
    APP_WEB_OPEN_FONT_FORMAT("application/x-font-woff", "woff"),
    APP_ARCHIVE_DOCUMENT_MULTIPLE_FILS_EMBEDDED("application/x-freearc", "arc"),
    APP_FUTURESPLASH_ANIMATOR("application/x-futuresplash", "spl"),
    APP_GNUMERIC("application/x-gnumeric", "gnumeric"),
    APP_GNU_TAR_FILES("application/x-gtar", "gtar"),
    APP_HIERARCHICAL_DATA_FORMAT("application/x-hdf", "hdf"),
    APP_JAVA_NETWORK_LAUNCHING_PROTOCOL("application/x-java-jnlp-file", "jnlp"),
    APP_LATEX("application/x-latex", "latex"),
    APP_MOBIPOCKET("application/x-mobipocket-ebook", "prc"),
    APP_MICROSOFT_CLICKONCE("application/x-ms-application", "application"),
    APP_MICROSOFT_WINDOWS_MEDIA_PLAYER_DOWNLOAD_PACKAGE("application/x-ms-wmd", "wmd"),
    APP_MICROSOFT_WINDOWS_MEDIA_PLAYER_SKIN_PACKAGE("application/x-ms-wmz", "wmz"),
    APP_MICROSOFT_XAML_BROWSER_APPLICATION("application/x-ms-xbap", "xbap"),
    APP_MICROSOFT_ACCESS("application/x-msaccess", "mdb"),
    APP_MICROSOFT_OFFICE_BINDER("application/x-msbinder", "obd"),
    APP_MICROSOFT_INFORMATION_CARD("application/x-mscardfile", "crd"),
    APP_MICROSOFT_CLIPBOARD_CLIP("application/x-msclip", "clp"),
    APP_MICROSOFT_APPLICATION("application/x-msdownload", "exe"),
    APP_MICROSOFT_MEDIAVIEW("application/x-msmediaview", "mvb"),
    APP_MICROSOFT_WINDOWS_METAFILE("application/x-msmetafile", "wmf"),
    APP_MICROSOFT_MONEY("application/x-msmoney", "mny"),
    APP_MICROSOFT_PUBLISHER("application/x-mspublisher", "pub"),
    APP_MICROSOFT_SCHEDULE("application/x-msschedule", "scd"),
    APP_MICROSOFT_WINDOWS_TERMINAL_SERVICES("application/x-msterminal", "trm"),
    APP_MICROSOFT_WORDPAD("application/x-mswrite", "wri"),
    APP_NETWORK_COMMON_DATA_FORM_NETCDF("application/x-netcdf", "nc"),
    APP_PKCS_12_PERSONAL_INFORMATION_EXCHANGE_SYNTAX_STANDARD("application/x-pkcs12", "p12"),
    APP_PKCS_7_CRYPTOGRAPHIC_MESSAGE_SYNTAX_STANDARD_CERTIFICATES(
        "application/x-pkcs7-certificates",
        "p7b"
    ),
    APP_PKCS_7_CRYPTOGRAPHIC_MESSAGE_SYNTAX_STANDARD_CERTIFICATE_REQUEST_RESPONSE(
        "application/x-pkcs7-certreqresp",
        "p7r"
    ),
    APP_RAR_ARCHIVE("application/x-rar-compressed", "rar"),
    APP_BOURNE_SHELL_SCRIPT("application/x-sh", "sh"),
    APP_SHELL_ARCHIVE("application/x-shar", "shar"),
    APP_ADOBE_FLASH("application/x-shockwave-flash", "swf"),
    APP_MICROSOFT_SILVERLIGHT("application/x-silverlight-app", "xap"),
    APP_STUFFIT_ARCHIVE_SIT("application/x-stuffit", "sit"),
    APP_STUFFIT_ARCHIVE_SITX("application/x-stuffitx", "sitx"),
    APP_SYSTEM_V_RELEASE_4_CPIO_ARCHIVE("application/x-sv4cpio", "sv4cpio"),
    APP_SYSTEM_V_RELEASE_4_CPIO_CHECKSUM_DATA("application/x-sv4crc", "sv4crc"),
    APP_TAR_FILE("application/x-tar", "tar"),
    APP_TCL_SCRIPT("application/x-tcl", "tcl"),
    APP_TEX("application/x-tex", "tex"),
    APP_TEX_FONT_METRIC("application/x-tex-tfm", "tfm"),
    APP_GNU_TEXINFO_DOCUMENT("application/x-texinfo", "texinfo"),
    APP_USTAR("application/x-ustar", "ustar"),
    APP_WAIS_SOURCE("application/x-wais-source", "src"),
    APP_X509_CERTIFICATE("application/x-x509-ca-cert", "der"),
    APP_XFIG("application/x-xfig", "fig"),
    APP_XPINSTALL_MOZILLA("application/x-xpinstall", "xpi"),
    APP_XML_CONFIGURATION_ACCESS_PROTOCOL_XCAP_DIFF("application/xcap-diff+xml", "xdf"),
    APP_XML_ENCRYPTION_SYNTAX_AND_PROCESSING("application/xenc+xml", "xenc"),
    APP_XHTML_THE_EXTENSIBLE_HYPERTEXT_MARKUP_LANGUAGE("application/xhtml+xml", "xhtml"),
    APP_XML_EXTENSIBLE_MARKUP_LANGUAGE("application/xml", "xml"),
    APP_DOCUMENT_TYPE_DEFINITION("application/xml-dtd", "dtd"),
    APP_XML_BINARY_OPTIMIZED_PACKAGING("application/xop+xml", "xop"),
    APP_XML_TRANSFORMATIONS("application/xslt+xml", "xslt"),
    APP_XSPF_XML_SHAREABLE_PLAYLIST_FORMAT("application/xspf+xml", "xspf"),
    APP_MXML("application/xv+xml", "mxml"),
    APP_YANG_DATA_MODELING_LANGUAGE("application/yang", "yang"),
    APP_YIN("application/yin+xml", "yin"),
    APP_ZIP_ARCHIVE("application/zip", "zip"),
    AUDIO_ADAPTIVE_DIFFERENTIAL_PULSE_CODE_MODULATION("audio/adpcm", "adp"),
    AUDIO_SUN_AUDIO_AU_FILE_FORMAT("audio/basic", "au"),
    AUDIO_MIDI("audio/midi", "midi"),
    AUDIO_MIDI_MUSICAL_INSTRUMENT_DIGITAL_INTERFACE("audio/midi", "mid"),
    AUDIO_MPEG_4_AUDIO("audio/mp4", "mp4a"),
    AUDIO_MPEG_AUDIO("audio/mpeg", "mpga"),
    AUDIO_OGG_AUDIO("audio/ogg", "oga"),
    AUDIO_OPUS_AUDIO("audio/opus", "opus"),
    AUDIO_DECE_AUDIO("audio/vnd.dece.audio", "uva"),
    AUDIO_DIGITAL_WINDS_MUSIC("audio/vnd.digital-winds", "eol"),
    AUDIO_DRA_AUDIO("audio/vnd.dra", "dra"),
    AUDIO_DTS_AUDIO("audio/vnd.dts", "dts"),
    AUDIO_DTS_HIGH_DEFINITION_AUDIO("audio/vnd.dts.hd", "dtshd"),
    AUDIO_LUCENT_VOICE("audio/vnd.lucent.voice", "lvp"),
    AUDIO_MICROSOFT_PLAYREADY_ECOSYSTEM("audio/vnd.ms-playready.media.pya", "pya"),
    AUDIO_NUERA_ECELP_4800("audio/vnd.nuera.ecelp4800", "ecelp4800"),
    AUDIO_NUERA_ECELP_7470("audio/vnd.nuera.ecelp7470", "ecelp7470"),
    AUDIO_NUERA_ECELP_9600("audio/vnd.nuera.ecelp9600", "ecelp9600"),
    AUDIO_HIT_MIX("audio/vnd.rip", "rip"),
    AUDIO_OPEN_WEB_MEDIA_PROJECT_AUDIO("audio/webm", "weba"),
    AUDIO_ADVANCED_AUDIO_CODING("audio/x-aac", "aac"),
    AUDIO_AUDIO_INTERCHANGE_FILE_FORMAT("audio/x-aiff", "aif"),
    AUDIO_M3U("audio/x-mpegurl", "m3u"),
    AUDIO_MICROSOFT_WINDOWS_MEDIA_AUDIO_REDIRECTOR("audio/x-ms-wax", "wax"),
    AUDIO_MICROSOFT_WINDOWS_MEDIA_AUDIO("audio/x-ms-wma", "wma"),
    AUDIO_REAL_AUDIO_SOUND_RAM("audio/x-pn-realaudio", "ram"),
    AUDIO_REAL_AUDIO_SOUND_RMP("audio/x-pn-realaudio-plugin", "rmp"),
    AUDIO_WAVEFORM_AUDIO_FILE_FORMAT("audio/x-wav", "wav"),
    IMAGE_AV1_IMAGE_FILE("image/avif", "avif"),
    IMAGE_BITMAP_IMAGE_FILE("image/bmp", "bmp"),
    IMAGE_COMPUTER_GRAPHICS_METAFILE("image/cgm", "cgm"),
    IMAGE_G3_FAX_IMAGE("image/g3fax", "g3"),
    IMAGE_GRAPHICS_INTERCHANGE_FORMAT("image/gif", "gif"),
    IMAGE_IMAGE_EXCHANGE_FORMAT("image/ief", "ief"),
    IMAGE_JPEG_IMAGE_JPEG("image/jpeg", "jpeg"),
    IMAGE_JPEG_IMAGE_JPG("image/jpeg", "jpg"),
    IMAGE_JPEG_IMAGE_PJPEG("image/pjpeg", "pjpeg"),
    IMAGE_JPEG_IMAGE_CITRIX("image/x-citrix-jpeg", "jpg"),
    IMAGE_OPENGL_TEXTURES("image/ktx", "ktx"),
    IMAGE_PORTABLE_NETWORK_GRAPHICS("image/png", "png"),
    IMAGE_PORTABLE_NETWORK_GRAPHICS_CITRIX("image/x-citrix-png", "png"),
    IMAGE_BTIF("image/prs.btif", "btif"),
    IMAGE_SCALABLE_VECTOR_GRAPHICS("image/svg+xml", "svg"),
    IMAGE_TAGGED_IMAGE_FILE_FORMAT("image/tiff", "tiff"),
    IMAGE_PHOTOSHOP_DOCUMENT("image/vnd.adobe.photoshop", "psd"),
    IMAGE_DECE_GRAPHIC("image/vnd.dece.graphic", "uvi"),
    IMAGE_DJVU("image/vnd.djvu", "djvu"),
    IMAGE_CLOSE_CAPTIONING_SUBTITLE("image/vnd.dvb.subtitle", "sub"),
    IMAGE_DWG_DRAWING("image/vnd.dwg", "dwg"),
    IMAGE_AUTOCAD_DXF("image/vnd.dxf", "dxf"),
    IMAGE_FASTBID_SHEET("image/vnd.fastbidsheet", "fbs"),
    IMAGE_FLASHPIX_FPX("image/vnd.fpx", "fpx"),
    IMAGE_FLASHPIX_NPX("image/vnd.net-fpx", "npx"),
    IMAGE_FAST_SEARCH_TRANSFER_ASA("image/vnd.fst", "fst"),
    IMAGE_EDMICS_2000_MMR("image/vnd.fujixerox.edmics-mmr", "mmr"),
    IMAGE_EDMICS_2000_RLC("image/vnd.fujixerox.edmics-rlc", "rlc"),
    IMAGE_MICROSOFT_DOCUMENT_IMAGING_FORMAT("image/vnd.ms-modi", "mdi"),
    IMAGE_WAP_BITAMP("image/vnd.wap.wbmp", "wbmp"),
    IMAGE_EXTENDED_IMAGE_FILE_FORMAT("image/vnd.xiff", "xif"),
    IMAGE_WEBP_IMAGE("image/webp", "webp"),
    IMAGE_CMU_IMAGE("image/x-cmu-raster", "ras"),
    IMAGE_COREL_METAFILE_EXCHANGE("image/x-cmx", "cmx"),
    IMAGE_FREEHAND_MX("image/x-freehand", "fh"),
    IMAGE_ICON_IMAGE("image/x-icon", "ico"),
    IMAGE_PCX_IMAGE("image/x-pcx", "pcx"),
    IMAGE_PICT_IMAGE("image/x-pict", "pic"),
    IMAGE_PORTABLE_NETWORK_GRAPHICS_X("image/x-png", "png"),
    IMAGE_PORTABLE_ANYMAP_IMAGE("image/x-portable-anymap", "pnm"),
    IMAGE_PORTABLE_BITMAP_FORMAT("image/x-portable-bitmap", "pbm"),
    IMAGE_PORTABLE_GRAYMAP_FORMAT("image/x-portable-graymap", "pgm"),
    IMAGE_PORTABLE_PIXMAP_FORMAT("image/x-portable-pixmap", "ppm"),
    IMAGE_SILICON_GRAPHICS_RGB_BITMAP("image/x-rgb", "rgb"),
    IMAGE_X_BITMAP("image/x-xbitmap", "xbm"),
    IMAGE_X_PIXMAP("image/x-xpixmap", "xpm"),
    IMAGE_X_WINDOW_DUMP("image/x-xwindowdump", "xwd"),
    MSG_EMAIL_MESSAGE("message/rfc822", "eml"),
    MODEL_INITIAL_GRAPHICS_EXCHANGE_SPECIFICATION("model/iges", "igs"),
    MODEL_MESH_DATA_TYPE("model/mesh", "msh"),
    MODEL_COLLADA("model/vnd.collada+xml", "dae"),
    MODEL_AUTODESK_DESIGN_WEB_FORMAT("model/vnd.dwf", "dwf"),
    MODEL_GEOMETRIC_DESCRIPTION_LANGUAGE("model/vnd.gdl", "gdl"),
    MODEL_GEN_TRIX_STUDIO("model/vnd.gtw", "gtw"),
    MODEL_VIRTUE_MTS("model/vnd.mts", "mts"),
    MODEL_VIRTUE_VTU("model/vnd.vtu", "vtu"),
    MODEL_VIRTUAL_REALITY_MODELING_LANGUAGE("model/vrml", "wrl"),
    TEXT_ICALENDAR("text/calendar", "ics"),
    TEXT_CASCADING_STYLE_SHEETS("text/css", "css"),
    TEXT_COMMA_SEPERATED_VALUES("text/csv", "csv"),
    TEXT_HYPERTEXT_MARKUP_LANGUAGE("text/html", "html"),
    TEXT_JAVASCRIPT_MODULE_MJS("text/javascript", "mjs"),
    TEXT_NOTATION3("text/n3", "n3"),
    TEXT_TEXT_FILE("text/plain", "txt"),
    TEXT_BAS_PARTITUR_FORMAT("text/plain-bas", "par"),
    TEXT_PRS_LINES_TAG("text/prs.lines.tag", "dsc"),
    TEXT_RICH_TEXT_FORMAT("text/richtext", "rtx"),
    TEXT_STANDARD_GENERALIZED_MARKUP_LANGUAGE("text/sgml", "sgml"),
    TEXT_TAB_SEPERATED_VALUES("text/tab-separated-values", "tsv"),
    TEXT_TROFF("text/troff", "t"),
    TEXT_TURTLE("text/turtle", "ttl"),
    TEXT_URI_RESOLUTION_SERVICES("text/uri-list", "uri"),
    TEXT_CURL_APPLET("text/vnd.curl", "curl"),
    TEXT_CURL_DETACHED_APPLET("text/vnd.curl.dcurl", "dcurl"),
    TEXT_CURL_MANIFEST_FILE("text/vnd.curl.mcurl", "mcurl"),
    TEXT_CURL_SOURCE_CODE("text/vnd.curl.scurl", "scurl"),
    TEXT_MOD_FLY_FLY_CGI("text/vnd.fly", "fly"),
    TEXT_FLEXSTOR("text/vnd.fmi.flexstor", "flx"),
    TEXT_GRAPHVIZ("text/vnd.graphviz", "gv"),
    TEXT_IN3D_3DML("text/vnd.in3d.3dml", "3dml"),
    TEXT_IN3D_3DML_SPOT("text/vnd.in3d.spot", "spot"),
    TEXT_J2ME_APP_DESCRIPTOR("text/vnd.sun.j2me.app-descriptor", "jad"),
    TEXT_WIRELESS_MARKUP_LANGUAGE("text/vnd.wap.wml", "wml"),
    TEXT_WIRELESS_MARKUP_LANGUAGE_SCRIPT("text/vnd.wap.wmlscript", "wmls"),
    TEXT_ASSEMBLER_SOURCE_FILE("text/x-asm", "s"),
    TEXT_C_SOURCE_FILE("text/x-c", "c"),
    TEXT_FORTRAN_SOURCE_FILE("text/x-fortran", "f"),
    TEXT_JAVA_SOURCE_FILE("text/x-java-source,java", "java"),
    TEXT_PASCAL_SOURCE_FILE("text/x-pascal", "p"),
    TEXT_SETEXT("text/x-setext", "etx"),
    TEXT_UUENCODE("text/x-uuencode", "uu"),
    TEXT_VCALENDAR("text/x-vcalendar", "vcs"),
    TEXT_VCARD("text/x-vcard", "vcf"),
    TEXT_YAML_AINT_MARKUP_LANGUAGE_YET_ANOTHER_MARKUP_LANGUAGE("text/yaml", "yaml"),
    VIDEO_3GP("video/3gpp", "3gp"),
    VIDEO_3GP2("video/3gpp2", "3g2"),
    VIDEO_H261("video/h261", "h261"),
    VIDEO_H263("video/h263", "h263"),
    VIDEO_H264("video/h264", "h264"),
    VIDEO_JPGVIDEO("video/jpeg", "jpgv"),
    VIDEO_JPEG_2000_COMPOUND_IMAGE_FILE_FORMAT("video/jpm", "jpm"),
    VIDEO_MOTION_JPEG_2000("video/mj2", "mj2"),
    VIDEO_MPEG_TRANSPORT_STREAM("video/mp2t", "ts"),
    VIDEO_MPEG_4_VIDEO("video/mp4", "mp4"),
    VIDEO_MPEG_VIDEO("video/mpeg", "mpeg"),
    VIDEO_OGG_VIDEO("video/ogg", "ogv"),
    VIDEO_QUICKTIME_VIDEO("video/quicktime", "qt"),
    VIDEO_DECE_HIGH_DEFINITION_VIDEO("video/vnd.dece.hd", "uvh"),
    VIDEO_DECE_MOBILE_VIDEO("video/vnd.dece.mobile", "uvm"),
    VIDEO_DECE_PD_VIDEO("video/vnd.dece.pd", "uvp"),
    VIDEO_DECE_SD_VIDEO("video/vnd.dece.sd", "uvs"),
    VIDEO_DECE_VIDEO("video/vnd.dece.video", "uvv"),
    VIDEO_FAST_SEARCH_TRANSFER_ASA("video/vnd.fvt", "fvt"),
    VIDEO_MPEG_URL("video/vnd.mpegurl", "mxu"),
    VIDEO_MICROSOFT_PLAYREADY_ECOSYSTEM_VIDEO("video/vnd.ms-playready.media.pyv", "pyv"),
    VIDEO_DECE_MP4("video/vnd.uvvu.mp4", "uvu"),
    VIDEO_VIVO("video/vnd.vivo", "viv"),
    VIDEO_OPEN_WEB_MEDIA_PROJECT_VIDEO("video/webm", "webm"),
    VIDEO_FLASH_VIDEO_F4V("video/x-f4v", "f4v"),
    VIDEO_FLASH_VIDEO_FLV("video/x-flv", "flv"),
    VIDEO_FLI_FLC_ANIMATION_FORMAT("video/x-fli", "fli"),
    VIDEO_M4V("video/x-m4v", "m4v"),
    VIDEO_MICROSOFT_ADVANCED_SYSTEMS_FORMAT("video/x-ms-asf", "asf"),
    VIDEO_MICROSOFT_WINDOWS_MEDIA("video/x-ms-wm", "wm"),
    VIDEO_MICROSOFT_WINDOWS_MEDIA_VIDEO("video/x-ms-wmv", "wmv"),
    VIDEO_MICROSOFT_WINDOWS_MEDIA_AUDIO_VIDEO_PLAYLIST("video/x-ms-wmx", "wmx"),
    VIDEO_MICROSOFT_WINDOWS_MEDIA_VIDEO_PLAYLIST("video/x-ms-wvx", "wvx"),
    VIDEO_AUDIO_VIDEO_INTERLEAVE("video/x-msvideo", "avi"),
    VIDEO_SGI_MOVIE("video/x-sgi-movie", "movie");

    companion object {

        /**
         * Get the [FileMimeType] from the type
         *
         * @param mimeType The type of the file
         * @return The [FileMimeType] or null if not found
         */
        fun fromType(mimeType: String): FileMimeType? {
            return entries.find { it.type == mimeType }
        }

        /**
         * Get the [FileMimeType] from the extension
         *
         * @param extension The extension of the file
         * @return The [FileMimeType] or null if not found
         */
        fun fromExtension(extension: String): FileMimeType? {
            val extensionPrepared = extension.removePrefix(".")
            return entries.find { it.extension == extensionPrepared }
        }

    }
}


object FileMimeTypeGroup {

    val IMAGES_PNG = listOf(
        FileMimeType.IMAGE_PORTABLE_NETWORK_GRAPHICS,
        FileMimeType.IMAGE_PORTABLE_NETWORK_GRAPHICS_CITRIX,
        FileMimeType.IMAGE_PORTABLE_NETWORK_GRAPHICS_X
    )

    val IMAGES_JPEG = listOf(
        FileMimeType.IMAGE_JPEG_IMAGE_JPEG,
        FileMimeType.IMAGE_JPEG_IMAGE_JPG,
        FileMimeType.IMAGE_JPEG_IMAGE_PJPEG,
        FileMimeType.IMAGE_JPEG_IMAGE_CITRIX
    )
}