/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.database;

import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.TransactionWithoutReturn;
import app.cash.sqldelight.db.SqlDriver;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apptank.horus.client.control.SyncControl;
import org.apptank.horus.client.control.helper.ISyncFileDatabaseHelper;
import org.apptank.horus.client.control.scheme.SyncFileTable;
import org.apptank.horus.client.database.SQLiteHelper;
import org.apptank.horus.client.database.builder.QueryBuilder;
import org.apptank.horus.client.database.builder.SimpleQueryBuilder;
import org.apptank.horus.client.database.struct.Cursor;
import org.apptank.horus.client.database.struct.SQL;
import org.apptank.horus.client.extensions.FunctionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u00020\u00102\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\u00020\r*\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/apptank/horus/client/database/SyncFileDatabaseHelper;", "Lorg/apptank/horus/client/database/SQLiteHelper;", "Lorg/apptank/horus/client/control/helper/ISyncFileDatabaseHelper;", "databaseName", "", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "<init>", "(Ljava/lang/String;Lapp/cash/sqldelight/db/SqlDriver;)V", "insert", "", "files", "", "Lorg/apptank/horus/client/control/SyncControl$File;", "([Lorg/apptank/horus/client/control/SyncControl$File;)V", "update", "", "([Lorg/apptank/horus/client/control/SyncControl$File;)Z", "delete", "search", "reference", "", "searchBatch", "", "references", "queryByStatus", "status", "Lorg/apptank/horus/client/control/SyncControl$FileStatus;", "parseToFile", "Lorg/apptank/horus/client/database/struct/Cursor;", "client_release"})
@SourceDebugExtension(value={"SMAP\nSyncFileDatabaseHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncFileDatabaseHelper.kt\norg/apptank/horus/client/database/SyncFileDatabaseHelper\n+ 2 DatabaseExtension.kt\norg/apptank/horus/client/extensions/DatabaseExtensionKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,189:1\n67#2,5:190\n67#2,5:195\n13409#3,2:200\n13409#3,2:202\n13409#3,2:204\n*S KotlinDebug\n*F\n+ 1 SyncFileDatabaseHelper.kt\norg/apptank/horus/client/database/SyncFileDatabaseHelper\n*L\n48#1:190,5\n86#1:195,5\n32#1:200,2\n51#1:202,2\n89#1:204,2\n*E\n"})
public final class SyncFileDatabaseHelper
extends SQLiteHelper
implements ISyncFileDatabaseHelper {
    public SyncFileDatabaseHelper(@NotNull String databaseName, @NotNull SqlDriver driver2) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        super(driver2, databaseName);
    }

    @Override
    public void insert(SyncControl.File ... files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Transacter.DefaultImpls.transaction$default((Transacter)((Transacter)this), (boolean)false, arg_0 -> SyncFileDatabaseHelper.insert$lambda$1(files, this, arg_0), (int)1, null);
    }

    @Override
    public boolean update(SyncControl.File ... files) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            Object $this$update_u24lambda_u246_u24lambda_u244;
            boolean bl = false;
            SqlDriver $this$update_u24lambda_u246 = $this$handle$iv;
            boolean bl2 = false;
            SqlDriver sqlDriver = $this$update_u24lambda_u246;
            try {
                $this$update_u24lambda_u246_u24lambda_u244 = sqlDriver;
                boolean bl3 = false;
                Transacter.DefaultImpls.transaction$default((Transacter)((Transacter)this), (boolean)false, arg_0 -> SyncFileDatabaseHelper.update$lambda$6$lambda$4$lambda$3(files, this, arg_0), (int)1, null);
                $this$update_u24lambda_u246_u24lambda_u244 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl3) {
                $this$update_u24lambda_u246_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            sqlDriver = $this$update_u24lambda_u246_u24lambda_u244;
            Throwable throwable = Result.exceptionOrNull-impl((Object)sqlDriver);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl4 = false;
                return false;
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl = false;
            FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
            throw it$iv;
        }
        return true;
    }

    @Override
    public boolean delete(SyncControl.File ... files) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            Object $this$delete_u24lambda_u2411_u24lambda_u249;
            boolean bl = false;
            SqlDriver $this$delete_u24lambda_u2411 = $this$handle$iv;
            boolean bl2 = false;
            SqlDriver sqlDriver = $this$delete_u24lambda_u2411;
            try {
                $this$delete_u24lambda_u2411_u24lambda_u249 = sqlDriver;
                boolean bl3 = false;
                Transacter.DefaultImpls.transaction$default((Transacter)((Transacter)this), (boolean)false, arg_0 -> SyncFileDatabaseHelper.delete$lambda$11$lambda$9$lambda$8(files, this, arg_0), (int)1, null);
                $this$delete_u24lambda_u2411_u24lambda_u249 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl3) {
                $this$delete_u24lambda_u2411_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            sqlDriver = $this$delete_u24lambda_u2411_u24lambda_u249;
            Throwable throwable = Result.exceptionOrNull-impl((Object)sqlDriver);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl4 = false;
                return false;
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl = false;
            FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
            throw it$iv;
        }
        return true;
    }

    @Override
    @Nullable
    public SyncControl.File search(@NotNull CharSequence reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("reference", reference), null, 2, null)};
        QueryBuilder query = QueryBuilder.where$default(new SimpleQueryBuilder("horus_sync_files"), whereConditionArray, null, 2, null);
        List result = this.queryResult$client_release(query.build(), arg_0 -> SyncFileDatabaseHelper.search$lambda$12(this, arg_0));
        return (SyncControl.File)CollectionsKt.firstOrNull(result);
    }

    @Override
    @NotNull
    public List<SyncControl.File> searchBatch(@NotNull List<? extends CharSequence> references) {
        Intrinsics.checkNotNullParameter(references, (String)"references");
        QueryBuilder query = QueryBuilder.whereIn$default(new SimpleQueryBuilder("horus_sync_files"), "reference", references, null, 4, null);
        return this.queryResult$client_release(query.build(), arg_0 -> SyncFileDatabaseHelper.searchBatch$lambda$13(this, arg_0));
    }

    @Override
    @NotNull
    public List<SyncControl.File> queryByStatus(@NotNull SyncControl.FileStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("status", status.getId()), null, 2, null)};
        QueryBuilder query = QueryBuilder.where$default(new SimpleQueryBuilder("horus_sync_files"), whereConditionArray, null, 2, null);
        return this.queryResult$client_release(query.build(), arg_0 -> SyncFileDatabaseHelper.queryByStatus$lambda$14(this, arg_0));
    }

    private final SyncControl.File parseToFile(Cursor $this$parseToFile) {
        return new SyncControl.File((CharSequence)$this$parseToFile.getValue("reference"), SyncControl.FileType.Companion.fromId(((Number)$this$parseToFile.getValue("type")).intValue()), SyncControl.FileStatus.Companion.fromId(((Number)$this$parseToFile.getValue("status")).intValue()), (String)$this$parseToFile.getValue("mime_type"), (String)$this$parseToFile.getValueOrNull("url_local"), (String)$this$parseToFile.getValueOrNull("url_remote"));
    }

    private static final Unit insert$lambda$1(SyncControl.File[] $files, SyncFileDatabaseHelper this$0, TransactionWithoutReturn $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        SyncControl.File[] $this$forEach$iv = $files;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            SyncControl.File element$iv;
            SyncControl.File file = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this$0.insertOrThrow("horus_sync_files", SyncFileTable.INSTANCE.mapToCreate(file));
        }
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$6$lambda$4$lambda$3(SyncControl.File[] $files, SyncFileDatabaseHelper this$0, TransactionWithoutReturn $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        SyncControl.File[] $this$forEach$iv = $files;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            SyncControl.File element$iv;
            SyncControl.File file = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String whereClause = SQLiteHelper.buildWhereEvaluation$default(this$0, CollectionsKt.listOf((Object)new SQL.WhereCondition(new SQL.ColumnValue("reference", file.getReference()), null, 2, null)), null, 2, null);
            boolean result = this$0.isOperationIsSuccessful(this$0.update("horus_sync_files", SyncFileTable.INSTANCE.mapToCreate(file), whereClause));
            if (result) continue;
            throw new IllegalStateException("Update operation failed");
        }
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$11$lambda$9$lambda$8(SyncControl.File[] $files, SyncFileDatabaseHelper this$0, TransactionWithoutReturn $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        SyncControl.File[] $this$forEach$iv = $files;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            SyncControl.File element$iv;
            SyncControl.File file = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String whereClause = SQLiteHelper.buildWhereEvaluation$default(this$0, CollectionsKt.listOf((Object)new SQL.WhereCondition(new SQL.ColumnValue("reference", file.getReference()), null, 2, null)), null, 2, null);
            boolean result = this$0.isOperationIsSuccessful(this$0.delete("horus_sync_files", whereClause));
            if (result) continue;
            throw new IllegalStateException("Delete operation failed");
        }
        return Unit.INSTANCE;
    }

    private static final SyncControl.File search$lambda$12(SyncFileDatabaseHelper this$0, Cursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.parseToFile(it);
    }

    private static final SyncControl.File searchBatch$lambda$13(SyncFileDatabaseHelper this$0, Cursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.parseToFile(it);
    }

    private static final SyncControl.File queryByStatus$lambda$14(SyncFileDatabaseHelper this$0, Cursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.parseToFile(it);
    }
}

