/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.tasks;

import app.cash.sqldelight.db.AfterVersion;
import app.cash.sqldelight.db.SqlDriver;
import com.russhwolf.settings.Settings;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apptank.horus.client.database.HorusDatabase;
import org.apptank.horus.client.di.IDatabaseDriverFactory;
import org.apptank.horus.client.migration.domain.EntityScheme;
import org.apptank.horus.client.migration.domain.EntitySchemeKt;
import org.apptank.horus.client.tasks.BaseTask;
import org.apptank.horus.client.tasks.RetrieveDatabaseSchemeTask;
import org.apptank.horus.client.tasks.TaskResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/apptank/horus/client/tasks/ValidateMigrationLocalDatabaseTask;", "Lorg/apptank/horus/client/tasks/BaseTask;", "settings", "Lcom/russhwolf/settings/Settings;", "databaseDriverFactory", "Lorg/apptank/horus/client/di/IDatabaseDriverFactory;", "dependsOnTask", "Lorg/apptank/horus/client/tasks/RetrieveDatabaseSchemeTask;", "<init>", "(Lcom/russhwolf/settings/Settings;Lorg/apptank/horus/client/di/IDatabaseDriverFactory;Lorg/apptank/horus/client/tasks/RetrieveDatabaseSchemeTask;)V", "execute", "Lorg/apptank/horus/client/tasks/TaskResult;", "previousDataTask", "", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDatabaseSchema", "Lorg/apptank/horus/client/database/HorusDatabase$Schema;", "getLastVersion", "", "entities", "", "Lorg/apptank/horus/client/migration/domain/EntityScheme;", "getCurrentSchemaVersion", "()Ljava/lang/Long;", "setSchemaVersion", "", "version", "Companion", "client_release"})
public final class ValidateMigrationLocalDatabaseTask
extends BaseTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final IDatabaseDriverFactory databaseDriverFactory;
    @NotNull
    public static final String SCHEMA_VERSION_KEY = "horus_db_schema_version";

    public ValidateMigrationLocalDatabaseTask(@NotNull Settings settings, @NotNull IDatabaseDriverFactory databaseDriverFactory, @NotNull RetrieveDatabaseSchemeTask dependsOnTask) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)databaseDriverFactory, (String)"databaseDriverFactory");
        Intrinsics.checkNotNullParameter((Object)dependsOnTask, (String)"dependsOnTask");
        super(dependsOnTask);
        this.settings = settings;
        this.databaseDriverFactory = databaseDriverFactory;
    }

    @Override
    @Nullable
    public Object execute(@Nullable Object previousDataTask, @NotNull Continuation<? super TaskResult> $completion) {
        HorusDatabase.Schema schema = this.getDatabaseSchema();
        List list = previousDataTask instanceof List ? (List)previousDataTask : null;
        if (list == null) {
            return TaskResult.Companion.failure(new Exception("Invalid data"));
        }
        List data = list;
        Object object = this;
        try {
            ValidateMigrationLocalDatabaseTask $this$execute_u24lambda_u241 = object;
            boolean bl = false;
            long lastVersion = $this$execute_u24lambda_u241.getLastVersion(data);
            Long schemaVersion = $this$execute_u24lambda_u241.getCurrentSchemaVersion();
            if (schemaVersion == null) {
                schema.create-kCoHEHE($this$execute_u24lambda_u241.databaseDriverFactory.getDriver(), data);
                $this$execute_u24lambda_u241.setSchemaVersion(schema.getVersion());
                return TaskResult.Companion.success$default(TaskResult.Companion, null, 1, null);
            }
            if (lastVersion > schemaVersion) {
                AfterVersion[] afterVersionArray = new AfterVersion[]{new AfterVersion(lastVersion, arg_0 -> ValidateMigrationLocalDatabaseTask.execute$lambda$1$lambda$0($this$execute_u24lambda_u241, lastVersion, arg_0))};
                schema.migrate-zeHU3Mk($this$execute_u24lambda_u241.databaseDriverFactory.getDriver(), schemaVersion, lastVersion, afterVersionArray);
                return TaskResult.Companion.success$default(TaskResult.Companion, null, 1, null);
            }
            return TaskResult.Companion.success$default(TaskResult.Companion, null, 1, null);
        }
        catch (Throwable bl) {
            Object object2;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                object2 = object;
            } else {
                Throwable it = throwable;
                boolean bl2 = false;
                object2 = TaskResult.Companion.failure(it);
            }
            return object2;
        }
    }

    private final HorusDatabase.Schema getDatabaseSchema() {
        return this.databaseDriverFactory.getSchema();
    }

    private final long getLastVersion(List<EntityScheme> entities) {
        return EntitySchemeKt.getLastVersion(entities);
    }

    private final Long getCurrentSchemaVersion() {
        return this.settings.getLongOrNull(SCHEMA_VERSION_KEY);
    }

    private final void setSchemaVersion(long version) {
        this.settings.putLong(SCHEMA_VERSION_KEY, version);
    }

    private static final Unit execute$lambda$1$lambda$0(ValidateMigrationLocalDatabaseTask $this_runCatching, long $lastVersion, SqlDriver it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_runCatching.setSchemaVersion($lastVersion);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apptank/horus/client/tasks/ValidateMigrationLocalDatabaseTask$Companion;", "", "<init>", "()V", "SCHEMA_VERSION_KEY", "", "client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

