/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.database;

import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.modules.SerializersModule;
import org.apptank.horus.client.control.QueueActionsTable;
import org.apptank.horus.client.control.SyncControl;
import org.apptank.horus.client.control.helper.ISyncControlDatabaseHelper;
import org.apptank.horus.client.control.scheme.SyncControlTable;
import org.apptank.horus.client.data.Horus;
import org.apptank.horus.client.data.InternalModel;
import org.apptank.horus.client.database.SQLiteHelper;
import org.apptank.horus.client.database.builder.QueryBuilder;
import org.apptank.horus.client.database.builder.SimpleQueryBuilder;
import org.apptank.horus.client.database.struct.Column;
import org.apptank.horus.client.database.struct.Cursor;
import org.apptank.horus.client.database.struct.SQL;
import org.apptank.horus.client.eventbus.Event;
import org.apptank.horus.client.eventbus.EventBus;
import org.apptank.horus.client.eventbus.EventType;
import org.apptank.horus.client.extensions.DatabaseExtensionKt;
import org.apptank.horus.client.extensions.FunctionsKt;
import org.apptank.horus.client.migration.domain.AttributeType;
import org.apptank.horus.client.serialization.AnySerializer;
import org.apptank.horus.client.utils.SystemTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016J0\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016J\u001e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0016H\u0016J\u0016\u0010\u001d\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0016H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u001cH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u000b\u001a\u00020&H\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020&H\u0016J\u0010\u0010)\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u0004H\u0016J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0002JA\u0010-\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/2'\u00100\u001a#\u0012\u0004\u0012\u00020\u0004\u0012\u0015\u0012\u0013\u0018\u000102\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\t0501j\u0002`6H\u0002J\u0010\u00107\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u00108\u001a\u00020\u0010H\u0002JA\u00109\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042'\u0010:\u001a#\u0012\u0004\u0012\u00020\u0004\u0012\u0015\u0012\u0013\u0018\u000102\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\t0501j\u0002`6H\u0002JA\u0010;\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042'\u0010:\u001a#\u0012\u0004\u0012\u00020\u0004\u0012\u0015\u0012\u0013\u0018\u000102\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\t0501j\u0002`6H\u0002J\u0018\u0010<\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a8\u0006="}, d2={"Lorg/apptank/horus/client/database/SyncControlDatabaseHelper;", "Lorg/apptank/horus/client/database/SQLiteHelper;", "Lorg/apptank/horus/client/control/helper/ISyncControlDatabaseHelper;", "databaseName", "", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "<init>", "(Ljava/lang/String;Lapp/cash/sqldelight/db/SqlDriver;)V", "isStatusCompleted", "", "type", "Lorg/apptank/horus/client/control/SyncControl$OperationType;", "getLastDatetimeCheckpoint", "", "addSyncTypeStatus", "", "status", "Lorg/apptank/horus/client/control/SyncControl$Status;", "addActionInsert", "entity", "attributes", "", "Lorg/apptank/horus/client/data/Horus$Attribute;", "addActionUpdate", "id", "addActionDelete", "getPendingActions", "Lorg/apptank/horus/client/control/SyncControl$Action;", "completeActions", "actionIds", "", "getLastActionCompleted", "getCompletedActionsAfterDatetime", "datetime", "getEntityNames", "getWritableEntityNames", "getEntitiesWithAttributeType", "Lorg/apptank/horus/client/migration/domain/AttributeType;", "getEntityAttributesWithType", "entityName", "isEntityCanBeWritable", "createSyncActionFromCursor", "cursor", "Lorg/apptank/horus/client/database/struct/Cursor;", "addAction", "actionType", "Lorg/apptank/horus/client/control/SyncControl$ActionType;", "dataJSON", "", "", "Lkotlinx/serialization/Serializable;", "with", "Lorg/apptank/horus/client/serialization/AnySerializer;", "Lorg/apptank/horus/client/base/DataMap;", "validateIfEntityExists", "emitEventActionCreated", "emitEntityCreated", "data", "emitEntityUpdated", "emitEntityDeleted", "client_release"})
@SourceDebugExtension(value={"SMAP\nSyncControlDatabaseHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncControlDatabaseHelper.kt\norg/apptank/horus/client/database/SyncControlDatabaseHelper\n+ 2 DatabaseExtension.kt\norg/apptank/horus/client/extensions/DatabaseExtensionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 QueueActionsTable.kt\norg/apptank/horus/client/control/QueueActionsTable\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,421:1\n67#2,2:422\n69#2,3:427\n67#2,5:430\n67#2,5:435\n67#2,5:454\n67#2,5:459\n67#2,5:464\n67#2,5:469\n67#2,2:504\n69#2,3:519\n1755#3,3:424\n1187#3,2:440\n1261#3,4:442\n230#3,2:446\n1187#3,2:448\n1261#3,4:450\n1557#3:474\n1628#3,3:475\n827#3:478\n855#3,2:479\n774#3:481\n865#3,2:482\n1557#3:484\n1628#3,3:485\n827#3:488\n855#3,2:489\n774#3:491\n865#3,2:492\n1557#3:494\n1628#3,3:495\n774#3:498\n865#3,2:499\n1755#3,3:501\n50#4,3:506\n53#4,2:510\n49#4,7:512\n113#5:509\n1#6:522\n*S KotlinDebug\n*F\n+ 1 SyncControlDatabaseHelper.kt\norg/apptank/horus/client/database/SyncControlDatabaseHelper\n*L\n48#1:422,2\n48#1:427,3\n62#1:430,5\n95#1:435,5\n175#1:454,5\n197#1:459,5\n216#1:464,5\n238#1:469,5\n355#1:504,2\n355#1:519,3\n52#1:424,3\n112#1:440,2\n112#1:442,4\n122#1:446,2\n141#1:448,2\n141#1:450,4\n265#1:474\n265#1:475,3\n266#1:478\n266#1:479,2\n275#1:481\n275#1:482,2\n275#1:484\n275#1:485,3\n276#1:488\n276#1:489,2\n312#1:491\n312#1:492,2\n312#1:494\n312#1:495,3\n322#1:498\n322#1:499,2\n322#1:501,3\n358#1:506,3\n358#1:510,2\n358#1:512,7\n358#1:509\n*E\n"})
public final class SyncControlDatabaseHelper
extends SQLiteHelper
implements ISyncControlDatabaseHelper {
    public SyncControlDatabaseHelper(@NotNull String databaseName, @NotNull SqlDriver driver2) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        super(driver2, databaseName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isStatusCompleted(@NotNull SyncControl.OperationType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            boolean bl;
            block6: {
                void $this$any$iv;
                boolean bl2 = false;
                SqlDriver $this$isStatusCompleted_u24lambda_u242 = $this$handle$iv;
                boolean bl3 = false;
                Iterable iterable = this.rawQuery("SELECT EXISTS(SELECT 1 FROM horus_sync_control WHERE type = " + type.getId() + " AND status = " + SyncControl.Status.COMPLETED.getId() + " LIMIT 1)", SyncControlDatabaseHelper::isStatusCompleted$lambda$2$lambda$0);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean it = (Boolean)element$iv;
                        boolean bl4 = false;
                        if (!it) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable it$iv = throwable2;
                boolean bl = false;
                FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
                throw it$iv;
            }
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public long getLastDatetimeCheckpoint() {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            SimpleQueryBuilder simpleQueryBuilder;
            boolean bl = false;
            SqlDriver $this$getLastDatetimeCheckpoint_u24lambda_u245 = $this$handle$iv;
            boolean bl2 = false;
            SimpleQueryBuilder $this$getLastDatetimeCheckpoint_u24lambda_u245_u24lambda_u243 = simpleQueryBuilder = new SimpleQueryBuilder("horus_sync_control");
            boolean bl3 = false;
            Object[] objectArray = new String[]{"datetime"};
            $this$getLastDatetimeCheckpoint_u24lambda_u245_u24lambda_u243.select((String[])objectArray);
            objectArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("type", SyncControl.OperationType.CHECKPOINT.getId()), null, 2, null)};
            QueryBuilder.where$default($this$getLastDatetimeCheckpoint_u24lambda_u245_u24lambda_u243, (SQL.WhereCondition[])objectArray, null, 2, null);
            objectArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("status", SyncControl.Status.COMPLETED.getId()), null, 2, null)};
            QueryBuilder.where$default($this$getLastDatetimeCheckpoint_u24lambda_u245_u24lambda_u243, (SQL.WhereCondition[])objectArray, null, 2, null);
            $this$getLastDatetimeCheckpoint_u24lambda_u245_u24lambda_u243.orderBy("id", SQL.OrderBy.DESC);
            $this$getLastDatetimeCheckpoint_u24lambda_u245_u24lambda_u243.limit(1);
            SimpleQueryBuilder query = simpleQueryBuilder;
            Long l = (Long)CollectionsKt.firstOrNull(this.rawQuery(query.build(), SyncControlDatabaseHelper::getLastDatetimeCheckpoint$lambda$5$lambda$4));
            return l != null ? l : 0L;
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable it$iv = throwable2;
                boolean bl = false;
                FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
                throw it$iv;
            }
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public void addSyncTypeStatus(@NotNull SyncControl.OperationType type, @NotNull SyncControl.Status status) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            boolean bl = false;
            SqlDriver $this$addSyncTypeStatus_u24lambda_u246 = $this$handle$iv;
            boolean bl2 = false;
            this.insertOrThrow("horus_sync_control", SyncControlTable.INSTANCE.mapToCreate(type, status));
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl = false;
            FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
            throw it$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addActionInsert(@NotNull String entity, @NotNull List<? extends Horus.Attribute<?>> attributes) {
        Object element$iv2;
        SyncControlDatabaseHelper syncControlDatabaseHelper;
        String string;
        Map data;
        block2: {
            void $this$first$iv;
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.validateIfEntityExists(entity);
            Iterable $this$associate$iv = attributes;
            boolean $i$f$associate22 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Horus.Attribute it = (Horus.Attribute)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getName(), it.getValue());
                map.put(pair.getFirst(), pair.getSecond());
            }
            data = destination$iv$iv;
            this.addAction(entity, SyncControl.ActionType.INSERT, data);
            Iterable $i$f$associate22 = attributes;
            string = entity;
            syncControlDatabaseHelper = this;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Horus.Attribute it = (Horus.Attribute)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"id")) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object e = element$iv2;
        Object t = ((Horus.Attribute)e).getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.String");
        syncControlDatabaseHelper.emitEntityCreated(string, (String)t, data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addActionUpdate(@NotNull String entity, @NotNull Horus.Attribute<String> id, @NotNull List<? extends Horus.Attribute<?>> attributes) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.validateIfEntityExists(entity);
        Iterable $this$associate$iv = attributes;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Horus.Attribute it = (Horus.Attribute)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map data = destination$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)id.getValue()), TuplesKt.to((Object)"attributes", (Object)data)};
        this.addAction(entity, SyncControl.ActionType.UPDATE, MapsKt.mapOf((Pair[])pairArray));
        this.emitEntityUpdated(entity, id.getValue(), data);
    }

    @Override
    public void addActionDelete(@NotNull String entity, @NotNull Horus.Attribute<String> id) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        this.validateIfEntityExists(entity);
        this.addAction(entity, SyncControl.ActionType.DELETE, MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)id.getValue())));
        this.emitEntityDeleted(entity, id.getValue());
    }

    @Override
    @NotNull
    public List<SyncControl.Action> getPendingActions() {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            boolean bl = false;
            SqlDriver $this$getPendingActions_u24lambda_u2411 = $this$handle$iv;
            boolean bl2 = false;
            SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("status", SyncControl.ActionStatus.PENDING.getId()), null, 2, null)};
            String sqlSentence = QueryBuilder.orderBy$default(QueryBuilder.where$default(new SimpleQueryBuilder("horus_queue_actions"), whereConditionArray, null, 2, null), "datetime", null, 2, null).build();
            return this.queryResult$client_release(sqlSentence, arg_0 -> SyncControlDatabaseHelper.getPendingActions$lambda$11$lambda$10(this, arg_0));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable it$iv = throwable2;
                boolean bl = false;
                FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
                throw it$iv;
            }
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public boolean completeActions(@NotNull List<Integer> actionIds) {
        Intrinsics.checkNotNullParameter(actionIds, (String)"actionIds");
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            boolean bl = false;
            SqlDriver $this$completeActions_u24lambda_u2412 = $this$handle$iv;
            boolean bl2 = false;
            Map values = MapsKt.mapOf((Pair)TuplesKt.to((Object)"status", (Object)SyncControl.ActionStatus.COMPLETED.getId()));
            String whereClause = "id IN (" + CollectionsKt.joinToString$default((Iterable)actionIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
            return this.update("horus_queue_actions", values, whereClause) == (long)actionIds.size();
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable it$iv = throwable2;
                boolean bl = false;
                FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
                throw it$iv;
            }
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @Nullable
    public SyncControl.Action getLastActionCompleted() {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            boolean bl = false;
            SqlDriver $this$getLastActionCompleted_u24lambda_u2414 = $this$handle$iv;
            boolean bl2 = false;
            SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("status", SyncControl.ActionStatus.COMPLETED.getId()), null, 2, null)};
            String sentenceSql = QueryBuilder.orderBy$default(QueryBuilder.where$default(new SimpleQueryBuilder("horus_queue_actions"), whereConditionArray, null, 2, null), "id", null, 2, null).limit(1).build();
            return (SyncControl.Action)CollectionsKt.firstOrNull(this.queryResult$client_release(sentenceSql, arg_0 -> SyncControlDatabaseHelper.getLastActionCompleted$lambda$14$lambda$13(this, arg_0)));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable it$iv = throwable2;
                boolean bl = false;
                FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
                throw it$iv;
            }
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public List<SyncControl.Action> getCompletedActionsAfterDatetime(long datetime) {
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            boolean bl = false;
            SqlDriver $this$getCompletedActionsAfterDatetime_u24lambda_u2416 = $this$handle$iv;
            boolean bl2 = false;
            SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("datetime", datetime), SQL.Comparator.GREATER_THAN)};
            QueryBuilder queryBuilder = QueryBuilder.where$default(new SimpleQueryBuilder("horus_queue_actions"), whereConditionArray, null, 2, null);
            whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("status", SyncControl.ActionStatus.COMPLETED.getId()), null, 2, null)};
            String sqlSentence = QueryBuilder.orderBy$default(QueryBuilder.where$default(queryBuilder, whereConditionArray, null, 2, null), "datetime", null, 2, null).build();
            return this.queryResult$client_release(sqlSentence, arg_0 -> SyncControlDatabaseHelper.getCompletedActionsAfterDatetime$lambda$16$lambda$15(this, arg_0));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable it$iv = throwable2;
                boolean bl = false;
                FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
                throw it$iv;
            }
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getEntityNames() {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getTableEntities$client_release();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            InternalModel.TableEntity tableEntity = (InternalModel.TableEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((InternalModel.TableEntity)((Object)it)).getName());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"horus_sync_control") || Intrinsics.areEqual((Object)it, (Object)"horus_queue_actions")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getWritableEntityNames() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getTableEntities$client_release();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (InternalModel.TableEntity)element$iv$iv;
            boolean bl = false;
            if (!((InternalModel.TableEntity)it).isWritable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (InternalModel.TableEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((InternalModel.TableEntity)it).getName());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"horus_sync_control") || Intrinsics.areEqual((Object)it, (Object)"horus_queue_actions")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<String> getEntitiesWithAttributeType(@NotNull AttributeType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        List<String> entities = this.getEntityNames();
        List output = new ArrayList();
        block0: for (String entity : entities) {
            List<Column> columns = this.getColumns$client_release(entity);
            for (Column column : columns) {
                if (column.getFormat() != type) continue;
                output.add(entity);
                continue block0;
            }
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getEntityAttributesWithType(@NotNull String entityName, @NotNull AttributeType type) {
        void $this$mapTo$iv$iv;
        Column it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Iterable $this$filter$iv = this.getColumns$client_release(entityName);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Column)element$iv$iv;
            boolean bl = false;
            if (!(it.getFormat() == type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Column)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEntityCanBeWritable(@NotNull String entityName) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
            Iterable $this$filter$iv = this.getTableEntities$client_release();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                InternalModel.TableEntity it = (InternalModel.TableEntity)element$iv$iv;
                boolean bl2 = false;
                if (!it.isWritable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InternalModel.TableEntity it = (InternalModel.TableEntity)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)entityName)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final SyncControl.Action createSyncActionFromCursor(Cursor cursor) {
        return new SyncControl.Action(((Number)cursor.getValue("id")).intValue(), SyncControl.ActionType.Companion.fromId(((Number)cursor.getValue("action_type")).intValue()), (String)cursor.getValue("entity"), SyncControl.ActionStatus.Companion.fromId(((Number)cursor.getValue("status")).intValue()), cursor.getStringAndConvertToMap("data"), TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochSeconds$default((Instant.Companion)Instant.Companion, (long)((Number)cursor.getValue("datetime")).longValue(), (long)0L, (int)2, null), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())));
    }

    private final void addAction(String entity, SyncControl.ActionType actionType, Map<String, ? extends Object> dataJSON) {
        Object object;
        SqlDriver $this$handle$iv = this.getDriver();
        boolean $i$f$handle = false;
        try {
            boolean bl = false;
            SqlDriver $this$addAction_u24lambda_u2426 = $this$handle$iv;
            boolean bl2 = false;
            QueueActionsTable this_$iv = QueueActionsTable.INSTANCE;
            boolean $i$f$mapToCreate = false;
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"action_type", (Object)actionType.getId());
            pairArray[1] = TuplesKt.to((Object)"entity", (Object)entity);
            StringFormat $this$encodeToString$iv$iv = (StringFormat)AnySerializer.INSTANCE.getDecoderJSON();
            boolean $i$f$encodeToString = false;
            SerializersModule serializersModule = $this$encodeToString$iv$iv.getSerializersModule();
            pairArray[2] = TuplesKt.to((Object)"data", (Object)$this$encodeToString$iv$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, BuiltinSerializersKt.getNullable((KSerializer)SerializersKt.noCompiledSerializer((SerializersModule)serializersModule, (KClass)Reflection.getOrCreateKotlinClass(Object.class)))), dataJSON));
            pairArray[3] = TuplesKt.to((Object)"status", (Object)SyncControl.ActionStatus.PENDING.getId());
            pairArray[4] = TuplesKt.to((Object)"datetime", (Object)SystemTime.INSTANCE.getCurrentTimestamp());
            this.insertOrThrow("horus_queue_actions", MapsKt.mapOf((Pair[])pairArray));
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl = false;
            FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
            throw it$iv;
        }
        this.emitEventActionCreated();
    }

    private final void validateIfEntityExists(String entity) {
        Object v0;
        block2: {
            Iterable iterable = this.getEntityNames();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)entity)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((String)v0 == null) {
            SyncControlDatabaseHelper $this$validateIfEntityExists_u24lambda_u2428 = this;
            boolean bl = false;
            throw new IllegalArgumentException("Entity " + entity + " does not exist");
        }
    }

    private final void emitEventActionCreated() {
        EventBus.INSTANCE.emit(EventType.ACTION_CREATED, new Event(null, 1, null));
    }

    private final void emitEntityCreated(String entity, String id, Map<String, ? extends Object> data) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"entity", (Object)entity), TuplesKt.to((Object)"id", (Object)id), TuplesKt.to((Object)"attributes", data)};
        EventBus.INSTANCE.emit(EventType.ENTITY_CREATED, new Event(MapsKt.mutableMapOf((Pair[])pairArray)));
    }

    private final void emitEntityUpdated(String entity, String id, Map<String, ? extends Object> data) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"entity", (Object)entity), TuplesKt.to((Object)"id", (Object)id), TuplesKt.to((Object)"attributes", data)};
        EventBus.INSTANCE.emit(EventType.ENTITY_UPDATED, new Event(MapsKt.mutableMapOf((Pair[])pairArray)));
    }

    private final void emitEntityDeleted(String entity, String id) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"entity", (Object)entity), TuplesKt.to((Object)"id", (Object)id)};
        EventBus.INSTANCE.emit(EventType.ENTITY_DELETED, new Event(MapsKt.mutableMapOf((Pair[])pairArray)));
    }

    private static final Boolean isStatusCompleted$lambda$2$lambda$0(SqlCursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DatabaseExtensionKt.getRequireInt(it, 0) == 1;
    }

    private static final Long getLastDatetimeCheckpoint$lambda$5$lambda$4(SqlCursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DatabaseExtensionKt.getRequireLong(it, 0);
    }

    private static final SyncControl.Action getPendingActions$lambda$11$lambda$10(SyncControlDatabaseHelper this$0, Cursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createSyncActionFromCursor(it);
    }

    private static final SyncControl.Action getLastActionCompleted$lambda$14$lambda$13(SyncControlDatabaseHelper this$0, Cursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createSyncActionFromCursor(it);
    }

    private static final SyncControl.Action getCompletedActionsAfterDatetime$lambda$16$lambda$15(SyncControlDatabaseHelper this$0, Cursor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createSyncActionFromCursor(it);
    }
}

