/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.migration.database;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apptank.horus.client.database.builder.AlterTableSQLBuilder;
import org.apptank.horus.client.database.builder.CreateTableSQLBuilder;
import org.apptank.horus.client.migration.domain.Attribute;
import org.apptank.horus.client.migration.domain.EntityScheme;
import org.apptank.horus.client.migration.domain.EntitySchemeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006Je\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2M\u0010\u0014\u001aI\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00110\u0015J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\b\u0010\u001c\u001a\u00020\u0011H\u0002J,\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00030\n*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001e\u001a\u00020\tH\u0002J \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a \u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00030\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/apptank/horus/client/migration/database/DatabaseUpgradeDelegate;", "", "schemes", "", "Lorg/apptank/horus/client/migration/domain/EntityScheme;", "<init>", "(Ljava/util/List;)V", "versionMapAttributes", "", "", "", "", "Lorg/apptank/horus/client/migration/domain/Attribute;", "versionMapEntities", "newEntitiesCreated", "", "migrate", "", "oldVersion", "currentVersion", "onExecuteSql", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "sql", "entity", "attribute", "getNewEntitiesCreated", "mapSchemes", "mapEntityAttributesVersion", "versionSearch", "mapEntitiesByVersion", "createCreateSQLTable", "scheme", "client_release"})
@SourceDebugExtension(value={"SMAP\nDatabaseUpgradeDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseUpgradeDelegate.kt\norg/apptank/horus/client/migration/database/DatabaseUpgradeDelegate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,196:1\n1863#2,2:197\n1863#2,2:200\n1863#2:203\n1863#2,2:206\n1864#2:208\n1863#2:209\n1863#2,2:210\n1863#2,2:212\n1864#2:214\n1863#2,2:215\n216#3:199\n217#3:202\n216#3,2:204\n*S KotlinDebug\n*F\n+ 1 DatabaseUpgradeDelegate.kt\norg/apptank/horus/client/migration/database/DatabaseUpgradeDelegate\n*L\n55#1:197,2\n71#1:200,2\n120#1:203\n131#1:206,2\n120#1:208\n154#1:209\n156#1:210,2\n162#1:212,2\n154#1:214\n188#1:215,2\n64#1:199\n64#1:202\n123#1:204,2\n*E\n"})
public final class DatabaseUpgradeDelegate {
    @NotNull
    private final List<EntityScheme> schemes;
    @NotNull
    private final Map<Long, Map<String, List<Attribute>>> versionMapAttributes;
    @NotNull
    private final Map<Long, List<String>> versionMapEntities;
    @NotNull
    private final List<EntityScheme> newEntitiesCreated;

    public DatabaseUpgradeDelegate(@NotNull List<EntityScheme> schemes) {
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        this.schemes = schemes;
        this.versionMapAttributes = new LinkedHashMap();
        this.versionMapEntities = new LinkedHashMap();
        this.newEntitiesCreated = new ArrayList();
    }

    public final void migrate(long oldVersion, long currentVersion, @NotNull Function3<? super String, ? super String, ? super Attribute, Unit> onExecuteSql) {
        Intrinsics.checkNotNullParameter(onExecuteSql, (String)"onExecuteSql");
        this.mapSchemes();
        long version = oldVersion + 1L;
        if (version <= currentVersion) {
            while (true) {
                Object element$iv;
                Iterator<Object> iterator;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                List newTablesAdded = new ArrayList();
                List<String> list = this.versionMapEntities.get(version);
                if (list != null) {
                    $this$forEach$iv = list;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        EntityScheme it;
                        element$iv = iterator.next();
                        String it2 = (String)element$iv;
                        boolean bl = false;
                        if (EntitySchemeKt.findByName(this.schemes, it2) == null) continue;
                        boolean bl2 = false;
                        onExecuteSql.invoke((Object)this.createCreateSQLTable(it), (Object)it.getName(), null);
                        newTablesAdded.add(it.getName());
                        this.newEntitiesCreated.add(it);
                    }
                }
                if (this.versionMapAttributes.get(version) != null) {
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Object object = element$iv = (Map.Entry)iterator.next();
                        boolean bl = false;
                        String entityName = (String)object.getKey();
                        List attrs = (List)object.getValue();
                        if (newTablesAdded.contains(entityName)) continue;
                        Iterable $this$forEach$iv2 = attrs;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            Attribute attribute = (Attribute)element$iv2;
                            boolean bl3 = false;
                            String sqlSentence = new AlterTableSQLBuilder().setTableName(entityName).setAttribute(attribute).build();
                            onExecuteSql.invoke((Object)sqlSentence, (Object)entityName, (Object)attribute);
                        }
                    }
                }
                if (version == currentVersion) break;
                ++version;
            }
        }
    }

    @NotNull
    public final List<EntityScheme> getNewEntitiesCreated() {
        return this.newEntitiesCreated;
    }

    private final void mapSchemes() {
        int startVersion = 1;
        long version = startVersion;
        long lastVersion = EntitySchemeKt.getLastVersion(this.schemes);
        if (version <= lastVersion) {
            while (true) {
                Long l = version;
                this.versionMapAttributes.put(l, this.mapEntityAttributesVersion(this.schemes, version));
                l = version;
                this.versionMapEntities.put(l, this.mapEntitiesByVersion(this.schemes, version));
                if (version == lastVersion) break;
                ++version;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<Attribute>> mapEntityAttributesVersion(List<EntityScheme> $this$mapEntityAttributesVersion, long versionSearch) {
        Map mapEntityAttributes = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$mapEntityAttributesVersion;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            EntityScheme it = (EntityScheme)element$iv;
            boolean bl = false;
            Map<String, List<Attribute>> map = this.mapEntityAttributesVersion(it.getEntitiesRelated(), versionSearch);
            boolean $i$f$forEach2 = false;
            for (Map.Entry element$iv2 : $this$forEach$iv2.entrySet()) {
                Map.Entry entry = element$iv2;
                boolean bl2 = false;
                String entityName = (String)entry.getKey();
                List attrs = (List)entry.getValue();
                mapEntityAttributes.put(entityName, attrs);
            }
            String entityName = it.getName();
            List attributes = new ArrayList();
            Iterable $this$forEach$iv3 = EntitySchemeKt.filterRelations(it.getAttributes());
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                Attribute it2 = (Attribute)element$iv3;
                boolean bl3 = false;
                if (it2.getVersion() != versionSearch) continue;
                attributes.add(it2);
            }
            mapEntityAttributes.put(entityName, attributes);
        }
        return mapEntityAttributes;
    }

    private final List<String> mapEntitiesByVersion(List<EntityScheme> $this$mapEntitiesByVersion, long versionSearch) {
        List entities = new ArrayList();
        Iterable $this$forEach$iv = $this$mapEntitiesByVersion;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityScheme it = (EntityScheme)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.mapEntitiesByVersion(it.getEntitiesRelated(), versionSearch);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String entityName = (String)element$iv2;
                boolean bl2 = false;
                entities.add(entityName);
            }
            long entryVersion = 0L;
            entryVersion = Integer.MAX_VALUE;
            Iterable $this$forEach$iv3 = it.getAttributes();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                Attribute it2 = (Attribute)element$iv3;
                boolean bl3 = false;
                if (entryVersion <= it2.getVersion()) continue;
                entryVersion = it2.getVersion();
            }
            if (entryVersion != versionSearch) continue;
            entities.add(it.getName());
        }
        return entities;
    }

    private final String createCreateSQLTable(EntityScheme scheme) {
        CreateTableSQLBuilder createTableSQLBuilder;
        CreateTableSQLBuilder $this$createCreateSQLTable_u24lambda_u2411 = createTableSQLBuilder = new CreateTableSQLBuilder();
        boolean bl = false;
        $this$createCreateSQLTable_u24lambda_u2411.setTableName(scheme.getName());
        Iterable $this$forEach$iv = EntitySchemeKt.filterRelations(scheme.getAttributes());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attribute it = (Attribute)element$iv;
            boolean bl2 = false;
            $this$createCreateSQLTable_u24lambda_u2411.addAttribute(it);
        }
        return createTableSQLBuilder.build();
    }
}

