/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client;

import android.content.Context;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import app.cash.sqldelight.db.AfterVersion;
import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.db.SqlSchema;
import app.cash.sqldelight.driver.android.AndroidSqliteDriver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apptank.horus.client.database.HorusDatabase;
import org.apptank.horus.client.di.IDatabaseDriverFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/apptank/horus/client/DatabaseDriverFactory;", "Lorg/apptank/horus/client/di/IDatabaseDriverFactory;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "getDriver", "getDatabase", "Lorg/apptank/horus/client/database/HorusDatabase;", "getDatabaseName", "", "getSchema", "Lorg/apptank/horus/client/database/HorusDatabase$Schema;", "client_release"})
public final class DatabaseDriverFactory
implements IDatabaseDriverFactory {
    @NotNull
    private final SqlDriver driver;

    public DatabaseDriverFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HorusDatabase.Schema schema = this.getSchema();
        AfterVersion[] afterVersionArray = new AfterVersion[]{};
        this.driver = (SqlDriver)new AndroidSqliteDriver((SqlSchema)this.getSchema(), context, this.getDatabaseName(), null, (SupportSQLiteOpenHelper.Callback)new AndroidSqliteDriver.Callback(schema, afterVersionArray){

            public void onOpen(SupportSQLiteDatabase db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                db.setForeignKeyConstraintsEnabled(true);
            }
        }, 0, false, null, 232, null);
    }

    @Override
    @NotNull
    public SqlDriver getDriver() {
        return this.driver;
    }

    @Override
    @NotNull
    public HorusDatabase getDatabase() {
        return new HorusDatabase(this.getDatabaseName(), this.getDriver());
    }

    @Override
    @NotNull
    public String getDatabaseName() {
        return "horus_database.db";
    }

    @Override
    @NotNull
    public HorusDatabase.Schema getSchema() {
        return HorusDatabase.Schema.INSTANCE;
    }
}

