/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.sync.upload.data;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apptank.horus.client.sync.upload.data.FileMimeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/apptank/horus/client/sync/upload/data/FileData;", "", "data", "", "filename", "", "mimeType", "<init>", "([BLjava/lang/String;Ljava/lang/String;)V", "getData", "()[B", "getFilename", "()Ljava/lang/String;", "getMimeType", "isImage", "", "getExtension", "Lorg/apptank/horus/client/sync/upload/data/FileMimeType;", "getSize", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "client_release"})
public final class FileData {
    @NotNull
    private final byte[] data;
    @NotNull
    private final String filename;
    @NotNull
    private final String mimeType;

    public FileData(@NotNull byte[] data, @NotNull String filename, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        this.data = data;
        this.filename = filename;
        this.mimeType = mimeType;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    public final boolean isImage() {
        return StringsKt.startsWith$default((String)this.mimeType, (String)"image/", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getExtension() {
        return StringsKt.substringAfterLast$default((String)this.filename, (String)".", null, (int)2, null);
    }

    @NotNull
    public final FileMimeType getMimeType() {
        FileMimeType mimeType = FileMimeType.Companion.fromType(this.mimeType);
        if (mimeType != null) {
            return mimeType;
        }
        FileMimeType fileMimeType = FileMimeType.Companion.fromExtension(this.getExtension());
        if (fileMimeType != null) {
            FileMimeType it = fileMimeType;
            boolean bl = false;
            return it;
        }
        throw new IllegalArgumentException("Invalid MIME type");
    }

    public final int getSize() {
        return this.data.length;
    }

    @NotNull
    public final byte[] component1() {
        return this.data;
    }

    @NotNull
    public final String component2() {
        return this.filename;
    }

    @NotNull
    public final String component3() {
        return this.mimeType;
    }

    @NotNull
    public final FileData copy(@NotNull byte[] data, @NotNull String filename, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return new FileData(data, filename, mimeType);
    }

    public static /* synthetic */ FileData copy$default(FileData fileData, byte[] byArray, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = fileData.data;
        }
        if ((n & 2) != 0) {
            string = fileData.filename;
        }
        if ((n & 4) != 0) {
            string2 = fileData.mimeType;
        }
        return fileData.copy(byArray, string, string2);
    }

    @NotNull
    public String toString() {
        return "FileData(data=" + Arrays.toString(this.data) + ", filename=" + this.filename + ", mimeType=" + this.mimeType + ')';
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.data);
        result = result * 31 + this.filename.hashCode();
        result = result * 31 + this.mimeType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileData)) {
            return false;
        }
        FileData fileData = (FileData)other;
        if (!Intrinsics.areEqual((Object)this.data, (Object)fileData.data)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filename, (Object)fileData.filename)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mimeType, (Object)fileData.mimeType);
    }
}

