/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.cache;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apptank.horus.client.data.InternalModel;
import org.apptank.horus.client.database.struct.Column;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0007J\u001e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u001c\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\fR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u00050\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/apptank/horus/client/cache/MemoryCache;", "", "<init>", "()V", "CACHE_TABLES", "", "", "", "Lorg/apptank/horus/client/data/InternalModel$TableEntity;", "CACHE_COLUMN_NAMES", "Lorg/apptank/horus/client/database/struct/Column;", "setTableColumnNames", "", "databaseName", "tableName", "columnNames", "getTableColumnNames", "hasTableColumnNames", "", "setTables", "tables", "getTables", "hasTables", "flushCache", "client_release"})
public final class MemoryCache {
    @NotNull
    public static final MemoryCache INSTANCE = new MemoryCache();
    @NotNull
    private static Map<String, List<InternalModel.TableEntity>> CACHE_TABLES = new LinkedHashMap();
    @NotNull
    private static Map<String, Map<String, List<Column>>> CACHE_COLUMN_NAMES = new LinkedHashMap();

    private MemoryCache() {
    }

    public final void setTableColumnNames(@NotNull String databaseName, @NotNull String tableName, @NotNull List<Column> columnNames) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
            if (CACHE_COLUMN_NAMES.get(databaseName) == null) {
                CACHE_COLUMN_NAMES.put(databaseName, new LinkedHashMap());
            }
            Map<String, List<Column>> map = CACHE_COLUMN_NAMES.get(databaseName);
            if (map == null) break block1;
            map.put(tableName, columnNames);
        }
    }

    @Nullable
    public final List<Column> getTableColumnNames(@NotNull String databaseName, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Map<String, List<Column>> map = CACHE_COLUMN_NAMES.get(databaseName);
        return map != null ? map.get(tableName) : null;
    }

    public final boolean hasTableColumnNames(@NotNull String databaseName, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Map<String, List<Column>> map = CACHE_COLUMN_NAMES.get(databaseName);
        return map != null ? map.containsKey(tableName) : false;
    }

    public final void setTables(@NotNull String databaseName, @NotNull List<InternalModel.TableEntity> tables) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        CACHE_TABLES.put(databaseName, tables);
    }

    @Nullable
    public final List<InternalModel.TableEntity> getTables(@NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        return CACHE_TABLES.get(databaseName);
    }

    public final boolean hasTables(@NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        return CACHE_TABLES.containsKey(databaseName);
    }

    public final void flushCache() {
        CACHE_TABLES = new LinkedHashMap();
        CACHE_COLUMN_NAMES = new LinkedHashMap();
    }
}

