/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.auth;

import io.ktor.util.Base64Kt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.apptank.horus.client.auth.JWTPayload;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/apptank/horus/client/auth/UserAuthentication;", "", "accessToken", "", "<init>", "(Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "userId", "getUserId", "userActingAs", "decoderJson", "Lkotlinx/serialization/json/Json;", "setUserActingAs", "", "clearUserActingAs", "isUserActingAs", "", "getActingAsUserId", "client_release"})
@SourceDebugExtension(value={"SMAP\nUserAuthentication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserAuthentication.kt\norg/apptank/horus/client/auth/UserAuthentication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,82:1\n1#2:83\n147#3:84\n*S KotlinDebug\n*F\n+ 1 UserAuthentication.kt\norg/apptank/horus/client/auth/UserAuthentication\n*L\n33#1:84\n*E\n"})
public final class UserAuthentication {
    @NotNull
    private final String accessToken;
    @NotNull
    private final String userId;
    @Nullable
    private String userActingAs;
    @NotNull
    private final Json decoderJson;

    public UserAuthentication(@NotNull String accessToken) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        this.accessToken = accessToken;
        this.decoderJson = JsonKt.Json$default(null, UserAuthentication::decoderJson$lambda$0, (int)1, null);
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)this.accessToken, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!(parts.size() == 3)) {
            boolean $i$a$-require-UserAuthentication$22 = false;
            String $i$a$-require-UserAuthentication$22 = "Invalid JWT token format.";
            throw new IllegalArgumentException($i$a$-require-UserAuthentication$22.toString());
        }
        String payloadJson = Base64Kt.decodeBase64String((String)((String)parts.get(1)));
        Json this_$iv = this.decoderJson;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        JWTPayload payload = (JWTPayload)this_$iv.decodeFromString((DeserializationStrategy)JWTPayload.Companion.serializer(), payloadJson);
        this.userId = payload.getSub();
    }

    @NotNull
    public final String getAccessToken() {
        return this.accessToken;
    }

    @NotNull
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserActingAs(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.userActingAs = userId;
    }

    public final void clearUserActingAs() {
        this.userActingAs = null;
    }

    public final boolean isUserActingAs() {
        return this.userActingAs != null;
    }

    @Nullable
    public final String getActingAsUserId() {
        return this.userActingAs;
    }

    private static final Unit decoderJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }
}

