/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.database;

import app.cash.sqldelight.db.AfterVersion;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.db.SqlSchema;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.apptank.horus.client.cache.MemoryCache;
import org.apptank.horus.client.control.scheme.EntitiesTable;
import org.apptank.horus.client.control.scheme.EntityAttributesTable;
import org.apptank.horus.client.database.SQLiteHelper;
import org.apptank.horus.client.extensions.DatabaseExtensionKt;
import org.apptank.horus.client.extensions.FunctionsKt;
import org.apptank.horus.client.migration.database.DatabaseTablesCreatorDelegate;
import org.apptank.horus.client.migration.database.DatabaseUpgradeDelegate;
import org.apptank.horus.client.migration.domain.Attribute;
import org.apptank.horus.client.migration.domain.EntityScheme;
import org.apptank.horus.client.migration.domain.EntitySchemeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\tB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lorg/apptank/horus/client/database/HorusDatabase;", "Lorg/apptank/horus/client/database/SQLiteHelper;", "databaseName", "", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "<init>", "(Ljava/lang/String;Lapp/cash/sqldelight/db/SqlDriver;)V", "getDatabaseDriver", "Schema", "client_release"})
public final class HorusDatabase
extends SQLiteHelper {
    public HorusDatabase(@NotNull String databaseName, @NotNull SqlDriver driver2) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
        super(driver2, databaseName);
    }

    @NotNull
    public final SqlDriver getDatabaseDriver() {
        return this.getDriver();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\u0004\b \u0010!J\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\"\u0010#JM\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)\u00a2\u0006\u0004\b*\u0010+JA\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0014\u0010.\u001a\u00020\u0003*\u00020\u001c2\u0006\u0010/\u001a\u00020\u001fH\u0002J\u0014\u00100\u001a\u000201*\u00020\u001c2\u0006\u00102\u001a\u000203H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015\u00a8\u00064"}, d2={"Lorg/apptank/horus/client/database/HorusDatabase$Schema;", "Lapp/cash/sqldelight/db/SqlSchema;", "Lapp/cash/sqldelight/db/QueryResult$Value;", "", "<init>", "()V", "databaseCreatorDelegate", "Lorg/apptank/horus/client/migration/database/DatabaseTablesCreatorDelegate;", "getDatabaseCreatorDelegate", "()Lorg/apptank/horus/client/migration/database/DatabaseTablesCreatorDelegate;", "setDatabaseCreatorDelegate", "(Lorg/apptank/horus/client/migration/database/DatabaseTablesCreatorDelegate;)V", "databaseUpgradeDelegate", "Lorg/apptank/horus/client/migration/database/DatabaseUpgradeDelegate;", "getDatabaseUpgradeDelegate", "()Lorg/apptank/horus/client/migration/database/DatabaseUpgradeDelegate;", "setDatabaseUpgradeDelegate", "(Lorg/apptank/horus/client/migration/database/DatabaseUpgradeDelegate;)V", "currentVersion", "", "getCurrentVersion", "()J", "setCurrentVersion", "(J)V", "version", "getVersion", "create", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "schemes", "", "Lorg/apptank/horus/client/migration/domain/EntityScheme;", "create-kCoHEHE", "(Lapp/cash/sqldelight/db/SqlDriver;Ljava/util/List;)Ljava/lang/Object;", "create-0iQ1-z0", "(Lapp/cash/sqldelight/db/SqlDriver;)Ljava/lang/Object;", "migrate", "oldVersion", "newVersion", "callbacks", "", "Lapp/cash/sqldelight/db/AfterVersion;", "migrate-0yMERmw", "(Lapp/cash/sqldelight/db/SqlDriver;JJLjava/util/List;[Lapp/cash/sqldelight/db/AfterVersion;)Ljava/lang/Object;", "migrate-zeHU3Mk", "(Lapp/cash/sqldelight/db/SqlDriver;JJ[Lapp/cash/sqldelight/db/AfterVersion;)Ljava/lang/Object;", "insertEntity", "entity", "entityNameExists", "", "entityName", "", "client_release"})
    @SourceDebugExtension(value={"SMAP\nHorusDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorusDatabase.kt\norg/apptank/horus/client/database/HorusDatabase$Schema\n+ 2 DatabaseExtension.kt\norg/apptank/horus/client/extensions/DatabaseExtensionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,232:1\n72#2,2:233\n74#2,3:237\n72#2,2:240\n74#2,3:244\n1863#3,2:235\n1863#3,2:242\n1863#3,2:249\n13409#4,2:247\n*S KotlinDebug\n*F\n+ 1 HorusDatabase.kt\norg/apptank/horus/client/database/HorusDatabase$Schema\n*L\n83#1:233,2\n83#1:237,3\n141#1:240,2\n141#1:244,3\n97#1:235,2\n159#1:242,2\n186#1:249,2\n164#1:247,2\n*E\n"})
    public static final class Schema
    implements SqlSchema<QueryResult.Value<Unit>> {
        @NotNull
        public static final Schema INSTANCE = new Schema();
        @Nullable
        private static DatabaseTablesCreatorDelegate databaseCreatorDelegate;
        @Nullable
        private static DatabaseUpgradeDelegate databaseUpgradeDelegate;
        private static long currentVersion;

        private Schema() {
        }

        @Nullable
        public final DatabaseTablesCreatorDelegate getDatabaseCreatorDelegate() {
            return databaseCreatorDelegate;
        }

        public final void setDatabaseCreatorDelegate(@Nullable DatabaseTablesCreatorDelegate databaseTablesCreatorDelegate) {
            databaseCreatorDelegate = databaseTablesCreatorDelegate;
        }

        @Nullable
        public final DatabaseUpgradeDelegate getDatabaseUpgradeDelegate() {
            return databaseUpgradeDelegate;
        }

        public final void setDatabaseUpgradeDelegate(@Nullable DatabaseUpgradeDelegate databaseUpgradeDelegate) {
            Schema.databaseUpgradeDelegate = databaseUpgradeDelegate;
        }

        public final long getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(long l) {
            currentVersion = l;
        }

        public long getVersion() {
            return currentVersion;
        }

        @NotNull
        public final Object create-kCoHEHE(@NotNull SqlDriver driver2, @NotNull List<EntityScheme> schemes) {
            Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            databaseCreatorDelegate = new DatabaseTablesCreatorDelegate(schemes);
            currentVersion = EntitySchemeKt.getLastVersion(schemes);
            return this.create-0iQ1-z0(driver2);
        }

        @NotNull
        public Object create-0iQ1-z0(@NotNull SqlDriver driver2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
            SqlDriver $this$handle$iv = driver2;
            boolean $i$f$handle = false;
            try {
                Unit unit;
                Object object2;
                boolean bl = false;
                SqlDriver $this$create_0iQ1_z0_u24lambda_u242 = $this$handle$iv;
                boolean bl2 = false;
                DatabaseExtensionKt.execute($this$create_0iQ1_z0_u24lambda_u242, "CREATE TABLE IF NOT EXISTS horus_entities (name TEXT PRIMARY KEY NOT NULL,is_writable BOOLEAN NOT NULL)");
                DatabaseExtensionKt.execute($this$create_0iQ1_z0_u24lambda_u242, "CREATE TABLE IF NOT EXISTS horus_sync_control (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,type INTEGER NOT NULL,status INTEGER NOT NULL,datetime INTEGER NOT NULL)");
                DatabaseExtensionKt.execute($this$create_0iQ1_z0_u24lambda_u242, "CREATE TABLE IF NOT EXISTS horus_queue_actions (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,action_type INTEGER NOT NULL,entity TEXT NOT NULL,data TEXT NOT NULL,status INTEGER NOT NULL,datetime INTEGER NOT NULL)");
                DatabaseExtensionKt.execute($this$create_0iQ1_z0_u24lambda_u242, "CREATE TABLE IF NOT EXISTS horus_sync_files (reference STRING PRIMARY KEY  NOT NULL,type INTEGER NOT NULL,status INTEGER NOT NULL,url_local STRING,url_remote STRING,mime_type STRING)");
                DatabaseExtensionKt.execute($this$create_0iQ1_z0_u24lambda_u242, "CREATE TABLE IF NOT EXISTS horus_entity_attributes (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,entity_name TEXT NOT NULL,attribute_name TEXT NOT NULL,type TEXT NOT NULL)");
                DatabaseTablesCreatorDelegate databaseTablesCreatorDelegate = databaseCreatorDelegate;
                if (databaseTablesCreatorDelegate != null) {
                    databaseTablesCreatorDelegate.createTables((Function1<? super String, Unit>)((Function1)arg_0 -> Schema.create_0iQ1_z0$lambda$2$lambda$0($this$create_0iQ1_z0_u24lambda_u242, arg_0)));
                }
                if ((object2 = databaseCreatorDelegate) != null && (object2 = ((DatabaseTablesCreatorDelegate)object2).getEntitiesCreated()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        EntityScheme entity = (EntityScheme)element$iv;
                        boolean bl3 = false;
                        INSTANCE.insertEntity($this$create_0iQ1_z0_u24lambda_u242, entity);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl(unit);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl = false;
                FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
                throw it$iv;
            }
            MemoryCache.INSTANCE.flushCache();
            return QueryResult.Value.constructor-impl((Object)Unit.INSTANCE);
        }

        @NotNull
        public final Object migrate-0yMERmw(@NotNull SqlDriver driver2, long oldVersion, long newVersion, @NotNull List<EntityScheme> schemes, AfterVersion ... callbacks) {
            Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
            databaseUpgradeDelegate = new DatabaseUpgradeDelegate(schemes);
            return this.migrate-zeHU3Mk(driver2, oldVersion, newVersion, Arrays.copyOf(callbacks, callbacks.length));
        }

        @NotNull
        public Object migrate-zeHU3Mk(@NotNull SqlDriver driver2, long oldVersion, long newVersion, AfterVersion ... callbacks) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
            SqlDriver $this$handle$iv = driver2;
            boolean $i$f$handle = false;
            try {
                Unit unit;
                Object object2;
                boolean bl = false;
                SqlDriver $this$migrate_zeHU3Mk_u24lambda_u246 = $this$handle$iv;
                boolean bl2 = false;
                DatabaseUpgradeDelegate databaseUpgradeDelegate = Schema.databaseUpgradeDelegate;
                if (databaseUpgradeDelegate != null) {
                    databaseUpgradeDelegate.migrate(oldVersion, newVersion, (Function3<? super String, ? super String, ? super Attribute, Unit>)((Function3)(arg_0, arg_1, arg_2) -> Schema.migrate_zeHU3Mk$lambda$6$lambda$4(driver2, $this$migrate_zeHU3Mk_u24lambda_u246, arg_0, arg_1, arg_2)));
                }
                if ((object2 = Schema.databaseUpgradeDelegate) != null && (object2 = ((DatabaseUpgradeDelegate)object2).getNewEntitiesCreated()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        EntityScheme entity = (EntityScheme)element$iv;
                        boolean bl3 = false;
                        INSTANCE.insertEntity($this$migrate_zeHU3Mk_u24lambda_u246, entity);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl(unit);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl = false;
                FunctionsKt.logException("Error SQLDriver: " + it$iv.getMessage(), it$iv);
                throw it$iv;
            }
            MemoryCache.INSTANCE.flushCache();
            AfterVersion[] $this$forEach$iv = callbacks;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                AfterVersion element$iv;
                AfterVersion it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (newVersion < it.getAfterVersion()) continue;
                it.getBlock().invoke((Object)driver2);
            }
            currentVersion = newVersion;
            return QueryResult.Value.constructor-impl((Object)Unit.INSTANCE);
        }

        private final void insertEntity(SqlDriver $this$insertEntity, EntityScheme entity) {
            try {
                if (this.entityNameExists($this$insertEntity, entity.getName())) {
                    return;
                }
                DatabaseExtensionKt.execute($this$insertEntity, DatabaseExtensionKt.createSQLInsert($this$insertEntity, "horus_entities", EntitiesTable.INSTANCE.mapToCreate(entity.getName(), entity.isWritable())));
                Iterable $this$forEach$iv = entity.getAttributes();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Attribute it = (Attribute)element$iv;
                    boolean bl = false;
                    DatabaseExtensionKt.execute($this$insertEntity, DatabaseExtensionKt.createSQLInsert($this$insertEntity, "horus_entity_attributes", EntityAttributesTable.INSTANCE.mapToCreate(entity.getName(), it.getName(), it.getType())));
                }
            }
            catch (Exception e) {
                FunctionsKt.logException("[Migration] Error insert entity", e);
            }
        }

        private final boolean entityNameExists(SqlDriver $this$entityNameExists, String entityName) {
            return ((Number)SqlDriver.DefaultImpls.executeQuery$default((SqlDriver)$this$entityNameExists, null, (String)("SELECT COUNT(*) FROM horus_entities WHERE name = '" + entityName + '\''), Schema::entityNameExists$lambda$9, (int)0, null, (int)16, null).getValue()).longValue() > 0L;
        }

        private static final Unit create_0iQ1_z0$lambda$2$lambda$0(SqlDriver $this_handle, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            SqlDriver.DefaultImpls.execute$default((SqlDriver)$this_handle, (Integer)Random.Default.nextInt(), (String)it, (int)0, null, (int)8, null);
            FunctionsKt.info("[Migration] Created table: " + it);
            return Unit.INSTANCE;
        }

        private static final Unit migrate_zeHU3Mk$lambda$6$lambda$4(SqlDriver $driver, SqlDriver $this_handle, String sql, String entity, Attribute attribute) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                SqlDriver.DefaultImpls.execute$default((SqlDriver)$driver, (Integer)Random.Default.nextInt(), (String)sql, (int)0, null, (int)8, null);
                FunctionsKt.info("[Migration: Alter] Executed: " + sql);
                Attribute attribute2 = attribute;
                if (attribute2 == null) break block0;
                Attribute it = attribute2;
                boolean bl = false;
                DatabaseExtensionKt.execute($this_handle, DatabaseExtensionKt.createSQLInsert($this_handle, "horus_entity_attributes", EntityAttributesTable.INSTANCE.mapToCreate(entity, it.getName(), it.getType())));
            }
            return Unit.INSTANCE;
        }

        private static final QueryResult entityNameExists$lambda$9(SqlCursor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (!((Boolean)it.next().getValue()).booleanValue()) {
                return (QueryResult)QueryResult.Value.box-impl((Object)QueryResult.Value.constructor-impl((Object)0L));
            }
            Long l = it.getLong(0);
            long count = l != null ? l : 0L;
            return (QueryResult)QueryResult.Value.box-impl((Object)QueryResult.Value.constructor-impl((Object)count));
        }

        static {
            currentVersion = 1L;
        }
    }
}

