/*
 * Decompiled with CFR 0.152.
 */
package org.apptank.horus.client.restrictions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apptank.horus.client.auth.HorusAuthentication;
import org.apptank.horus.client.control.helper.IOperationDatabaseHelper;
import org.apptank.horus.client.database.builder.QueryBuilder;
import org.apptank.horus.client.database.builder.SimpleQueryBuilder;
import org.apptank.horus.client.database.struct.SQL;
import org.apptank.horus.client.exception.OperationNotPermittedException;
import org.apptank.horus.client.restrictions.EntityRestriction;
import org.apptank.horus.client.restrictions.MaxCountEntityRestriction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0006\u0010\u0015\u001a\u00020\u0013J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\u0013J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/apptank/horus/client/restrictions/EntityRestrictionValidator;", "", "operationDatabaseHelper", "Lorg/apptank/horus/client/control/helper/IOperationDatabaseHelper;", "<init>", "(Lorg/apptank/horus/client/control/helper/IOperationDatabaseHelper;)V", "entityMapRestrictions", "", "", "", "Lorg/apptank/horus/client/restrictions/EntityRestriction;", "queueOperations", "", "Lorg/apptank/horus/client/restrictions/EntityRestriction$OperationType;", "validationStarted", "", "countQueryCache", "", "setRestrictions", "", "restrictions", "startValidation", "validate", "entityName", "operationType", "finishValidation", "validateEntityMaxCount", "maxCount", "throwNotPermitted", "message", "client_release"})
@SourceDebugExtension(value={"SMAP\nEntityRestrictionValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityRestrictionValidator.kt\norg/apptank/horus/client/restrictions/EntityRestrictionValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,138:1\n1485#2:139\n1510#2,3:140\n1513#2,3:150\n1863#2,2:153\n774#2:155\n865#2,2:156\n381#3,7:143\n*S KotlinDebug\n*F\n+ 1 EntityRestrictionValidator.kt\norg/apptank/horus/client/restrictions/EntityRestrictionValidator\n*L\n47#1:139\n47#1:140,3\n47#1:150,3\n79#1:153,2\n120#1:155\n120#1:156,2\n47#1:143,7\n*E\n"})
public final class EntityRestrictionValidator {
    @NotNull
    private final IOperationDatabaseHelper operationDatabaseHelper;
    @NotNull
    private Map<String, ? extends List<? extends EntityRestriction>> entityMapRestrictions;
    @NotNull
    private Map<String, List<EntityRestriction.OperationType>> queueOperations;
    private boolean validationStarted;
    @NotNull
    private final Map<String, Integer> countQueryCache;

    public EntityRestrictionValidator(@NotNull IOperationDatabaseHelper operationDatabaseHelper) {
        Intrinsics.checkNotNullParameter((Object)operationDatabaseHelper, (String)"operationDatabaseHelper");
        this.operationDatabaseHelper = operationDatabaseHelper;
        this.entityMapRestrictions = MapsKt.emptyMap();
        this.queueOperations = new LinkedHashMap();
        this.countQueryCache = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public final void setRestrictions(@NotNull List<? extends EntityRestriction> restrictions) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(restrictions, (String)"restrictions");
        Iterable iterable = restrictions;
        EntityRestrictionValidator entityRestrictionValidator = this;
        boolean $i$f$groupBy = false;
        void var4_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            EntityRestriction it = (EntityRestriction)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getEntityName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        entityRestrictionValidator.entityMapRestrictions = destination$iv$iv;
    }

    public final void startValidation() {
        if (this.validationStarted) {
            throw new IllegalStateException("Validation has already started.");
        }
        this.validationStarted = true;
    }

    public final void validate(@NotNull String entityName, @NotNull EntityRestriction.OperationType operationType) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
        if (!this.validationStarted) {
            throw new IllegalStateException("Validation has not been started.");
        }
        List<? extends EntityRestriction> list = this.entityMapRestrictions.get(entityName);
        if (list == null) {
            return;
        }
        List<? extends EntityRestriction> restrictions = list;
        Map<String, List<EntityRestriction.OperationType>> map = this.queueOperations;
        List list2 = this.queueOperations.get(entityName);
        if (list2 == null || (list2 = CollectionsKt.plus((Collection)list2, (Object)((Object)operationType))) == null) {
            list2 = CollectionsKt.listOf((Object)((Object)operationType));
        }
        List list3 = list2;
        map.put(entityName, list3);
        Iterable $this$forEach$iv = restrictions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityRestriction it = (EntityRestriction)element$iv;
            boolean bl = false;
            if (!(it instanceof MaxCountEntityRestriction)) continue;
            this.validateEntityMaxCount(((MaxCountEntityRestriction)it).getEntity(), ((MaxCountEntityRestriction)it).getMaxCount(), operationType);
        }
    }

    public final void finishValidation() {
        if (!this.validationStarted) {
            throw new IllegalStateException("Validation has not been started.");
        }
        this.validationStarted = false;
        this.queueOperations.clear();
        this.countQueryCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void validateEntityMaxCount(String entityName, int maxCount, EntityRestriction.OperationType operationType) {
        int n;
        int n2;
        if (operationType != EntityRestriction.OperationType.INSERT) {
            return;
        }
        SQL.WhereCondition[] whereConditionArray = new SQL.WhereCondition[]{new SQL.WhereCondition(new SQL.ColumnValue("sync_owner_id", HorusAuthentication.INSTANCE.getEffectiveUserId$client_release()), null, 2, null)};
        QueryBuilder queryBuilder = QueryBuilder.where$default(new SimpleQueryBuilder(entityName), whereConditionArray, null, 2, null);
        List<EntityRestriction.OperationType> list = this.queueOperations.get(entityName);
        if (list != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EntityRestriction.OperationType it = (EntityRestriction.OperationType)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it == EntityRestriction.OperationType.INSERT)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n2 = ((List)destination$iv$iv).size();
        } else {
            n2 = 0;
        }
        int countInserts = n2;
        Integer n3 = this.countQueryCache.get(entityName);
        if (n3 != null) {
            n = n3;
        } else {
            int n4;
            Intrinsics.checkNotNull((Object)queryBuilder, (String)"null cannot be cast to non-null type org.apptank.horus.client.database.builder.SimpleQueryBuilder");
            int it = n4 = this.operationDatabaseHelper.countRecords((SimpleQueryBuilder)queryBuilder);
            boolean bl = false;
            Integer n5 = it;
            this.countQueryCache.put(entityName, n5);
            n = n4;
        }
        int count = n;
        int newCountExpected = count + countInserts;
        if (newCountExpected > maxCount) {
            this.throwNotPermitted("Max count of " + entityName + " reached. (Max: " + maxCount + ')');
        }
    }

    private final void throwNotPermitted(String message) {
        this.finishValidation();
        throw new OperationNotPermittedException(message);
    }
}

