package org.apptank.horus.client.config

/**
 * Constants used throughout the application for database configuration, boolean values, and logging tags.
 * These constants are designed to be reused across multiple components for consistency.
 *
 * @author John Ospina
 * @year 2024
 */

// Name of the database file
const val DATABASE_NAME = "horus_database.db"

// Internal representation of a boolean true value in string format
internal const val BOOL_TRUE = "1"

// Internal representation of a boolean false value in string format
internal const val BOOL_FALSE = "0"

// Tag used for logging messages related to Horus synchronization processes
internal const val TAG_LOGGING = "Horus"
