/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"LShell;", "", "()V", "findInPath", "", "", "tool", "which", "check", "", "action-toolkit"})
public final class Shell {
    @NotNull
    public static final Shell INSTANCE = new Shell();

    private Shell() {
    }

    @NotNull
    public final String which(@NotNull String tool, boolean check) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        if (((CharSequence)tool).length() == 0) {
            throw new Error("parameter 'tool' is required");
        }
        if (check) {
            String result = this.which(tool, false);
            if (((CharSequence)result).length() == 0) {
                if (ShellKt.getIS_WINDOWS()) {
                    throw new Error("Unable to locate executable file: " + tool + ". Please verify either the file path exists or the file can be found within a directory specified by the PATH environment variable. Also verify the file has a valid extension for an executable file.");
                }
                throw new Error("Unable to locate executable file: " + tool + ". Please verify either the file path exists or the file can be found within a directory specified by the PATH environment variable. Also check the file mode to verify the file is executable.");
            }
            return result;
        }
        List<String> matches = this.findInPath(tool);
        if (!((Collection)matches).isEmpty()) {
            return matches.get(0);
        }
        return "";
    }

    public static /* synthetic */ String which$default(Shell shell, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return shell.which(string, bl);
    }

    @NotNull
    public final List<String> findInPath(@NotNull String tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        if (((CharSequence)tool).length() == 0) {
            throw new Error("parameter 'tool' is required");
        }
        List extensions = new ArrayList();
        if (ShellKt.getIS_WINDOWS() && System.getenv("PATHEXT") != null) {
            String string = System.getenv("PATHEXT");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(\"PATHEXT\")");
            char[] cArray = new char[]{File.pathSeparatorChar};
            for (Object extension : StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                if (!(((CharSequence)extension).length() > 0)) continue;
                extensions.add(extension);
            }
        }
        if (ShellKt.isRooted(tool)) {
            String filePath = ShellKt.tryGetExecutablePath(new File(tool), extensions);
            if (filePath != null) {
                return CollectionsKt.listOf((Object)filePath);
            }
            return CollectionsKt.emptyList();
        }
        CharSequence charSequence = tool;
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        List directories = new ArrayList();
        if (System.getenv("PATH") != null) {
            String string2 = System.getenv("PATH");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getenv(\"PATH\")");
            Object object = new char[1];
            object[0] = File.pathSeparatorChar;
            for (String p : StringsKt.split$default((CharSequence)string2, (char[])object, (boolean)false, (int)0, (int)6, null)) {
                if (!(((CharSequence)p).length() > 0)) continue;
                directories.add(p);
            }
        }
        List matches = new ArrayList();
        for (String directory : directories) {
            String filePath = ShellKt.tryGetExecutablePath(new File(directory, tool), extensions);
            if (filePath == null) continue;
            matches.add(filePath);
        }
        return matches;
    }
}

