/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000e"}, d2={"IS_WINDOWS", "", "getIS_WINDOWS", "()Z", "isRooted", "p", "", "isUnixExecutable", "file", "Ljava/io/File;", "tryGetExecutablePath", "filePath", "extensions", "", "action-toolkit"})
@SourceDebugExtension(value={"SMAP\nShell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shell.kt\nShellKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1747#2,3:171\n*S KotlinDebug\n*F\n+ 1 Shell.kt\nShellKt\n*L\n40#1:171,3\n*E\n"})
public final class ShellKt {
    private static final boolean IS_WINDOWS;

    public static final boolean getIS_WINDOWS() {
        return IS_WINDOWS;
    }

    public static final boolean isRooted(@NotNull String p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (((CharSequence)p).length() == 0) {
            throw new Exception("isRooted() parameter \"p\" cannot be empty");
        }
        return IS_WINDOWS ? StringsKt.startsWith$default((String)p, (String)"\\", (boolean)false, (int)2, null) || new Regex("^[A-Z]:", RegexOption.IGNORE_CASE).containsMatchIn((CharSequence)p) : StringsKt.startsWith$default((String)p, (String)"/", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final String tryGetExecutablePath(@NotNull File filePath, @NotNull List<String> extensions) {
        File stats;
        block17: {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
            stats = null;
            try {
                stats = filePath;
            }
            catch (Exception err) {
                if (Intrinsics.areEqual((Object)err.getMessage(), (Object)"ENOENT")) break block17;
                System.out.println((Object)("Unexpected error attempting to determine if executable file exists '" + filePath + "': " + err));
            }
        }
        if (stats != null && stats.isFile()) {
            if (IS_WINDOWS) {
                boolean bl;
                block18: {
                    String string = FilesKt.getExtension((File)filePath).toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase()");
                    String upperExt = string;
                    Iterable $this$any$iv = extensions;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String validExt = (String)element$iv;
                            boolean bl2 = false;
                            String string2 = validExt.toUpperCase();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase()");
                            if (!Intrinsics.areEqual((Object)string2, (Object)upperExt)) continue;
                            bl = true;
                            break block18;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return filePath.getAbsolutePath();
                }
            } else if (ShellKt.isUnixExecutable(stats)) {
                return filePath.getAbsolutePath();
            }
        }
        File originalFilePath = filePath;
        for (String extension : extensions) {
            File filePath2;
            block19: {
                filePath2 = new File(originalFilePath.getAbsolutePath() + extension);
                stats = null;
                try {
                    stats = filePath2;
                }
                catch (Exception err) {
                    if (Intrinsics.areEqual((Object)err.getMessage(), (Object)"ENOENT")) break block19;
                    System.out.println((Object)("Unexpected error attempting to determine if executable file exists '" + filePath2 + "': " + err));
                }
            }
            if (stats == null || !stats.isFile()) continue;
            if (IS_WINDOWS) {
                try {
                    File directory = filePath2.getParentFile();
                    String string = filePath2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.name");
                    String string3 = string.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase()");
                    String upperName = string3;
                    String[] stringArray = directory.list();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"directory.list()");
                    for (String actualName : stringArray) {
                        Intrinsics.checkNotNullExpressionValue((Object)actualName, (String)"actualName");
                        String string4 = actualName.toUpperCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase()");
                        if (!Intrinsics.areEqual((Object)upperName, (Object)string4)) continue;
                        filePath2 = new File(directory, actualName);
                        break;
                    }
                }
                catch (Exception err) {
                    System.out.println((Object)("Unexpected error attempting to determine the actual case of the file '" + filePath2 + "': " + err));
                }
                return filePath2.getAbsolutePath();
            }
            if (!ShellKt.isUnixExecutable(stats)) continue;
            return filePath2.getAbsolutePath();
        }
        return null;
    }

    public static final boolean isUnixExecutable(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
        return permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE) || permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE) || permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        IS_WINDOWS = StringsKt.contains$default((CharSequence)string3, (CharSequence)"win", (boolean)false, (int)2, null);
    }
}

