/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.action.exec;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import org.archguard.action.exec.ExecOptions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\u000e\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Lorg/archguard/action/exec/Command;", "", "()V", "doExecute", "", "processBuilder", "Ljava/lang/ProcessBuilder;", "options", "Lorg/archguard/action/exec/ExecOptions;", "exec", "commandLine", "", "args", "", "execJar", "workdir", "Companion", "action-toolkit"})
@SourceDebugExtension(value={"SMAP\nCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Command.kt\norg/archguard/action/exec/Command\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,66:1\n37#2,2:67\n37#2,2:69\n*S KotlinDebug\n*F\n+ 1 Command.kt\norg/archguard/action/exec/Command\n*L\n12#1:67,2\n21#1:69,2\n*E\n"})
public final class Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public final int execJar(@NotNull List<String> args, @NotNull String workdir, @NotNull ExecOptions options) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)workdir, (String)"workdir");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)"java");
        spreadBuilder.add((Object)"-jar");
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        ProcessBuilder processBuilder = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        return this.doExecute(processBuilder, options);
    }

    public static /* synthetic */ int execJar$default(Command command, List list, String string, ExecOptions execOptions, int n, Object object) {
        if ((n & 4) != 0) {
            execOptions = new ExecOptions(string, null, false, false, null, 30, null);
        }
        return command.execJar(list, string, execOptions);
    }

    public final int exec(@NotNull String commandLine, @NotNull List<String> args, @NotNull ExecOptions options) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!options.getSilent()) {
            logger.info("Executing: " + commandLine + ' ' + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)commandLine);
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        ProcessBuilder processBuilder = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        return this.doExecute(processBuilder, options);
    }

    public static /* synthetic */ int exec$default(Command command, String string, List list, ExecOptions execOptions, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return command.exec(string, list, execOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int doExecute(ProcessBuilder processBuilder, ExecOptions options) {
        int n;
        Reader it2;
        Process process = processBuilder.directory(new File(options.getCwd())).start();
        int exitCode = process.waitFor();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n2 = 8192;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
        object = null;
        try {
            it2 = (BufferedReader)closeable;
            n = 0;
            TextStreamsKt.forEachLine((Reader)it2, (Function1)((Function1)new Function1<String, Unit>(options){
                final /* synthetic */ ExecOptions $options;
                {
                    this.$options = $options;
                    super(1);
                }

                public final void invoke(@NotNull String line) {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    this.$options.getListeners().stdout(line);
                }
            }));
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            object = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        if (exitCode != 0 && !options.getIgnoreReturnCode()) {
            InputStream inputStream2 = process.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"process.errorStream");
            closeable = inputStream2;
            object = Charsets.UTF_8;
            it2 = new InputStreamReader((InputStream)closeable, (Charset)object);
            n = 8192;
            closeable = it2 instanceof BufferedReader ? it2 : new BufferedReader(it2, n);
            object = null;
            try {
                it2 = (BufferedReader)closeable;
                boolean bl = false;
                TextStreamsKt.forEachLine((Reader)it2, (Function1)((Function1)new Function1<String, Unit>(options){
                    final /* synthetic */ ExecOptions $options;
                    {
                        this.$options = $options;
                        super(1);
                    }

                    public final void invoke(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        this.$options.getListeners().stderr(line);
                    }
                }));
                reader = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        return exitCode;
    }

    static {
        Logger logger = LoggerFactory.getLogger(Command.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Command::class.java)");
        Command.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\b\b\u0002\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/archguard/action/exec/Command$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "exec", "", "commandLine", "", "args", "", "options", "Lorg/archguard/action/exec/ExecOptions;", "action-toolkit"})
    public static final class Companion {
        private Companion() {
        }

        public final int exec(@NotNull String commandLine, @NotNull List<String> args, @NotNull ExecOptions options) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new Command().exec(commandLine, args, options);
        }

        public static /* synthetic */ int exec$default(Companion companion, String string, List list, ExecOptions execOptions, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                execOptions = new ExecOptions(null, null, false, false, null, 31, null);
            }
            return companion.exec(string, list, execOptions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

